<div x-cloak x-show="filtersOpen">
    <div class="row mb-4">
        @foreach ($this->getFilters() as $filter)
            @if (!$filter->isVisibleInMenus())
                @if ($filter->hasConfig('filter_name') && $filter->getConfig('filter_name') == 'division')
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                        <x-search.divisions wire:model.stop="{{ $this->getTableName() }}.filters.{{ $filter->getKey() }}"
                            label="{{ $filter->getName() }}" :placeholder="$filter->hasConfig('placeholder') ? $filter->getConfig('placeholder') : null" />
                    </div>
                @elseif($filter->hasConfig('filter_name') && $filter->getConfig('filter_name') == 'district')
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                        <x-search.districts wire:model.stop="{{ $this->getTableName() }}.filters.{{ $filter->getKey() }}"
                            :division="$this->{$this->getTableName()}['filters']['division']" label="{{ $filter->getName() }}" :placeholder="$filter->hasConfig('placeholder') ? $filter->getConfig('placeholder') : null" />
                    </div>
                @elseif ($filter->hasConfig('filter_name') && $filter->getConfig('filter_name') == 'upazila')
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                        <x-search.upazilas wire:model.stop="{{ $this->getTableName() }}.filters.{{ $filter->getKey() }}"
                            :district="isset($this->{$this->getTableName()}['filters']['districts'])
                                ? $this->{$this->getTableName()}['filters']['districts']
                                : null" label="{{ $filter->getName() }}" :placeholder="$filter->hasConfig('placeholder') ? $filter->getConfig('placeholder') : null" />
                    </div>
       
                @elseif ($filter->hasConfig('filter_name') && $filter->getConfig('filter_name') == 'submit_date')
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                        <x-search.demand_revisions
                            wire:model.stop="{{ $this->getTableName() }}.filters.{{ $filter->getKey() }}"
                            label="{{ $filter->getName() }}" :placeholder="$filter->hasConfig('placeholder') ? $filter->getConfig('placeholder') : null" />
                    </div>
                @elseif ($filter->hasConfig('filter_name') && $filter->getConfig('filter_name') == 'approval_date')
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                        <x-search.demand_revisions
                            wire:model.stop="{{ $this->getTableName() }}.filters.{{ $filter->getKey() }}"
                            label="{{ $filter->getName() }}" :placeholder="$filter->hasConfig('placeholder') ? $filter->getConfig('placeholder') : null" />
                    </div>
            
                @elseif ($filter->hasConfig('filter_name') && $filter->getConfig('filter_name') == 'tom_select')
                    <div class="mb-2 col-12 col-sm-6 col-md-4 col-lg-3">
                        <x-input.select-tom wire:model="{{ $this->getTableName() }}.filters.{{ $filter->getKey() }}"
                            :multiple="$filter->hasConfig('multiple') ? $filter->getConfig('multiple') : false" label="{{ $filter->getName() }}" :placeholder="$filter->hasConfig('placeholder') ? $filter->getConfig('placeholder') : null" require="true"
                            :options="$filter->getOptions()" />
                    </div>
                @else
                    <div class="mb-2 col-12 col-sm-6 col-md-4 col-lg-3">
                        <div class="form-group mt-2">
                            {{-- <label class="form-label"
                                for="{{ $component->getTableName() }}-filter-{{ $filter->getKey() }}">
                                {{ $filter->getName() }}
                            </label> --}}
                            <div class="form-control-wrap">
                                {{ $filter->render($component) }}
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        @endforeach
    </div>
</div>
