@aware(['component', 'tableName'])

@if ($component->collapsingColumnsAreEnabled() && $component->hasCollapsedColumns())
    @if ($component->isTailwind())
        <th
            scope="col"
            {{
                $attributes
                    ->merge(['class' => 'table-cell dark:bg-gray-800 laravel-livewire-tables-reorderingMinimised'])
                    ->class([
                        'md:hidden' => !$component->shouldCollapseAlways() && (
                            ($component->shouldCollapseOnMobile() && $component->shouldCollapseOnTablet()) ||
                            ($component->shouldCollapseOnTablet() && ! $component->shouldCollapseOnMobile())
                        )
                    ])
                    ->class(['sm:hidden' => !$component->shouldCollapseAlways() && $component->shouldCollapseOnMobile() && ! $component->shouldCollapseOnTablet()])
            }}
            :class="{ 'laravel-livewire-tables-reorderingMinimised': ! currentlyReorderingStatus }"
        ></th>
    @elseif ($component->isBootstrap())
        <th
            scope="col"
            {{
                $attributes
                    ->merge(['class' => 'd-table-cell laravel-livewire-tables-reorderingMinimised'])
                    ->class([
                        'd-md-none' => !$component->shouldCollapseAlways() && 
                            ( ($component->shouldCollapseOnMobile() && $component->shouldCollapseOnTablet()) ||
                            ($component->shouldCollapseOnTablet() && ! $component->shouldCollapseOnMobile()))
                    ])
                    ->class(['d-sm-none' => !$component->shouldCollapseAlways() && $component->shouldCollapseOnMobile() && ! $component->shouldCollapseOnTablet()])
            }}
            :class="{ 'laravel-livewire-tables-reorderingMinimised': ! currentlyReorderingStatus }"
        ></th>
    @endif
@endif
