<?php

use App\Http\Controllers\V1\CsApiController;
use App\Http\Controllers\V1\FfwcDataController;
use App\Http\Controllers\V1\GwApiController;
use App\Http\Controllers\V1\OdApiController;
use App\Http\Controllers\V1\OsdApiController;
use App\Http\Controllers\V1\RfApiController;
use App\Http\Controllers\V1\StationController;
use App\Http\Controllers\V1\SwApiController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'v1', 'as' => 'v1.'], function () {
    Route::group(['middleware' => 'token_check'], function () {
        Route::match(['get', 'post'], '{package}/sw/{type}/json', [SwApiController::class, 'getSwJson'])->name('surface_water_json');
        Route::match(['get', 'post'], '{package}/sw/{type}/csv', [SwApiController::class, 'getSwCsv'])->name('surface_water_csv');
        Route::match(['get', 'post'], '{package}/gw/{type}/json', [GwApiController::class, 'getGwJson'])->name('ground_water_json');
        Route::match(['get', 'post'], '{package}/gw/{type}/csv', [GwApiController::class, 'getGwCsv'])->name('ground_water_csv');
        Route::match(['get', 'post'], '{package}/sw-manual/{type}/csv', [SwApiController::class, 'getSwManualCsv'])->name('surface_water_manual_csv');

        Route::match(['get', 'post'], '{package}/wl-station/{type}/json', [StationController::class, 'wlStationJson'])->name('waterlevel_station_json');
        Route::match(['get', 'post'], '{package}/rf-station/{type}/json', [StationController::class, 'rfStationJson'])->name('rainfall_station_json');
        Route::match(['get', 'post'], '{package}/wl-data/{type}/json', [FfwcDataController::class, 'wlObservationJson'])->name('waterlevel_station_json');
        Route::match(['get', 'post'], '{package}/rf-data/{type}/json', [FfwcDataController::class, 'rfObservationJson'])->name('rainfall_station_json');
        Route::match(['get', 'post'], '{package}/awl-data/{type}/json', [StationController::class, 'waterLevelData'])->name('waterlevel_station_data');
        Route::match(['get', 'post'], '{package}/arf-data/{type}/json', [StationController::class, 'rainFallData'])->name('rainfall_station_data');
        Route::match(['get', 'post'], '{package}/arf-station-list/{type}/json', [StationController::class, 'stationListARF'])->name('rainfall_station_list');
        Route::match(['get', 'post'], '{package}/wa-data/{type}/json', [StationController::class, 'weatherAutoData'])->name('weather_auto_data');
        Route::match(['get', 'post'], '{package}/sw-station/{type}/json', [StationController::class, 'swManualStationJson'])->name('sw_station_manual_data');
        Route::match(['get', 'post'], '{package}/sw-station-by-type/{type}/json', [StationController::class, 'swStationByTypeJson'])->name('sw_station_manual_data');
        Route::match(['get', 'post'], '{package}/swl-data/{type}/json', [SwApiController::class, 'getSwManualJson'])->name('swl_manual_data');
        Route::match(['get', 'post'], '{package}/rf-m-data/{type}/json', [RfApiController::class, 'getRfDataManualJson'])->name('rf_manual_data');
        Route::match(['get', 'post'], '{package}/od-m-data/{type}/json', [OdApiController::class, 'getOdDataManualJson'])->name('od_manual_data');
        Route::match(['get', 'post'], '{package}/cs-m-data/{type}/json', [CsApiController::class, 'getCsDataManualJson'])->name('cs_manual_data');
        Route::match(['get', 'post'], '{package}/osd-m-data/{type}/json', [OsdApiController::class, 'getOsdDataManualJson'])->name('osd_manual_data');

    });
});
