import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import path from "path";
import livewire from "@defstudio/vite-livewire-plugin";

export default defineConfig({
    plugins: [
        laravel({
            input: [
                "resources/js/backend.js",
                "resources/sass/backend.scss",
                "resources/js/frontend.js",
                "resources/sass/frontend.scss",
            ],
            refresh: true,
        }),
        livewire({
            refresh: ["resources/js/backend.js", "resources/js/frontend.js"],
        }),
    ],
    resolve: {
        alias: {
            "~bootstrap": path.resolve(__dirname, "node_modules/bootstrap"),
        },
    },
});
