<?php
	session_start();
	include("../../asset/theme/css/myfunc.php");
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	
	$device_tbl = "GW_STATION_AUTO_MANUAL";
	$device_cols ="*";
?>

<table  id="am_station_datatable"c class="table table-bordered table-striped">
	<thead>
		<th></th>
		<th>New ID</th>
		<th>Old ID</th>
		
		<th>Location</th>
		<th>Hydro-Division Name</th>
		<th>Hydro-Sub-Division Name</th>
		
		<th>District Name</th>
		<th>Upazila Name</th>
		<th>Latitude</th>
		
		<th>Longitude</th>
		<th></th>
	</thead>
	<tbody>
		<?php 
			$row_num = 0;
			foreach($obj->View_all_data_row_column_By_Cond($device_tbl,$device_cols,"data_read_type in ('AUTO','BOTH') ORDER BY STATION_CODE ASC,DIVISION_NAME ASC,DISTRICT_NAME ASC,UPZL_NAME ASC") as $device_info_list){
				$row_num++;
		?>
			<tr>
				<td>
					<button class="btn btn-minier btn-success" type="button" id="btn_save_<?php echo $row_num; ?>" onclick="set_device_info('<?php echo $row_num; ?>')">
						<i class="icon-check"></i> Select
					</button>
				</td>
				<td><?php echo $device_info_list['STATION_CODE']; ?>
					<input type="hidden" name="p_new_id_<?php echo $row_num; ?>" id="p_new_id_<?php echo $row_num; ?>" value="<?php echo $device_info_list['STATION_CODE']; ?>" />
				</td>
				<td><?php echo $device_info_list['OLD_ID']; ?>
					<input type="hidden" name="p_old_id_<?php echo $row_num; ?>" id="p_old_id_<?php echo $row_num; ?>" value="<?php echo $device_info_list['OLD_ID']; ?>" />
				</td>
				<td><?php echo $device_info_list['AUTO_NAME']; ?></td>
				<td><?php echo $device_info_list['DIVISION_NAME']; ?></td>
				<td><?php echo $device_info_list['SUBDIVISION_NAME']; ?></td>
				<td><?php echo $device_info_list['DISTRICT_NAME']; ?>
					<input type="hidden" name="p_dist_name_<?php echo $row_num; ?>" id="p_dist_name_<?php echo $row_num; ?>" value="<?php echo $device_info_list['DISTRICT_NAME']; ?>" />
				</td>
				<td><?php echo $device_info_list['UPZL_NAME']; ?>
					<input type="hidden" name="p_upa_name_<?php echo $row_num; ?>" id="p_upa_name_<?php echo $row_num; ?>" value="<?php echo $device_info_list['UPZL_NAME']; ?>" />	
				</td>
				<td><?php echo $device_info_list['AUTO_LAT']; ?></td>
				<td><?php echo $device_info_list['AUTO_LONG']; ?></td>
				<td> 
					<button class="btn btn-minier btn-success" type="button" id="btn_save_<?php echo $row_num; ?>" onclick="set_device_info('<?php echo $row_num; ?>')">
						<i class="icon-check"></i> Select
					</button>
				</td>
			</tr>
	<?php } ?>
	</tbody>
</table>
<script type="text/javascript">
$(document).ready(function() {
    var oTable2 = $('#am_station_datatable').DataTable({
        "columns": [
            { "orderable": true },
            null,null, null,null, null,null,
            { "orderable": true }
        ],
        "iDisplayLength": 50
    });
});
</script>