<?php
include("../../php_crud/my_class.php");
$obj = new my_class();
session_start();
extract($_REQUEST);

$where = "STAT.DATA_READ_TYPE IN ('AUTO','BOTH') AND STATUS_TBL.RAW_PARAMETER_ID='474' AND STATUS_TBL.STATION_TYPE='AUTO'";
// print_r($where);

$label = "";
if ($hydro_div == "all") {
	$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND RAW_PARAMETER_ID='474' AND STATION_TYPE='AUTO'";
	$label = "Ground Water Stations Status Information for All Hydro-Division";
	// print_r($where);
} else {
	if ($hydro_div != "" && $hydro_sub_div == "all" && $district == "") {
		$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
		$hydro_div_name = "<b><font color='#3d0099'>" . $hydro_div_info['DIVISION_NAME'] . "</font></b>";
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='474' AND HYDDIVCODE='$hydro_div'";
		$label = "Ground Water Stations Status Information for Hydro-Division: $hydro_div_name";
	} else if ($hydro_div != "" && $hydro_sub_div == "all" && $district != "") {
		$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
		$hydro_div_name = "<b><font color='#3d0099'>" . $hydro_div_info['DIVISION_NAME'] . "</font></b>";
		
		$dist_info = $obj->Details_By_Cond("HYDROLOGY.DISTRICT_TBL@HYDRO10", "DISTRICT_NO='$district'");
		$dist_name = "<b><font color='#3d0099'>" . $dist_info['DISTRICT_NAME'] . "</font></b>";
		
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='474' 
		AND HYDDIVCODE='$hydro_div' AND DISTRICT_NO='$district'";
		$label = "Ground Water Stations Status Information for Hydro-Division: $hydro_div_name and District: $dist_name";
	} else if ($hydro_div != "" && $hydro_sub_div != "" && $district == "") {
		$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
		$hydro_div_name = "<b><font color='#3d0099'>" . $hydro_div_info['DIVISION_NAME'] . "</font></b>";
		$hydro_sub_div_info = $obj->Details_By_Cond("HYDROLOGY.GW_SUBDIVCODE_TBL@HYDRO10", "HYDSUBDIVCODE='$hydro_sub_div'");
		$hydro_sub_div_name = "<b><font color='#3d0099'>" . $hydro_sub_div_info['SUBDIVISION_NAME'] . "</font></b>";
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='474' 
		AND HYDDIVCODE='$hydro_div' AND HYDSUBDIVCODE='$hydro_sub_div'";
		$label = "Ground Water Stations Status Information for Hydro-Division: $hydro_div_name and Hydro-Subdivision: $hydro_sub_div_name";
	} else if ($hydro_div != "" && $hydro_sub_div != "" && $district != "") {
		$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
		$hydro_div_name = "<b><font color='#3d0099'>" . $hydro_div_info['DIVISION_NAME'] . "</font></b>";
		$hydro_sub_div_info = $obj->Details_By_Cond("HYDROLOGY.GW_SUBDIVCODE_TBL@HYDRO10", "HYDSUBDIVCODE='$hydro_sub_div'");
		$hydro_sub_div_name = "<b><font color='#3d0099'>" . $hydro_sub_div_info['SUBDIVISION_NAME'] . "</font></b>";
		$dist_info = $obj->Details_By_Cond("HYDROLOGY.DISTRICT_TBL@HYDRO10", "DISTRICT_NO='$district'");
		$dist_name = "<b><font color='#3d0099'>" . $dist_info['DISTRICT_NAME'] . "</font></b>";
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='474' 
		AND HYDDIVCODE='$hydro_div' AND HYDSUBDIVCODE='$hydro_sub_div' AND DISTRICT_NO='$district'";
		$label = "Ground Water Stations Status Information for Hydro-Division: $hydro_div_name, Hydro-Subdivision: $hydro_sub_div_name and District: $dist_name";
	} else {
		$label = "Ground Water Stations Status Information";
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='474'";
		// print_r($where);

	}
}


$status_label = "Status type: ";
if ($sw_status == 0) {
	$where = $where . "";
	$status_label .= "<b><font color='#8B008B'>Active & Inactive</font></b>";
} else if ($sw_status == 3) {
	$where = $where . " AND STATION_STATUS='ACTIVE'";
	$status_label .= "<b><font color='#228B22'>Active</font></b>";
} else if ($sw_status == 2) {
	$where = $where . " AND STATION_STATUS='INACTIVE' AND DIFF_HOURS<='72' AND DIFF_HOURS>='24'";
	$status_label .= "<b><font color='#000080'>Inactive for 24-72 Hours</font></b>";
} else if ($sw_status == 1) {
	$where = $where . " AND STATION_STATUS='INACTIVE' AND DIFF_HOURS>'72'";
	$status_label .= "<b><font color='#FF0000'>Inactive for more than 72 Hours</font></b>";
	// print_r($status_label);
} else if ($sw_status == 4) {
	$diff_hours_input = $inactive_days * 24;
	$where = $where . " AND STATION_STATUS='INACTIVE' AND DIFF_HOURS>'$diff_hours_input'";
	$status_label .= "<b><font color='#b30000'>Inactive for more than $inactive_days days</font></b>";
} else if ($sw_status == 5) {
	$where = $where . " AND STATION_STATUS='INACTIVE'";
	$status_label .= "<b><font color='#FF0000'>Active</font></b>";
}  else {
	$where = $where . "";
	$status_label .= "<b><font color='#8B008B'>Active & Inactive</font></b>";
}
//echo $where; exit;
?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.8.1/css/all.css" rel="stylesheet" media="all" type="text/css" />
<div style="margin-top: 20px;">
	<h4><?php echo "$label, $status_label"; ?></h4>
	<h6 style="font-style: italic; font-weight: bold;">
		<font style='color: #228B22;'>* Active or inactive for 24 hours</font>,
		<font style='color: #000080;'>* Inactive for 24-72 hours</font>,
		<font style='color: #ff3300;'>* Inactive for more than 72 hours,</font>
		<font style='color: #ff0066;'>* The Last Received Date is in the future ewr</font>
	</h6>
	<table id="ground_water_tbl" class="table table-striped table-bordered table-hover">
		<thead>
			<tr style="font-family: 'Open Sans';">
				<td style="text-align: center;font-size:13px;" class="table-header">Sl</td>
				<td style="text-align: center;font-size:13px;" class="table-header">Well Id</td>
				<!-- <td style="text-align: center;font-size:13px;" class="table-header">Auto RL</td> -->
				<td style="text-align: center;font-size:13px;" class="table-header">District</td>
				<td style="text-align: center;font-size:13px;" class="table-header">Upazila</td>
				<td style="text-align: center;font-size:13px;" class="table-header">Lattitude</td>
				<td style="text-align: center;font-size:13px;" class="table-header">Longitude</td>
				<td style="text-align: center;font-size:13px;" class="table-header">From Date</td>
				<td style="text-align: center;font-size:13px;" class="table-header">To Date</td>
				<td style="text-align: center;font-size:13px;" class="table-header">Action</td>
			</tr>
		</thead>

		<tbody>
			<?php

			$sl = 0;
			foreach ($obj->load_graph_datatable($where) as $value) {
				// print_r($value);
				$sl++;
				$color_status = "";
				$well_id = $value['STATION_ID'];
				$rl_id = $value['AUTO_RL'];
				$last_rec_date = $value['LASTRECEIVE_DATE'];
				
				$database_date_obj = DateTime::createFromFormat('d-M-y', $last_rec_date);
				$database_date_obj->setTime(0, 0, 0);
				$current_date_obj = new DateTime();
				$current_date_obj->setTime(0, 0, 0);
				
				if ($value['DIFF_HOURS'] > 72) {
					$color_status = "color: #ff3300;";
				} else if ($value['DIFF_HOURS'] <= 72 && $value['DIFF_HOURS'] > 24) {
					$color_status = "color: #000080;";
				} else if ($value['DIFF_HOURS'] <= 24) {
					$color_status = "color: #228B22;";
				}
				
				$font_weight = "";
				if ($database_date_obj > $current_date_obj) {
					$color_status = "color: #ff0066;";
					$font_weight = "font-weight: bold;";
				}
				// print_r($color_status);
			?>
				<tr>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $sl; ?></td>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $well_id; ?></td>
					<!-- <td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $rl_id; ?></td> -->
					<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $value['DISTRICT_NAME']; ?></td>
					<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $value['UPZL_NAME']; ?></td>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $value['AUTO_LAT']; ?></td>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $value['AUTO_LONG']; ?></td>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $value['FIRSTRECEIVE_DATE']; ?></td>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>"><?php echo $value['LASTRECEIVE_DATE']; ?></td>
					<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>">
						<a class="label label-primary btn btn-small " onclick="show_graph('<?php echo $well_id ?>','<?php echo $rl_id ?>','<?php echo $last_rec_date ?>')"><i class="icon-bar-chart"></i>Show Graph</a>
					</td>
				</tr>
			<?php } ?>

		</tbody>
	</table>
</div>

<script type="text/javascript">
	var oTable2 = $('#ground_water_tbl').dataTable({
		"aoColumns": [{
				"bSortable": true
			},
			null,null,null, null,null,null, null,
			{
				"bSortable": true
			}
		],
		"iDisplayLength": 50
	});
</script>