$(document).ready(function(){
	load_upazila_table();
});

function load_upazila_form(){
	$("#modal_body_add_upazila").load("module/ground_water/upazila_add_form.php");
}

function load_upazila_table(){
	//$('#division_list_holder').load('module/ground_water/division_datatbl.php');
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/upazila_datatbl.php",
		success:function(st){
			$('#cover-spin').hide();
			$('#upazila_list_holder').html(st);
		}
	});
}

function load_sub_div(sel_div_id){
	var form_type = "entry";
	var datastr = "form_type="+form_type+"&sel_div_id="+sel_div_id;
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_sub_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#sub_div_code_holder').html(st);
		}
	});
	
}

function e_load_sub_div(sel_div_id){
	var form_type = "edit";
	var datastr = "form_type="+form_type+"&sel_div_id="+sel_div_id;
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_sub_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#e_sub_div_code_holder').html(st);
		}
	});
	
}

function load_dist_list_by_sub_div(sel_sub_div_id){
	var form_type = "entry";
	var datastr = "form_type="+form_type+"&sel_sub_div_id="+sel_sub_div_id;
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_dist_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#sub_dist_code_holder').html(st);
		}
	});
}

function e_load_dist_list_by_sub_div(sel_sub_div_id){
	var form_type = "edit";
	var datastr = "form_type="+form_type+"&sel_sub_div_id="+sel_sub_div_id;
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_dist_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#e_sub_dist_code_holder').html(st);
		}
	});
}

function save_upazila(){
	var operation = "insert";
	var division_code = $("#division_code").val();
	var sub_division_code = $("#sub_division_code").val();
	var district_code = $("#district_code").val();
	var upazila_code = $("#upazila_code").val();
	var upazila_name = $("#upazila_name").val();
	
	var dataStr = "division_code="+division_code+"&sub_division_code="+sub_division_code+"&district_code="+district_code+"&upazila_code="+upazila_code+
	"&upazila_name="+upazila_name+"&operation="+operation;
	
	if(division_code==""){
		toastr.error("Please Select Division");
		$("#division_code").focus();
		return false;
	}
	else if(sub_division_code==""){
		toastr.error("Please Select Sub Division");
		$("#sub_division_code").focus();
		return false;
	}
	else if(district_code==""){
		toastr.error("Please Select District Code");
		$("#district_code").focus();
		return false;
	}
	else if(upazila_code==""){
		toastr.error("Please mention Upazila Code");
		$("#upazila_code").focus();
		return false;
	}
	else if(upazila_name==""){
		toastr.error("Please mention Upazila Name");
		$("#upazila_name").focus();
		return false;
	}
	else {
	//	alert(dataStr);
		$('#cover-spin').show();
		$.ajax({
			type:"post",
			url:"module/ground_water/upazila_crud.php",
			data:dataStr,
			cache:false,
			success:function(st){
				$('#cover-spin').hide();
				//alert(st);
				if(st=="1") {
					toastr.success('Upazila Information Successfully Saved.');
					$('#modal_add_upazila').modal('hide');
					load_upazila_table();
				}else{
					toastr.error('Failed to Save Upazila. Please Try Again');
				}
			}
		});
	}
}

function load_upazila_edit_form(sel_up_id){
	var datastr = "sel_up_id="+sel_up_id;
	//alert(datastr);
	$('#upazila_edit_body').load('module/ground_water/upazila_edit_form.php',datastr);
}

function update_upazila_info(){
	var operation = "update";
	var e_sel_id = $("#e_sel_id").val();
	var e_division_code = $("#e_division_code").val();
	var e_sub_division_code = $("#e_sub_division_code").val();
	var e_district_code = $("#e_district_code").val();
	var e_upazila_code = $("#e_upazila_code").val();
	var e_upazila_name = $("#e_upazila_name").val();
	var e_status = $("#e_up_status").val();
	
	var dataStr = "operation="+operation+"&e_sel_id="+e_sel_id+"&e_division_code="+e_division_code+
	"&e_sub_division_code="+e_sub_division_code+"&e_district_code="+e_district_code+"&e_upazila_code="+e_upazila_code+
	"&e_upazila_name="+e_upazila_name+"&e_status="+e_status;
	
	if(e_division_code==""){
		toastr.error("Please Select Division");
		$("#e_division_code").focus();
		return false;
	}
	else if(e_sub_division_code==""){
		toastr.error("Please Select Sub Division");
		$("#e_sub_division_code").focus();
		return false;
	}
	else if(e_district_code==""){
		toastr.error("Please Select District Code");
		$("#e_district_code").focus();
		return false;
	}
	else if(e_upazila_code==""){
		toastr.error("Please mention Upazila Code");
		$("#e_upazila_code").focus();
		return false;
	}
	else if(e_upazila_name==""){
		toastr.error("Please mention Upazila Name");
		$("#e_upazila_name").focus();
		return false;
	}
	else {
		//alert(dataStr);
		$('#cover-spin').show();
		$.ajax({
			type:"post",
			url:"module/ground_water/upazila_crud.php",
			data:dataStr,
			cache:false,
			success:function(st){
				$('#cover-spin').hide();
				//alert(st);
				if(st=="1") {
					toastr.success('Upazila Information Successfully Updated.');
					$('#upazila_edit_modal').modal('hide');
					load_upazila_table();
				}else{
					toastr.error('Failed to Update Upazila. Please Try Again');
				}
			}
		});
	}
}

function delete_upazila(sel_id){
	var operation = "delete";
	var datastr = "operation="+operation+"&sel_id="+sel_id;
	//alert(datastr);
	var result = confirm("Are you sure you want to delete data?");
	if (!result) {
		
	} 
	else {
		$('#cover-spin').show();
		$.ajax({			
			type:"post" ,
			url:"module/ground_water/upazila_crud.php",
			data:datastr,
			success:function(st){
				//alert(st);
				$('#cover-spin').hide();
				if(st=="1"){
					toastr.success("Upazila has been deleted successfully");
					load_upazila_table();
				}
				else{
					toastr.error("Error occurred during deleting upazila");
				}
			}
		});
	}
}