<?php
session_start();
include("../../php_crud/my_class.php");
include("../../asset/theme/css/myfunc.php");
$obj = new my_class();

?>
<!--map link start-->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.3/leaflet.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.3/leaflet.js"></script>
<script src="module/ground_water/js/leaflet-providers.js"></script>
<!--map link end-->
<script src="module/ground_water/js/module_dashboard.js" type="text/javascript"></script>
<style>
        /*map css start*/
        #map {
                width: 100%;
                height: 100vh;
        }

        .map-info-box {
                background-color: #fff;
                border: 1px solid #d3d3d3;
                width: 250px;
                /* height:300px;  */
                padding: 10px;
                border-radius: 12px;
                z-index: 500;
                position: absolute;
                right: 45px;
                top: 165px;
                cursor: auto;
                display: none;
                /* Initially hide the info box */
        }

        .close {
                font-size: 25px;
                font-weight: 600;
                cursor: pointer;
                float: right;
        }

        /*pop up start*/
        .custom-table {
                border-collapse: collapse;
                width: 100%;
                border: 1px solid #70a1ff;
        }

        .custom-table td,
        .custom-table th {
                border: 1px solid #70a1ff;
                color: #fff;
                background: #3742fa;
                text-align: left;

        }

        .custom-table th {
                background-color: #f2f2f2;
        }
		.leaflet-popup-close-button {
		  //background-color: red !important; /* Use !important to override default Leaflet styles if needed */
		  color: red !important;
		  font-size: 1.5em; /* Adjust the size as needed */
		  border-radius: 5px; /* Add rounded corners if you like */
		  padding: 2px 5px !important; /* Add some padding for better visual appearance */
		  opacity: 1 !important; /* Ensure it's fully visible */
		}
        /*pop up end*/
        /*map css end*/
</style>
<?php
foreach ($obj->View_colmn_By_Cond(
        "GW_STATION_AUTO_MANUAL GWT LEFT JOIN HYDROLOGY_STATIONS_CURRENT_STATUS GWT_STATUS ON GWT.AUTO_ORIGIN_CODE=GWT_STATUS.STATION_ID ",
        "GWT_STATUS.STATION_ID AS WELL_ID,GWT.DISTRICT_NAME,GWT.UPZL_NAME,GWT.MANUAL_LAT,GWT.MANUAL_LON,GWT.AUTO_LAT,GWT.AUTO_LONG,GWT_STATUS.LASTRECEIVE_DATE,GWT_STATUS.LASTRECEIVE_DATA,GWT_STATUS.STATION_STATUS,GWT.DATA_READ_TYPE ",
        "GWT.DATA_READ_TYPE in ('BOTH','AUTO') AND GWT.MANUAL_LAT IS NOT NULL AND GWT.MANUAL_LON IS NOT NULL AND GWT.AUTO_LAT IS NOT NULL AND GWT.AUTO_LONG IS NOT NULL 
         AND GWT_STATUS.STATION_TYPE='AUTO' AND GWT_STATUS.RAW_PARAMETER_ID='474' ORDER BY WELL_ID ASC"
) as $gwa_watertable) {
        //var_dump($gwa_watertable);
        $well_id               =  $gwa_watertable['WELL_ID'];
        $district_name         =  $gwa_watertable['DISTRICT_NAME'];
        $upazila_name          =  $gwa_watertable['UPZL_NAME'];
        $wt_last_read_date     =  $gwa_watertable['LASTRECEIVE_DATE'];
        $wt_last_read_val      =  $gwa_watertable['LASTRECEIVE_DATA'];
        $data_type             =  $gwa_watertable['STATION_STATUS'];
        //echo $data_type ;

        if ($data_type == 'ACTIVE') {
                $marker_icon = 'asset/custom/dashboard_active_map.png';
        } else {
                $marker_icon = 'asset/custom/dashboard_inactive_map.png';
        }
        if ($gwa_watertable['DATA_READ_TYPE'] == 'BOTH') {
                $latitude              =  $gwa_watertable['MANUAL_LAT'];
                $longitude             =  $gwa_watertable['MANUAL_LON'];
        } else {
                $latitude              =  $gwa_watertable['AUTO_LAT'];
                $longitude             =  $gwa_watertable['AUTO_LONG'];
        }


        $gwa_wt_well_id         = "";
        $gwa_wt_dist            = "";
        $gwa_wt_upzl            = "";
        $gwa_wt_lat             = "";
        $gwa_wt_lon             = "";
        $gwa_wt_last_rev_date   = "";
        $gwa_wt_last_read_data  = "";


        if ($well_id  == '') {
                $gwa_wt_well_id     = '-';
        } else {
                $gwa_wt_well_id  = $well_id;
        }
        if ($district_name == '') {
                $gwa_wt_dist    = '-';
        } else {
                $gwa_wt_dist   = $district_name;
        }
        if ($upazila_name == '') {
                $gwa_wt_upzl  = '-';
        } else {
                $gwa_wt_upzl  =  $upazila_name;
        }
        if ($latitude  == '') {
                $gwa_wt_lat    = '-';
        } else {
                $gwa_wt_lat   = $latitude;
        }
        if ($longitude  == '') {
                $gwa_wt_lon = '-';
        } else {
                $gwa_wt_lon = $longitude;
        }
        if ($wt_last_read_date == '') {
                $gwa_wt_last_rev_date  = '-';
        } else {
                $gwa_wt_last_rev_date  = $wt_last_read_date;
        }
        if ($wt_last_read_val == '') {
                $gwa_wt_last_read_data  = '-';
        } else {
                $gwa_wt_last_read_data  = $wt_last_read_val . 'm';
        }
        $gwa_watertable_districts[] = [
                'new_id'             =>  $gwa_wt_well_id,
                'lat'                =>  $gwa_wt_lat,
                'lon'                =>  $gwa_wt_lon,
                'district_name'      =>  $gwa_wt_dist,
                'upazila_name'       =>  $gwa_wt_upzl,
                'last_read_date'     =>  $gwa_wt_last_rev_date,
                'last_read_val'      =>  $gwa_wt_last_read_data,
                'marker_icon'        =>  $marker_icon,
        ];
}
//print_r($gwa_watertable_districts);
?>
<!--district search start-->
<div class="row-fluid" style="background-color:#f5f5f5; -webkit-box-shadow:0px 8px 6px -6px black; -moz-box-shadow:0px 8px 6px -6px black; box-shadow:opx 8px 6px -6px black; margin-bottom:15px;">
    <div class="span3"  style="padding-bottom:20px; padding-top:8px; padding-left:15px;">
    <div class="control-group">
            <label  class="control-level"for="district"><b>District Name</b><font style="color:#FF0000"></font></label>
            <div class="controls" style="width: 100%">
                <select name="mor_district" id="mor_district" class="chosen-select" onchange="load_gwa_wt_district_no_by_district(this.value)">
                    <option value="">--select district--</option>
                    <?php
                    $table_name ='hydrology.DISTRICT_TBL@HYDRO10';
                    $columns ='*';
                    $where_cond ='1=1';
                    foreach($obj->View_colmn_By_Cond($table_name,$columns,$where_cond) as $district_list){
                      echo '<option value="'.$district_list['DISTRICT_NO'].'">'.$district_list['DISTRICT_NAME'].'</option>';
                    }
                    ?>
                </select>
	
            </div>
        </div>
    </div>
</div>
<!--district search end-->
  <!-- <b onclick="ground_water_automated_watertable()" class="hover-effect">Ground Water Quality</b>  -->
<div class="col-sm-12" id='map_holder_gt'>
        <div id="gwa-watertable-map" style="width: 100%; height: 650px"></div>
</div>
<script type="text/javascript">
      //  ground_water_automated_watertable();
      $(document).ready(function() {
        setTimeout(function() {
        ground_water_automated_watertable();
    }, 100); // Delay execution by 100 milliseconds (adjust as needed)
});

// $(document).ready(function() {
//    ground_water_automated_watertable();
// });

// window.onload = function(){
//      ground_water_automated_watertable(); // Call your function when the window is loaded
// };
        function ground_water_automated_watertable(){
                //alert ('ground_water_automated_watertable');
                var gwa_watertable_map = L.map('gwa-watertable-map').setView([23.8103, 90.4125], 7);
              
                //alert(gwa_watertable_map);
                //    var gwaWatertableIcon = L.icon({
                // 	//iconUrl: 'http://www.hydrology.bwdb.gov.bd/map_icons/gww_removebg-preview.png',
                // 	 iconUrl: '../asset/custom/hydro_map_icon.png',
                //          iconSize:[16, 16], // size of the icon		
                //    });

                // Add the OpenStreetMap tile layer to the map
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        // attribution: 'Map data © OpenStreetMap contributors',
                        maxZoom: 18
                }).addTo(gwa_watertable_map);
                // Common coordinates for the markers
                // Add markers for each district with popups on hover   
                var gwa_wt_districts = <?php echo json_encode($gwa_watertable_districts); ?>;
               // alert(gwa_wt_districts);
                gwaWatertableMapInfoBox = document.getElementById('gwa-water-table-dis');
                var gwawtPointer = document.getElementById('gwa-watertable-pointer');

                for (var i = 0; i < gwa_wt_districts.length; i++) {
                        (function(index) {
                                var gwa_wt_district = gwa_wt_districts[index];
                                var marker = L.marker([gwa_wt_district.lat, gwa_wt_district.lon], {
                                        icon: L.icon({
                                                iconUrl: gwa_wt_district.marker_icon,
                                                iconSize: [13, 13],
                                        }),
                                }).addTo(gwa_watertable_map);
                                map_data_gwt = '<table class="custom-table">' +
                                        '<tr><td>Well Id</td><td style = "background:#1e90ff;" >' + gwa_wt_district.new_id + '</td></tr>' +
                                        '<tr><td>District Name</td><td style = "background:#1e90ff;" >' + gwa_wt_district.district_name + '</td></tr>' +
                                        '<tr><td>Upzila Name</td><td style = "background:#1e90ff;" >' + gwa_wt_district.upazila_name + '</td></tr>' +
                                        '<tr><td>Latitude</td><td style = "background:#1e90ff;" >' + gwa_wt_district.lat + '</td></tr>' +
                                        '<tr><td>Longitude</td><td style = "background:#1e90ff;" >' + gwa_wt_district.lon + '</td></tr>' +
                                        '<tr><td style = "background:#0c2461;">Last Receive Date</td><td style = "background:#0c2461;" >' + gwa_wt_district.last_read_date + '</td></tr>' +
                                        '<tr><td style = "background:#0c2461;">Last Read Value</td><td style = "background:#0c2461;" >' + gwa_wt_district.last_read_val + '</td></tr>' +
                                        '</table>';

                                marker.bindPopup(map_data_gwt, {
                                        autoPan: false,
                                        closeButton: true, // To disable the close button on the popup
                                        autoClose: false, // To keep the popup open on mouseout
                                        closeOnClick: false, // To keep the popup open when clicking on it
                                }).on('popupopen', function(event) {
                                        var popup = event.popup;
                                });
                                // Add event listener to display the popup on hover
                                marker.on('mouseover', function(e) {
                                        marker.openPopup();
                                });
								/*marker.on('mouseout', function(e) {
									marker.closePopup();
								});*/
                        })(i);
                }
        }
        </script>
          <script>
    $('.chosen-select').chosen({allow_single_deselect:true}); 
	//resize the chosen on window resize
	$(window)
	.off('resize.chosen')
	.on('resize.chosen', function() {
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width': '100%'});
		})
	}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if(event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function(){
			 var $this = $(this);
			 $this.next().css({'width':'100%'});
		})
	});

</script>


