<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
?>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.8.1/css/all.css" rel="stylesheet" media="all" type="text/css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script src="module/ground_water_ex/js/evaporation_entry_form.js" type="text/javascript"></script>

<div id="cover-spin"></div>
 
<div class="table-header"><i class="fas fa-th-list"></i> Evaporation Information</div>

<div class="row-fluid" style="margin-top: -4px;">
	<div class="widget-header widget-header-large">
		<div class="widget-toolbar no-border">
			<ul class="nav nav-tabs" id="myTab">
				<li class="active">
					<a data-toggle="tab" href="#data_entry" onClick="loadDeForm()">Data Entry</a>
				</li>
				<li>
					<a data-toggle="tab" href="#data_upload" onClick="loadExcelData()">Excel Upload</a>
				</li>
			</ul>  
		</div>
	</div>
</div>
<input type="hidden" style="width: 95%;" id="act_tab_name" name="act_tab_name" value="data_entry" />

<div class="row-fluid" style="padding-bottom: 10px; margin-top: -4px; background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black;">
	<div class="widget-body" style="border: none;  background-color: #f5f5f5;">
		<div class="widget-main padding-5">
			<div class="tab-content" style="overflow: visible; position: sticky; z-index: 999;">
				<div id="data_entry" class="tab-pane in active">
					<div class="span3">
						<div class="control-group">
							<label class="control-label" for="station_id"><b>Station ID<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 98%">
								<select id="station_id" name="station_id" class="chosen-select" onchange=load_station_by_station_id(this.value)> 
									<option value=""></option>
									<?php
									$table_name = 'EVAPORATION_CUP_TBL EC_TBL LEFT JOIN SW_STATION_TBL STAT_TBL ON EC_TBL.STATION_ID=STAT_TBL.STATION_ID';
									$columns = 'DISTINCT EC_TBL.STATION_ID,STAT_TBL.STATION_NAME';
									$where_cond = '1=1 ORDER BY STATION_ID ASC';

									foreach($obj->View_colmn_By_Cond_hydro($table_name,$columns,$where_cond) as $station_id){
									echo '<option value="'.$station_id['STATION_ID'].'">'.$station_id['STATION_ID'].' ('.$station_id['STATION_NAME'].')'.'</option>'; 
									}
									?>
								</select>
								<input type="hidden" id="station_name_holder">
							</div>
						</div>
					</div>
					<!--Year Field Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="year"><b>Year<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%;">
								<input type="text" style="width: 97%; height: 14px !important;" id="ev_year" name="ev_year" value="<?php echo date('Y'); ?>" maxlength="4"/>
							</div>
						</div>
					</div>
					<!--Year Field Ends-->
					<!--Month Fields Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="month"><b>Month<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%">
								<select id="ev_month" name="ev_month" style="height: 12px !important;" class="chosen-select" onchange="flushData()">
									<option value=""></option>
									<option value="01">January</option>
									<option value="02">February</option>
									<option value="03">March</option>
									<option value="04">April</option>
									<option value="05">May</option>
									<option value="06">June</option>
									<option value="07">July</option>
									<option value="08">August</option>
									<option value="09">September</option>
									<option value="10">October</option>
									<option value="11">November</option>
									<option value="12">December</option>
								</select>
							</div> 
						</div>
					</div>
					<!--Month Field Ends-->
					<div class="span3" style="margin-top: 22px;">
						<div class="control-group">
							<div class="controls">
								  <button type ="button" onclick="load_evaporation_info()" id="ei_find_btn" class="btn btn-minier btn-info" style="padding: 4px !important;"><i class="icon-search"></i> <b style="font-size: 12px;">Show Data</b></button>
							</div>
						</div>
					</div>
				</div>
			
				<div id="data_upload" class="tab-pane">
					<div class="span4">
						<div class="control-group">
							<label class="control-label" for="station_id_excel"><b>Station ID<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 70%">
								<select id="station_id_excel" name="station_id_excel" class="chosen-select" onchange=load_station_by_station_id_excel(this.value)> 
									<option value=""></option>
									<?php
									$table_name = 'EVAPORATION_CUP_TBL EC_TBL LEFT JOIN SW_STATION_TBL STAT_TBL ON EC_TBL.STATION_ID=STAT_TBL.STATION_ID';
									$columns = 'DISTINCT EC_TBL.STATION_ID,STAT_TBL.STATION_NAME';
									$where_cond = '1=1 ORDER BY STATION_ID ASC';

									foreach($obj->View_colmn_By_Cond_hydro($table_name,$columns,$where_cond) as $station_id){
									echo '<option value="'.$station_id['STATION_ID'].'">'.$station_id['STATION_ID'].' ('.$station_id['STATION_NAME'].')'.'</option>'; 
									}
									?>
								</select>
								<input type="hidden" id="station_name_holder_excel">
							</div>
						</div>
					</div>

					<div class="span4">
						<div class="control-group" style="margin-left: -30px; margin-right: 30px;">
							<label class="control-label" for="file"><b>Select File<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%;">
								<!--<input class="ace-file-input" type="file" name="rf_file" id="rf_file" accept=".xlsx">-->
								<input class="ace-file-input" type="file" name="ee_file" id="ee_file" accept="application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
							</div>
						</div>
					</div>
					<div class="span4">
						<div class="control-group" style="margin-top: 25px;">
							<div class="controls">
								<button type ="button" id="ei_up_btn" class="btn btn-minier btn-success" style="padding: 4px !important;" onclick="load_ei_excl_data()">
									<i class="icon-upload"></i> <b style="font-size: 12px;">Upload</b>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row-fluid" style="margin-top: 10px;">
    <div class="col-sm-6 widget-container-col" id="widget-container-col-10">
	    <div class="widget-box" id="widget-box-10">
		    <div class="widget-header widget-header-large">
				<div class="widget-toolbar no-border">
					<ul class="nav nav-tabs" id="myTab">
						<li class="active">
							<a data-toggle="tab" href="#data_list">Data List</a>
						</li>
						<li>
							<a data-toggle="tab" href="#eva_graph_data" onclick="load_evaporation_graph()">Graph Data</a>
						</li>
					</ul>
				</div>
			</div>
			    <!--for grap-->
			<div class="widget-body">
				<div class="widget-main padding-5">
					<div class="tab-content">
					<!-- <div class="btn-group" style="float: right;">
						<button id="rf_sva_btn" style="display: none;" class="btn btn-small btn-success" type="button" onclick="save_all_rf_data()">
							<i class="icon-save"></i> <b style="font-size: 12px;">Save All</b>
						</button>
					</div> -->
						<div id="data_list" class="tab-pane in active">
							<div id="view_ei_data"></div> 
						</div>
						
						<div id="eva_graph_data" class="tab-pane">     
							<div id='eva_curve_chart'></div>
              			</div>
					</div>
			    </div>
			 </div>
			<!--end graph-->
		</div>
	</div>
</div>

<script>
	$(".date-picker").datepicker( {
		format: "mm-yyyy",
		viewMode: "months", 
		minViewMode: "months"
	});
	
    $('.chosen-select').chosen({allow_single_deselect:true}); 
	//resize the chosen on window resize
	$(window)
	.off('resize.chosen')
	.on('resize.chosen', function() {
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width': '100%'});
		})
	}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if(event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width':'100%'});
		})
	});
    // $('#file').ace_file_input({
	// 	no_file:'No File ...',
	// 	btn_choose:'Choose',
	// 	btn_change:'Change',
	// 	droppable:false,
	// 	onchange:null,
	// 	thumbnail:false
	// });
</script>

<script>
	function load_ei_excl_data(){
		//alert('load_ei_excl_data');
		var station_id = $("#station_id_excel").val();  
		// alert(station_id);	
		if(!station_id){
			alert('Please Select Station');
		}
		else{
			/*var station_arr = station_id.split("#");
			var station_id = station_arr[0];
			var station_name = station_arr[1];*/
			var form_url = "module/ground_water_ex/excel_ei_data_upload.php"; 		 
			var formData = new FormData();
			formData.append('station_id', station_id);
			formData.append('ee_file', $('#ee_file')[0].files[0]);
	
			var excelFile = $('#ee_file').val();
		
			var parse = excelFile.split('.');
			if(parse[parse.length-1] != "xlsx" && parse[parse.length-1] != "xls") {
			   alert("Please Select excel File");
			   return false;
			}else{
				$('#cover-spin').show(0);
				$.ajax({
					type:'post',
					url: form_url,		
					data: formData,
					contentType: false,
					processData: false,						 
					success:function(res){
						// alert(res);
						$('#cover-spin').hide();
						$("#view_ei_data").html('');
						$("#hidden-btn").css({"display":"block"});
						$("#view_ei_data").html(res);	
						$('#ci_1').select();
					}					
				});   
			}
		}
		return false;
	}
	
	$('#ee_file').ace_file_input({
		no_file:'No File ...',
		btn_choose:'Choose',
		btn_change:'Change',
		droppable:false,
		onchange:null,
		thumbnail:false
	});
</script>