function load_gwt_daily_old_id_by_district_id(sel_district_id){
	$('#gw_daily_graph_holder').html("");
	var datastr = "sel_district_id="+sel_district_id;
	//alert(datastr);
	$("#gwt_daily_old_id_list_holder").load('module/ground_water_ex/gwt_daily_old_id_by_district.php',datastr);
}

function load_gwt_daily_new_id_by_old_id(well_id){
	$('#gw_daily_graph_holder').html("");
	$("#gwt_daily_well_id").val(well_id);
}

function load_gwt_daily_graph_holder(){
	var district = $('#gwt_daily_district').val();
	var well_id = $('#gwt_daily_well_id').val();
    var from_year = $('#gwt_daily_from_year').val();
    var to_year = $('#gwt_daily_to_year').val();

    var datastr = "well_id="+well_id+"&from_year="+from_year+"&to_year="+to_year;	
	if (!well_id) {
		alert('Please Select Well');
		$("#gwt_daily_well_id").focus();
		return false;
	}
	else if (!from_year) {
		alert('Please select From Year');
		$("#gwt_daily_from_year").focus();
		return false;
	}
	else if (!to_year) {
		alert('Please select To Year');
		$("#gwt_daily_to_year").focus();
		return false;
	}
	else{
		//alert(datastr);
		$('#gw_daily_graph_holder').load('module/ground_water_ex/gwt_daily_comp_graph_holder.php',datastr);
	}
}

$('#gwt_daily_from_year').on("keypress",function(){
	$('#gw_daily_graph_holder').html("");
});

$('#gwt_daily_to_year').on("keypress",function(){
	$('#gw_daily_graph_holder').html("");
});

function show_gwt_daily_yearly_graph(){
	var district = $('#grph_sel_district').val();
	var upzila = $('#grph_sel_upazila').val();
	var old_id = $('#grph_sel_old_id').val();
	var well_id = $('#grph_sel_well_id').val();
    var from_year = $('#grph_sel_from_year').val();
    var to_year = $('#grph_sel_to_year').val();

    var datastr = "well_id="+well_id+"&from_year="+from_year+"&to_year="+to_year;
	//alert(datastr);
	$('#cover-spin').show(0);
    $.ajax({
		type:"post",
		url:"module/ground_water_ex/gw_daily_graph_year_wise.php",
		data:datastr,
		success:function(str){
			//alert(str);
			$('#cover-spin').hide();
			if($.trim(str)){
			//	$('#cover-spin').hide();
				var my_2d = $.parseJSON(str);
				//alert(my_2d);
				google.charts.load('current',{packages:['corechart']})
				google.charts.setOnLoadCallback(drawChart);
				
				function drawChart(){
					var data=new google.visualization.DataTable();
					data.addColumn('string','Year');
					data.addColumn('number','Water Table');
					
					for(i=0;i<my_2d.length;i++)
						data.addRow([my_2d[i][0],parseFloat(my_2d[i][1]),]);
						//alert(data);
					var options = {
						// title: 'Graphical Report: Ground Water (weekly) for Well ID: '+well_id,
						title: 'Graphical Report: Ground Water (Daily) for Well ID: '+well_id+' ('+old_id+'), District: '+district+', Upazila: '+upzila,
						curveType: 'function',
						pointSize: 5,
						pointShape: 'circle',
						width: '100%',
						height: '500',
						legend: { position: 'bottom' },
						animation: {
						  'startup': true,
						  duration: 5000,
						  easing: 'out',
						},
						hAxis: {
							title: 'Years'
						},
						vAxis: {
						  title: 'Water Table (m)',
						  viewWindow: {
							min: data.getColumnRange(1) , 
							max: data.getColumnRange(1),
						  },
						  format: '0.00',
						  gridlines: {
							count: 20
						  },
						  direction: '-1'
						}
					  };
					  //alert("option");
					var chart=new
					google.visualization.LineChart(document.getElementById('gw_daily_curve_chart'));
					chart.draw(data,options);
				}
			}
		}
	});
}

function download_gwt_daily_yearly_graph() {
	//alert('download_gwt_weekly_yearly_graph');
	var chartContainer = document.getElementById('gw_daily_curve_chart');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'GWT Daily Data Yearly Graph';
			link.click();
		});
	});
}