function flush_data() {
  $("#pump_test_data").html("");
  $("#pt_excel_data").html("");
  $("#pt_discharge").html("");
  $("#pt_distance").html("");
}

function load_old_id_by_district_id(sel_district_id) {
  var datastr = "sel_district_id=" + sel_district_id;
  flush_data();
  $("#pt_well_list_holder").load(
    "module/ground_water_ex/pt_well_id_by_district.php",
    datastr
  );
}

function load_ac_pt_tab() {
  var active_tab = $(".pt_content_tab .tab-pane.active").attr("id");
  //	alert(active_tab);
  if (active_tab == "pump_test_data") {
    load_pt_data();
  } else if (active_tab == "pt_excel_data") {
    load_pt_excel_holder();
  } else if (active_tab == "pt_discharge") {
    load_pt_discharge_data();
  } else {
    load_pt_distance_data();
  }
}

function load_pt_data() {
  //alert('load_pt_data');
  var pt_well_id = $("#pt_well_id").val();
  var test_type_id = $("#test_type_id").val();
  var district = $("#district").val();
  var operation = "count_data";

  if (district == "") {
    alert("Please Select District");
    $("#district").next("input").focus();
    return false;
  } else if (pt_well_id == "") {
    alert("Please Select Well Id");
    $("#pt_well_id").next("input").focus();
    return false;
  } else if (test_type_id == "") {
    alert("Please Select Test Type");
    $("#test_type_id").next("input").focus();
    return false;
  }

  var datastr =
    "operation=" +
    operation +
    "&pt_well_id=" +
    pt_well_id +
    "&test_type_id=" +
    test_type_id;
  // alert(datastr);
  //$('#cover-spin').show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      //alert(st);
      if (st == 0) {
        load_pt_data_ins_form(pt_well_id, test_type_id);
      } else {
        load_drawdown_edit_form(pt_well_id, test_type_id);
      }
    },
  });
}

/////pump test excel////
function load_pt_excel_holder() {
  // alert('excel')
  var excel_pt_well_id = $("#pt_well_id").val();
  var excel_test_type_id = $("#test_type_id").val();
  var excel_district = $("#district").val();
  // var operation = "count_data";

  if (excel_district == "") {
    alert("Please Select District");
    $("#district").next("input").focus();
    return false;
  } else if (excel_pt_well_id == "") {
    alert("Please Select Well Id");
    $("#pt_well_id").next("input").focus();
    return false;
  } else if (excel_test_type_id == "") {
    alert("Please Select Test Type");
    $("#test_type_id").next("input").focus();
    return false;
  }

  var datastr =
    "excel_pt_well_id=" +
    excel_pt_well_id +
    "&excel_test_type_id=" +
    excel_test_type_id;
  // alert(datastr);
  //$('#cover-spin').show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_excel_input_from.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      // alert(st);
      $("#pt_excel_data").html(st);
    },
  });
}
/////pump test discharge////
function load_pt_discharge_data() {
  // alert("load_pt_discharge_data");
  var discharge_pt_well_id = $("#pt_well_id").val();
  var discharge_test_type_id = $("#test_type_id").val();
  var discharge_district = $("#district").val();
  var operation = "discharge_count_data";

  if (discharge_district == "") {
    alert("Please Select District");
    $("#district").next("input").focus();
    return false;
  } else if (discharge_pt_well_id == "") {
    alert("Please Select Well Id");
    $("#pt_well_id").next("input").focus();
    return false;
  } else if (discharge_test_type_id == "") {
    alert("Please Select Test Type");
    $("#test_type_id").next("input").focus();
    return false;
  }

  var datastr =
    "discharge_pt_well_id=" +
    discharge_pt_well_id +
    "&discharge_test_type_id=" +
    discharge_test_type_id +
    "&operation=" +
    operation;
  // alert(datastr);
  //$('#cover-spin').show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      // alert(st);
      if (st == 0) {
        load_pt_data_discharge_add_form(discharge_pt_well_id, discharge_test_type_id);
      } else {
        load_pt_data_discharge_edit_form(discharge_pt_well_id, discharge_test_type_id);
      }
      // $("#pt_discharge").html(st);
    },
  });
}

//////pump test discharge/////


function load_pt_distance_data() {
  // alert("load_pt_distance_data");
  var distance_pt_well_id = $("#pt_well_id").val();
  var distance_test_type_id = $("#test_type_id").val();
  var distance_district = $("#district").val();
  var operation = "distance_count_data";

  if (distance_district == "") {
    alert("Please Select District");
    $("#district").next("input").focus();
    return false;
  } else if (distance_pt_well_id == "") {
    alert("Please Select Well Id");
    $("#pt_well_id").next("input").focus();
    return false;
  } else if (distance_test_type_id == "") {
    alert("Please Select Test Type");
    $("#test_type_id").next("input").focus();
    return false;
  }

  var datastr =
    "distance_pt_well_id=" +
    distance_pt_well_id +
    "&distance_test_type_id=" +
    distance_test_type_id +
    "&operation=" +
    operation;
  // alert(datastr);
  //$('#cover-spin').show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      // alert(st);
      if (st == 0) {
        load_pt_data_distance_add_form(distance_pt_well_id);
      } else {
        load_pt_data_distance_edit_form(distance_pt_well_id);
      }
      // $("#pt_discharge").html(st);
    },
  });

}

function load_pt_data_ins_form(sel_well_id, sel_test_type) {
  //alert('load_pt_data_ins_form');
  var datastr = "pt_well_id=" + sel_well_id + "&test_type_id=" + sel_test_type;
  //alert(datastr);
  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_empty_datatbl.php",
    datatype: "get",
    data: datastr,
    success: function (data) {
      //alert(data);
      $("#cover-spin").hide();
      $("#pump_test_data").html(data);
      $("#date_0").select();
    },
  });
}

function load_drawdown_edit_form(sel_well_id, sel_test_type) {
  // alert('load_drawdown_edit_form');
  // alert(sel_well_id)
  // alert(sel_test_type)
  var datastr =
    "e_pt_well_id=" + sel_well_id + "&e_test_type_id=" + sel_test_type;
  // alert(datastr);
  //$('#cover-spin').show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_edit_datatbl.php",
    datatype: "get",
    data: datastr,
    success: function (data) {
      // alert(data);
      //$('#cover-spin').hide();
      $("#pump_test_data").html(data);
    },
  });
}

//////pump test data entry///////
function pt_manu_data_multiple_save() {
	//alert('pt_manu_data_multiple_save');
	// var pt_manu_form_data =  $('#pt_data_manu_form').serialize();
	var tot_obs_well = $("#tot_obs_well").val();
	var sel_well_id = $("#sel_well_id").val();
	var test_type_id = $("#test_type_id").val();
	var operation = "insert";

	var pump_test_date = [];
	var pump_test_time = [];
	var pump_test_pw = [];

	$(".pump_test_date").each(function () {
		var value = $(this).val();
		pump_test_date.push(value);
	});
	
	$(".pump_test_time").each(function () {
		var value = $(this).val();
		pump_test_time.push(value);
	});

	$(".pump_test_pw").each(function () {
		var value = $(this).val();
		pump_test_pw.push(value);
	});

	var collectedValues = {};

  for (var i = 1; i <= tot_obs_well; i++) {
    collectedValues["obs_water_level_" + i] = [];
    $(".obs_water_level_" + i).each(function () {
      var value = $(this).val();
      collectedValues["obs_water_level_" + i].push(value);
    });
  }
  var obs_water_level = formatValuesAsQueryString(collectedValues);

  // alert('pump_test_time='+ pump_test_time + '&pump_test_pw=' + pump_test_pw +'&'+ obs_water_level);
  var datastr = "operation="+operation+"&"+obs_water_level+"&pump_test_date="+pump_test_date+
	"&pump_test_time="+pump_test_time+"&pump_test_pw="+pump_test_pw+"&tot_obs_well="+
    tot_obs_well+"&sel_well_id="+sel_well_id+"&test_type_id="+test_type_id;
	
//	alert(datastr);
	$("#cover-spin").show(0);
	$.ajax({
		url: "module/ground_water_ex/pump_test_data_log_ajax.php",
		datatype: "post",
		data: datastr,
		success: function (st) {
		  // alert(st);
		  $("#cover-spin").hide();
		  if (st == 1) {
			alert("Pump Test Data Saved Successfully");
			load_pt_data();
		  } else {
			alert("Error Occurred during Saving Pump Test Data");
		  }
		},
	});
}

///// array split/////
function formatValuesAsQueryString(values) {
  var queryArray = [];

  $.each(values, function (key, valueArray) {
    queryArray.push(key + "=" + valueArray.join(","));
  });

  return queryArray.join("&");
}

//////pump test data entry///////

//////pump tyest data update/////
function pt_manu_data_multiple_update() {
  var e_tot_obs_well = $("#e_tot_obs_well").val();
  var e_sel_well_id = $("#e_sel_well_id").val();
  var e_test_type_id = $("#e_test_type_id").val();
  var operation = "update";

  var e_pump_test_date = [];
  var e_pump_test_time = [];
  var e_pump_test_pw = [];
  var update_ids_main_well = [];
  var update_ids_obs_well = {};

  $("input[name^='update_id_main_well']").each(function () {
    var value = $(this).val();
    update_ids_main_well.push(value);
  });

  for (var i = 1; i <= e_tot_obs_well; i++) {
    update_ids_obs_well["Obs Well" + i] = [];
    $("input[name^='update_id_obs_well[" + i + "]']").each(function () {
      var value = $(this).val();
      update_ids_obs_well["Obs Well" + i].push(value);
    });
  }

	$(".e_pump_test_date").each(function () {
		var value = $(this).val();
		e_pump_test_date.push(value);
	});
  
  $(".e_pump_test_time").each(function () {
    var value = $(this).val();
    e_pump_test_time.push(value);
  });

  $(".e_pump_test_pw").each(function () {
    var value = $(this).val();
    e_pump_test_pw.push(value);
  });

  var e_collectedValues = {};
  for (var i = 1; i <= e_tot_obs_well; i++) {
    e_collectedValues["e_obs_water_level_" + i] = [];
    $(".e_obs_water_level_" + i).each(function () {
      var value = $(this).val();
      e_collectedValues["e_obs_water_level_" + i].push(value);
    });
  }

  var e_obs_water_level = formatValuesAsQueryString(e_collectedValues);

  var datastr ="operation="+operation+"&"+e_obs_water_level+"&e_pump_test_date="+e_pump_test_date+
  "&e_pump_test_time="+e_pump_test_time+"&e_pump_test_pw="+e_pump_test_pw+
    "&e_tot_obs_well=" +
    e_tot_obs_well +
    "&e_sel_well_id=" +
    e_sel_well_id +
    "&e_test_type_id=" +
    e_test_type_id +
    "&update_ids_main_well=" +
    update_ids_main_well +
    "&update_ids_obs_well=" +
    JSON.stringify(update_ids_obs_well);

   //alert(datastr);

  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    type: "POST",
    data: datastr,
    success: function (data) {
      $("#cover-spin").hide();
    //   alert(data);
      if (data == 1) {
        alert("Pump Test Data Update Successfully");
        load_pt_data();
      } else {
        alert("Error Occurred during saving Pump Test Data");
      }
    },
  });
}

//////pump test data update/////

/////////-- Delete All--/////////
function pt_data_delete_all() {
  // alert("pt_data_delete_all");
  // var well_id = $("#well_id").val();
  var delete_well_id = $("input[name^='sel_well_id']").val();
  var delete_test_type_id = $("input[name^='test_type_id']").val();
  // alert(well_id);
  var table = document.getElementById("pt_ins_form_tbl");
  // alert(table);
  // console.log(table);
  var tbodyRowCount = table.tBodies[0].rows.length;
  // alert(tbodyRowCount);
  var sel_day = 1;
  var successfulDeletions = 0;

  if (confirm("Are you sure you want to delete all row?")) {
    function litho_delete_all(sel_day) {
      if (sel_day <= tbodyRowCount) {
        var operation = "delete_all";
        var datastr = "delete_well_id=" + delete_well_id + "&delete_test_type_id="+delete_test_type_id + "&operation=" + operation;
        // alert(datastr);
        $("#cover-spin").show(0);
        $.ajax({
          url: "module/ground_water_ex/pump_test_data_log_ajax.php",
          type: "post",
          data: datastr,
          cache: false,
          success: function (result) {
            if (result == 1) {
              successfulDeletions++;
              litho_delete_all(sel_day + 1); // Continue to delete the next row
            } else {
              // Handle the case when deletion fails
            }

            // Check if all rows have been successfully deleted
            if (successfulDeletions === tbodyRowCount) {
              // All rows have been deleted, trigger the alert and reload the page
              //load_water_level_info();
              $("#cover-spin").hide();
              alert("Data has been Deleted Successfully");
              load_pt_data();
            }
          },
        });
      }
    }
    // Start deleting rows
    litho_delete_all(sel_day);
  }
}
/////////-- Delete All--/////////

///// pump test upload excel file///
function pump_test_excel_data_upload() {
  // alert("load_pt_excel_form");

  var excel_pt_well_id = $("#excel_pt_well_id").val();
  var excel_test_type_id = $("#excel_test_type_id").val();

  // var file_data = $('#file').prop('files')[0];
  // var form_data = new FormData();
  // form_data.append('file', file_data);
  // alert(form_data);

  var excelFile = $("#upload_excel").val();

  var parse = excelFile.split(".");
  if (parse[parse.length - 1] != "xlsx" && parse[parse.length - 1] != "xls") {
    alert("Please Select excel File");
    return false;
  }

  var formData = new FormData();
  formData.append("excel_well_id", excel_pt_well_id);
  formData.append("excel_test_type_id", excel_test_type_id);
  // formData.append("pump_test_id", excel_pump_test_id);
  // formData.append("observation_id", excel_excel_observation_id);
  formData.append("upload_excel", $("#upload_excel")[0].files[0]);

  // var datastr =
  //   "excel_upload_well_id=" +
  //   excel_upload_well_id +
  //   "&excel_well_purpose_id=" +
  //   excel_well_purpose_id +
  //   "&excel_pump_test_id=" +
  //   excel_pump_test_id +
  //   "&excel_excel_observation_id=" +
  //   excel_excel_observation_id +
  //   "&form_data=" +
  //   form_data;

  // alert(formData);

  $.ajax({
    type: "post",
    url: "module/ground_water_ex/pump_test_excel_upload.php",
    data: formData,
    contentType: false,
    processData: false,
    success: function (data) {
      // alert(data);
      $("#pump_test_excel_data_show").html(data);
    },
  });
}
///// pump test download sample excel file///

///////pump test excel data save////////
function pump_test_excel_data_save() {
  //alert('pt_manu_data_multiple_save');
  // var pt_manu_form_data =  $('#pt_data_manu_form').serialize();
  var excel_tot_obs_well = $("#excel_tot_obs_well").val();
  var ex_pt_well_id = $("#ex_pt_well_id").val();
  var ex_test_type_id = $("#ex_test_type_id").val();
  var operation = "excel_insert";

  var excel_pt_time = [];
  var excel_pt_pw = [];

  // Validate excel_pt_time fields
  var allFieldsFilled = true;
  var firstEmptyField = null;

  $(".excel_pt_time").each(function () {
    var value = $(this).val();
    if (value === "") {
      allFieldsFilled = false;
      if (firstEmptyField === null) {
        firstEmptyField = $(this);
      }
    }
    excel_pt_time.push(value);
  });

  // If any field is empty, alert the user and focus on the first empty field
  if (!allFieldsFilled) {
    alert("All Time fields are required.");
    if (firstEmptyField !== null) {
      firstEmptyField.focus();
    }
    return;
  }

  $(".excel_pt_pw").each(function () {
    var value = $(this).val();
    excel_pt_pw.push(value);
  });

  var excelCollectedValues = {};

  for (var i = 1; i <= excel_tot_obs_well; i++) {
    excelCollectedValues["excel_pt_ow_" + i] = [];
    $(".excel_pt_ow_" + i).each(function () {
      var value = $(this).val();
      excelCollectedValues["excel_pt_ow_" + i].push(value);
    });
  }
  var excel_obs_water_level = formatValuesAsQueryString(excelCollectedValues);

  // alert('excel_pt_time='+ excel_pt_time + '&excel_pt_pw=' + excel_pt_pw +'&'+ excel_obs_water_level);
  var datastr =
    "operation=" +
    operation +
    "&" +
    excel_obs_water_level +
    "&excel_pt_time=" +
    excel_pt_time +
    "&excel_pt_pw=" +
    excel_pt_pw +
    "&excel_tot_obs_well=" +
    excel_tot_obs_well +
    "&ex_pt_well_id=" +
    ex_pt_well_id +
    "&ex_test_type_id=" +
    ex_test_type_id;
  // alert(datastr);
  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      // alert(st);
      $("#cover-spin").hide();
      if (st == 1) {
        alert("Pump Test Excel Data Saved Successfully");
        // load_pt_data();
        load_pt_excel_holder();
      } else {
        alert("Error Occurred during saving Pump Test Data");
      }
    },
  });
}
///////pump test excel data save////////


//////pump test discharge input or edit from/////
function load_pt_data_discharge_add_form(sel_disch_pt_well_id, sel_disch_test_type_id){
  var datastr = "disch_pt_well_id=" + sel_disch_pt_well_id + "&disch_test_type_id=" + sel_disch_test_type_id;
  // alert(datastr);
  // $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_discharge_from.php",
    datatype: "POST",
    data: datastr,
    success: function (data) {
      //alert(data);
      // $("#cover-spin").hide();
      $("#pt_discharge").html(data);
      // $("#time_0").select();
    },
  });

}

function load_pt_data_discharge_edit_form(e_sel_disch_pt_well_id, e_sel_disch_test_type_id){
  var datastr = "e_disch_pt_well_id=" + e_sel_disch_pt_well_id + "&e_disch_test_type_id=" + e_sel_disch_test_type_id;
  // alert(datastr);
  // $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_discharge_edit_from.php",
    datatype: "POST",
    data: datastr,
    success: function (data) {
      //alert(data);
      // $("#cover-spin").hide();
      $("#pt_discharge").html(data);
      // $("#time_0").select();
    },
  });

}
//////pump test discharge input or edit from/////

//////pump test discharge data save///////
function pump_test_discharge_data_save(){
  // alert('pump_test_discharge_data_save');
  // var excel_tot_obs_well = $("#excel_tot_obs_well").val();
  var add_disch_pt_well_id = $("#add_disch_pt_well_id").val();
  var add_disch_test_type_id = $("#add_disch_test_type_id").val();
  var add_discharge = $("#add_discharge").val();
  var operation = "discharge_insert";

  if (add_discharge == "") {
    alert("Please Enter discharge");
    $("#add_discharge").focus();
    return false;
  }
  
  var datastr =
    "operation=" +
    operation +
    "&add_discharge=" +
    add_discharge +
    "&add_disch_pt_well_id=" +
    add_disch_pt_well_id +
    "&add_disch_test_type_id=" +
    add_disch_test_type_id;
  // alert(datastr);
  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "POST",
    data: datastr,
    success: function (st) {
      // alert(st);
      $("#cover-spin").hide();
      if (st == 1) {
        alert("Pump Test Discharge Data Saved Successfully");
        load_pt_discharge_data();
      } else {
        alert("Error Occurred during saving Pump Test Data");
      }
    },
  });
}

//////pump test discharge data save///////


//////pump test discharge data save///////
function pump_test_discharge_data_update(){
  // alert('pump_test_discharge_data_save');
  // var excel_tot_obs_well = $("#excel_tot_obs_well").val();
  var e_disch_pt_well_id = $("#e_disch_pt_well_id").val();
  var e_disch_test_type_id = $("#e_disch_test_type_id").val();
  var e_discharge = $("#e_discharge").val();
  var operation = "discharge_update";

  if (e_discharge == "") {
    alert("Please Enter Discharge");
    $("#e_discharge").focus();
    return false;
  }
  
  var datastr =
    "operation=" +
    operation +
    "&e_discharge=" +
    e_discharge +
    "&e_disch_pt_well_id=" +
    e_disch_pt_well_id +
    "&e_disch_test_type_id=" +
    e_disch_test_type_id;
  // alert(datastr);
  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "POST",
    data: datastr,
    success: function (st) {
      // alert(st);
      $("#cover-spin").hide();
      if (st == 1) {
        alert("Pump Test Discharge Data Update Successfully");
        load_pt_discharge_data();
      } else {
        alert("Error Occurred during saving Pump Test Data");
      }
    },
  });
}

// discharge data delete
function discharge_pt_data_delete(){
  var discharge_delete_well_id = $("input[name^='delete_disch_pt_well_id']").val();
  var delete_disch_test_type_id = $("input[name^='delete_disch_test_type_id']").val();
  // alert(delete_disch_test_type_id);
  
  if (confirm("Are you sure you want to delete data?")) {
        var operation = "discharge_delete";
        var datastr = "discharge_delete_well_id=" + discharge_delete_well_id + "&delete_disch_test_type_id=" + delete_disch_test_type_id + "&operation=" + operation;
        // alert(datastr);
        $("#cover-spin").show(0);
        $.ajax({
          url: "module/ground_water_ex/pump_test_data_log_ajax.php",
          type: "post",
          data: datastr,
          cache: false,
          success: function (result) {
            $("#cover-spin").hide();
            if (result == 1) {
              alert("Data has been Deleted Successfully");
              load_pt_discharge_data();
            }
          },
        });
      }
}

//////pump test discharge data save///////






//////pump test distance input or edit from/////
function load_pt_data_distance_add_form(sel_distance_pt_well_id){
  var datastr = "sel_distance_pt_well_id=" + sel_distance_pt_well_id;
  // alert(datastr);
  // $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_distance_from.php",
    datatype: "POST",
    data: datastr,
    success: function (data) {
      //alert(data);
      // $("#cover-spin").hide();
      $("#pt_distance").html(data);
      // $("#time_0").select();
    },
  });

}

function load_pt_data_distance_edit_form(e_sel_distance_pt_well_id){
  var datastr = "e_sel_distance_pt_well_id=" + e_sel_distance_pt_well_id;
  // alert(datastr);
  // $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_distance_edit_from.php",
    datatype: "POST",
    data: datastr,
    success: function (data) {
      //alert(data);
      // $("#cover-spin").hide();
      $("#pt_distance").html(data);
      // $("#time_0").select();
    },
  });

}
//////pump test distance input or edit from/////

//// pump test distance data save or update/////

function distance_pt_data_save(){
  var distance_tot_obs_well = $("#distance_tot_obs_well").val();
  var add_distance_pt_well_id = $("#add_distance_pt_well_id").val();
  // var test_type_id = $("#test_type_id").val();
  var operation = "distance_insert";

  // var pump_test_time = [];
  var distance_pump_test_pw = [];

  $(".distance_pump_test_pw").each(function () {
    var value = $(this).val();
    distance_pump_test_pw.push(value);
  });

  var distanceCollectedValues = {};

  for (var i = 1; i <= distance_tot_obs_well; i++) {
    distanceCollectedValues["distance_obs_pt_" + i] = [];
    $(".distance_obs_pt_" + i).each(function () {
      var value = $(this).val();
      distanceCollectedValues["distance_obs_pt_" + i].push(value);
    });
  }
  var distance_obs_pt = distanceFormatValuesAsQueryString(distanceCollectedValues);

  var datastr =
    "operation=" +
    operation +
    "&" +
    distance_obs_pt +
    "&distance_pump_test_pw=" +
    distance_pump_test_pw +
    "&distance_tot_obs_well=" +
    distance_tot_obs_well +
    "&add_distance_pt_well_id=" +
    add_distance_pt_well_id ;
  // alert(datastr);
  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      alert(st);
      $("#cover-spin").hide();
      if (st == 1) {
        alert("Pump Test Distance Data Saved Successfully");
        load_pt_distance_data();
      } else {
        alert("Error Occurred during Saving Data");
      }
    },
  });
}

///// array split/////
function distanceFormatValuesAsQueryString(values) {
  var queryArray = [];

  $.each(values, function (key, valueArray) {
    queryArray.push(key + "=" + valueArray.join(","));
  });

  return queryArray.join("&");
}


function distance_pt_data_update(){
  var e_distance_tot_obs_well = $("#e_distance_tot_obs_well").val();
  var e_distance_pt_well_id = $("#e_distance_pt_well_id").val();
  // var test_type_id = $("#test_type_id").val();
  var operation = "distance_update";

  // var pump_test_time = [];
  var e_distance_pump_test_pw = [];

  $(".e_distance_pump_test_pw").each(function () {
    var value = $(this).val();
    e_distance_pump_test_pw.push(value);
  });

  var e_distanceCollectedValues = {};

  for (var i = 1; i <= e_distance_tot_obs_well; i++) {
    e_distanceCollectedValues["e_distance_obs_pt_" + i] = [];
    $(".e_distance_obs_pt_" + i).each(function () {
      var value = $(this).val();
      e_distanceCollectedValues["e_distance_obs_pt_" + i].push(value);
    });
  }
  var e_distance_obs_pt = distanceFormatValuesAsQueryString(e_distanceCollectedValues);

  var datastr =
    "operation=" +
    operation +
    "&" +
    e_distance_obs_pt +
    "&e_distance_pump_test_pw=" +
    e_distance_pump_test_pw +
    "&e_distance_tot_obs_well=" +
    e_distance_tot_obs_well +
    "&e_distance_pt_well_id=" +
    e_distance_pt_well_id ;
  // alert(datastr);
  $("#cover-spin").show(0);
  $.ajax({
    url: "module/ground_water_ex/pump_test_data_log_ajax.php",
    datatype: "post",
    data: datastr,
    success: function (st) {
      // alert(st);
      $("#cover-spin").hide();
      if (st == 1) {
        alert("Pump Test Distance Data Update Successfully");
        load_pt_distance_data();
      } else {
        alert("Error Occurred during Saving Data");
      }
    },
  });
}

// delete
function distance_pt_data_delete(){
  // alert('svcsv ');
  var distance_delete_well_id = $("input[name^='delete_distance_pt_well_id']").val();
  // alert(distance_delete_well_id);
  var table = document.getElementById("distance_pt_form_tbl");

  var tbodyRowCount = table.tBodies[0].rows.length;
  var sel_day = 1;
  var successfulDeletions = 0;

  if (confirm("Are you sure you want to delete all row?")) {
    function distance_delete_all(sel_day) {
      if (sel_day <= tbodyRowCount) {
        var operation = "distance_delete";
        var datastr = "distance_delete_well_id=" + distance_delete_well_id + "&operation=" + operation;
        // alert(datastr);
        $("#cover-spin").show(0);
        $.ajax({
          url: "module/ground_water_ex/pump_test_data_log_ajax.php",
          type: "post",
          data: datastr,
          cache: false,
          success: function (result) {
            if (result == 1) {
              successfulDeletions++;
              distance_delete_all(sel_day + 1); // Continue to delete the next row
            } else {
              // Handle the case when deletion fails
            }

            // Check if all rows have been successfully deleted
            if (successfulDeletions === tbodyRowCount) {
              // All rows have been deleted, trigger the alert and reload the page
              //load_water_level_info();
              $("#cover-spin").hide();
              alert("Data has been Deleted Successfully");
              load_pt_distance_data();
            }
          },
        });
      }
    }
    // Start deleting rows
    distance_delete_all(sel_day);
  }
}

//// pump test distance data save or update/////