<?php
session_start(); 
include("../../php_crud/my_class.php");
$obj = new my_class();
?>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.8.1/css/all.css" rel="stylesheet" media="all" type="text/css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script src="module/ground_water_ex/js/rainfall_information.js" type="text/javascript"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>

<div id="cover-spin"></div>

<div class="table-header">
    <i class="fas fa-th-list"></i> Rainfall Information
</div>

<div class="row-fluid" style="background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black;">

  <div class="span3" style="margin-top: 5px; padding-left: 25px;">
    <div class="control-group">
		  <label class="control-label" for="subDivision"><b>Sub-division<font color="#FF0000"></font></b></label>
				<div class="controls" style="width: 100%">
				  <select id="subDivision" name="subDivision" class="chosen-select" onchange="">
						<option value=""></option>           
					</select>
				</div>
		</div>
	</div>

  <div class="span3" style="margin-top: 5px; padding-left: 25px;">
		<div class="control-group">
      <label class="control-label" for="station"><b>Station<font color="#FF0000"></font></b></label>
				<div class="controls" style="width: 100%">
				  <select id="station" name="station" class="chosen-select">
						<option value=""></option>
					</select>
				</div>
		</div>
	</div>

  <div class="span4" style="margin-top: 5px; padding-left: 35px;">
		<div class="control-group">
      <label class="control-label" for="file"><b>Select File<font color="#FF0000"></font></b></label>
        <div class="controls" style="width: 100%;">
				  <input class="ace-file-input" type="file" name="file" id="file" accept=".xlsx">
        </div>
		</div>
	</div>

  <div class="span2" style="margin-top: 30px; padding-left: 25px;">
		<div class="control-group">
      <div class="controls">
        <button type ="button" class="btn btn-minier btn-success" style="padding: 4px !important;"><i class="icon-upload"></i> <b style="font-size: 12px;">Upload</b></button>
      </div>
		</div>
	</div>
</div>

<div class="row-fluid" style="background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black; padding-bottom: 5px;">
    
    <div class="span3" style="margin-top: 5px; padding-left: 25px;">
		  <div class="control-group">
			  <label class="control-label" for="year"><b>Year<font color="#FF0000"></font></b></label>
			    <div class="controls">
            <input style="width: 95%;" type="text" id="year" name="year" maxlength="4"/>
			    </div> 
		  </div>
	  </div>

    <div class="span3" style="margin-top: 5px; padding-left: 25px;">
      <div class="control-group">
        <label class="control-label" for="month"><b>Month<font color="#FF0000"></font></b></label>
        <div class="controls" style="width: 100%">
          <select id="month" name="month" class="chosen-select">
            <option value="">Select Month</option>
            <option value="01">January</option>
            <option value="02">February</option>
            <option value="03">March</option>
            <option value="04">April</option>
            <option value="05">May</option>
            <option value="06">June</option>
            <option value="07">July</option>
            <option value="08">August</option>
            <option value="09">September</option>
            <option value="10">October</option>
            <option value="11">November</option>
            <option value="12">December</option>
          </select>
        </div> 
      </div>
    </div>

    <div class="span6" style="margin-top: 30px; padding-left: 25px;">
		  <div class="control-group">
			  <div class="controls">
				  <button type ="button" onclick="" class="btn btn-minier btn-info" style="padding: 4px !important;"><i class="icon-search"></i> <b style="font-size: 12px;">Show Data</b></button>
			  </div>
		  </div>
	  </div>

    <!-- <div class="span6" style="margin-top: 5px; padding-left: 35px;">
        <div class="control-group">
            <label class="control-label" for="remark"><b>Remarks<font color="#FF0000"></font></b></label>
            <div class="controls" style="width: 100%;"> 
                <textarea id="remark" name="remark" rows="" cols="" style="width: 82%;"></textarea>
            </div>
        </div>
    </div> -->
</div>

<div class="row-fluid" style="margin-top: 15px;">
    <div class="col-sm-6 widget-container-col" id="widget-container-col-10">
	    <div class="widget-box" id="widget-box-10">
		    <div class="widget-header widget-header-large">
				<div class="widget-toolbar no-border">
					<ul class="nav nav-tabs" id="myTab">
						<li class="active">
							<a data-toggle="tab" href="#data_list">Data List</a>
						</li>
						<li>
							<a data-toggle="tab" href="#graph_data">Graph Data</a>
						</li>
					</ul>
				</div>
			</div>

			<div class="widget-body">
				<div class="widget-main padding-5">
					<div class="tab-content">
						<div id="data_list" class="tab-pane in active">
              <div id="view_ri_data"></div>
						</div>
						<div id="graph_data" class="tab-pane">                        
              <canvas id="myChart" style="width:100%;max-width:700px; margin-left: 22%;"></canvas>
            </div>
					</div>
			  </div> 
			</div>
		</div>
	</div>
</div>

<script>
    $('.chosen-select').chosen({allow_single_deselect:true}); 
	//resize the chosen on window resize
	$(window)
	.off('resize.chosen')
	.on('resize.chosen', function() {
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width': '100%'});
		})
	}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if(event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width':'100%'});
		})
	});
</script>

<script>
	$('#file').ace_file_input({
		no_file:'No File ...',
		btn_choose:'Choose',
		btn_change:'Change',
		droppable:false,
		onchange:null,
		thumbnail:false
	});
</script>

<script>
const today = new Date();
const year = today.getFullYear();
const month = today.getMonth();
const firstDay = new Date(year, month, 1);
const lastDay = new Date(year, month + 1, 0);

const daysOfMonth = [];
for (let day = 1; day <= lastDay.getDate(); day++) {
  daysOfMonth.push(day);
}

console.log(daysOfMonth);

const xValues = daysOfMonth;
const yValues = [7,8,8,9,9,9,10,11,14,14,15];

new Chart("myChart", {
  type: "line",
  data: {
    labels: xValues,
    datasets: [{
      fill: false,
      lineTension: 0,
      backgroundColor: "rgba(0,0,255,1.0)",
      borderColor: "rgba(0,0,255,0.1)",
      data: yValues
    }]
  },
  options: {
    legend: {display: false},
    scales: {
      yAxes: [{ticks: {min: 6, max:16}}],
    }
  }
});
</script>