<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
$year= date('Y');
?>
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" />
<script src="module/ground_water_ex/js/pump_test_data_log.js" type="text/javascript"></script>
<style>
	.chzn-container-single .chzn-drop .chzn-search input[type="text"] {
		background-image: none !important;
		padding-left: 5px !important; /* adjust as needed */
	}
</style>
<div id="cover-spin"></div>

<div class="table-header"><i class="fas fa-th-list"></i> Pump Test Data Entry</div>

<div class="row-fluid" style="background-color:#f5f5f5; -webkit-box-shadow:0px 8px 6px -6px black; -moz-box-shadow:0px 8px 6px-6px black;box-shadow:0px 8px 6px -6px black; padding-bottom: 5px;">
    <div class="span3" style=" padding-left:25px; margin-top:5px; margin-bottom:10px">
        <div class="control-group">
            <label class="control-level"for="district"><b>District</b><font style="color:#FF0000"></font></label>
            <div class="controls" style="width: 100%;">
                <select name="district" id="district" class="chosen-select" onchange="load_old_id_by_district_id(this.value)">
                    <option value=""></option>
					<?php
					$tbl_name="HYDROLOGY.DISTRICT_TBL@HYDRO10";
					$cols="DISTRICT_NO,DISTRICT_NAME";
					$where_cond="1=1 ORDER BY DISTRICT_NAME ASC";
					
					foreach($obj->View_colmn_By_Cond($tbl_name,$cols,$where_cond)as $district_list){
						echo '<option value="'.$district_list['DISTRICT_NO']."#".$district_list['DISTRICT_NAME'].'">'.$district_list['DISTRICT_NAME'].'</option>';
					}	
					?>
                </select>
            </div>
        </div>
    </div>
    <div class="span3" style="margin-top:5px ;margin-bottom:10px">
        <div class="control-group">
            <label class="control-level" for="old-id"><b>Well ID</b></label>
			<div class="controls" id="pt_well_list_holder">
				<select class="chosen-select">
					<option value=""></option>
				</select>
			</div>
        </div>
    </div>
	<div class="span2" style="margin-top:5px ;margin-bottom:10px">
        <div class="control-group">
            <label class="control-level" for="new-id"><b>Test Type</b></label>
			<div class="controls" >
				<select id="test_type_id" class="chosen-select">
					<option value=""></option>
					<option value="Continuous">Continuous</option>
					<option value="Step 1">Step 1</option>
					<option value="Step 2">Step 2</option>
					<option value="Step 3">Step 3</option>
					<option value="Recovery">Recovery</option>
				</select>
			</div>
        </div>
    </div>
    <div class="span2" style="margin-top:26px">
        <div class="control-group">
            <div class="controls">
                <button type="button" class="btn btn-small btn-info"  onclick="load_ac_pt_tab()">
				<b style="font-size: 12px;"><i class="icon-search"></i>Show Data</b></button>
            </div>
        </div>
    </div>

		<!--Excel sample download -->
		<div class="span2" style="margin-top: 2%; margin-left: -7%;">
						<div class="control-group">
							<div class="controls">
								<a href="module/ground_water_ex/pump_test_sample_excel_download.php" target="blank">
									<button type="button" class="btn btn-minier btn-info" style="padding: 5px !important; margin-top: -5px; background-color: #1D6F42 !important;">
										<i class="fa fa-file-excel-o" style="font-size: 13px; margin-right:5px;"></i> <b style="font-size: 12px;"> Download Excel Format </b>
									</button></a>
							</div>
						</div>
					</div>
					<!--Excel sample download -->
</div>

<div class="row-fluid" style="margin-top: 15px;">
    <div class="col-sm-6 widget-container-col" id="widget-container-col-10">
	    <div class="widget-box" id="widget-box-10">
		    <div class="widget-header widget-header-large">
				<div class="widget-toolbar no-border">
					<ul class="nav nav-tabs" id="myTab">
						<li class="active">
							<a data-toggle="tab" href="#pump_test_data" onclick="load_pt_data()">Pump Test Data</a>
						</li>
						<li>
							<a data-toggle="tab" href="#pt_excel_data" onclick="load_pt_excel_holder()">Data Entry by Excel</a>
						</li>
						<li>
							<a data-toggle="tab" href="#pt_discharge" onclick="load_pt_discharge_data()">Well Discharge</a>
						</li>
						<li>
							<a data-toggle="tab" href="#pt_distance" onclick="load_pt_distance_data()">Well Distance</a>
						</li>
					</ul>
				</div>
			</div>
			<div class="widget-body">
				<div class="widget-main padding-10">
					<div class="tab-content pt_content_tab">
						<div id="pump_test_data" class="tab-pane in active"></div>
						<div id="pt_excel_data" class="tab-pane"></div>	
						<div id="pt_discharge" class="tab-pane"></div>	
						<div id="pt_distance" class="tab-pane"></div>	
            		</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
    $('.chosen-select').chosen({
		allow_single_deselect: true,
		search_contains: true
	}); 
	//resize the chosen on window resize

	$(window)
	.off('resize.chosen')
	.on('resize.chosen', function() {
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width': '100%'});
		})
	}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if(event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width':'100%'});
		})
	});
</script>