<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
$year = date('Y');

extract($_REQUEST);
$well_basic_info = $obj->Details_By_Cond("HYDROLOGY.BLPUMP_TBL@HYDRO10", "WELL_ID='$e_pt_well_id'");

$tot_obs_well = $well_basic_info['NUMBER_OF_OBS_WELL'];
?>


<style type="text/css">
	select,
	textarea,
	input[type="text"],
	input[type="password"],
	input[type="datetime"],
	input[type="datetime-local"],
	input[type="date"],
	input[type="month"],
	input[type="time"],
	input[type="week"],
	input[type="number"],
	input[type="email"],
	input[type="url"],
	input[type="search"],
	input[type="tel"],
	input[type="color"],
	.uneditable-input {
		display: inline-block;
		height: 1px !important;
		padding: 8px 3px !important;
		margin-bottom: 2px !important;
		font-size: 13px !important;
		line-height: 23px !important;
		color: #555;
		vertical-align: middle;
		-webkit-border-radius: 4px;
		-moz-border-radius: 4px;
		border-radius: 4px;
	}

	.table th,
	.table td {
		padding: 2px !important;
		line-height: 20px;
		text-align: left;
		vertical-align: top;
		border-top: 1px solid #ddd;
	}

	.button {
		position: relative;
		top: -20px;
	}

	.tbl {
		position: relative;
		top: -15px;
	}
</style>
<?php
// Fetch data from the database
// $pump_data_main_well = $obj->View_colmn_By_Cond("HYDROLOGY.PUMP_DATA_TBL@HYDRO10", "WELL", "WELL_ID='$e_pt_well_id' AND TEST_TYPE='$e_test_type_id' GROUP BY WELL");

// Initialize total observation wells and row ID
// $tot_obs_well = 4; // Assuming 4 observation wells
// $row_id = 0;

?>

<?php
$row_id = 0;
$data_by_time = [];
$pump_data_main_well = $obj->View_colmn_By_Cond("HYDROLOGY.PUMP_DATA_TBL@HYDRO10", "*", "WELL_ID='$e_pt_well_id' AND TEST_TYPE='$e_test_type_id' ORDER BY ELASPED_TIME");

foreach ($pump_data_main_well as $value) {
	$sel_date = "";
	if($value['DT']!=""){
		$sel_date =  date('d/m/Y',strtotime($value['DT']));
	}
	
	$pump_test_time = $value['ELASPED_TIME'];
	$water_tbl = $value['WATER_TBL'];
	$well = $value['WELL'];
	$update_id = $value['ID'];

	// Group data by elapsed time
	if (!isset($data_by_time[$pump_test_time])) {
		$data_by_time[$pump_test_time] = [
			'date' => '',
			'Main Well' => '',
			'Obs Wells' => []
		];
	}
	
	if ($well == 'Main Well') {
		$data_by_time[$pump_test_time]['date'] = $sel_date;
		$data_by_time[$pump_test_time]['Main Well'] = $water_tbl;
		$data_by_time[$pump_test_time]['Main Well ID'] = $update_id;
	} else {
		$data_by_time[$pump_test_time]['Obs Wells'][$well] = $water_tbl;
		$data_by_time[$pump_test_time]['Obs Well IDs'][$well] = $update_id;
	}
}
?>
<form id="pt_data_manu_form" name="pt_data_manu_form" method="post">
	<input type="hidden" name="tot_obs_well" id="e_tot_obs_well" value="<?php echo $tot_obs_well; ?>" />
	<input type="hidden" name="sel_well_id" id="e_sel_well_id" value="<?php echo $e_pt_well_id; ?>" />
	<input type="hidden" name="test_type_id" id="e_test_type_id" value="<?php echo $e_test_type_id; ?>" />
	<div class="row-fluid">
		<div class="row-fluid" style="margin-bottom:10px; margin-top:-16px!important;">
			<h5 style="display: inline; float:left;">Pump Test Information for: <?php echo $e_pt_well_id; ?></h5>
			<div class="control-group" style="float:right;">
				<div class="controls">
					<button type="button" style="margin-right: 1px; font-size: 12px;" id="btn2" class="btn btn-small btn-primary" onclick="load_new_row_edit()"><i class="icon-plus"></i><b>Add New</b></button>
					<button id="pt_data_manu_ins_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-success" onclick="pt_manu_data_multiple_update()"><i class="icon-save"></i><b>Save All</b></button>
					<?php if ($_SESSION['delete'] == 'Y') { ?>
						<button id="pt_data_manu_delete_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-danger" onclick="pt_data_delete_all()"><i class="icon-trash"></i><b>Delete All</b></button>
					<?php } ?>
				</div>
			</div>
		</div>
		<table id="pt_ins_form_tbl" class="table table-bordered table-hover">
			<thead>
				<tr>
					<th style="text-align:center; font-size:13px;" class="table-header">Date</th>
					<th style="text-align:center; font-size:13px;" class="table-header">Time(m)</th>
					<th style="text-align:center; font-size:13px;" class="table-header">PW</th>
					<?php for ($i = 1; $i <= $tot_obs_well; $i++) { ?>
						<th style="text-align:center; font-size:13px;" class="table-header">OW<?php echo $i; ?></th>
					<?php } ?>
				</tr>
			</thead>
			<tbody id="pt_ins_form_tbl_body">
				<?php foreach ($data_by_time as $time => $data) {
					$val_array_index = $row_id; ?>
					<tr>
						<td style="text-align: center;">
							<input type="text" class="input-small e_pump_test_date" style="text-align: center; font-weight: bold;" name="ptd[<?php echo $row_id; ?>][date]" id="date_<?php echo $row_id; ?>" value="<?php echo $data['date']; ?>" onkeyup="call_next_val_loader(event, 'date_<?php echo $row_id; ?>', 'time_<?php echo $row_id; ?>', 0)">
						</td>
						<td style="text-align: center;">
							<span>
								<input type="hidden" name="update_id_main_well[<?php echo $row_id; ?>]" id="update_id_main_well_<?php echo $row_id; ?>" value="<?php echo $data['Main Well ID']; ?>" />
							</span>
							<input onkeypress="return isTimeDecimalInput(event)" type="text" class="input-small e_pump_test_time" style="text-align: center; font-weight: bold;" name="ptd[<?php echo $row_id; ?>][time]" id="time_<?php echo $row_id; ?>" value="<?php echo $time === 0 ? '0' : $time; ?>" onkeyup="call_next_val_loader(event, 'time_<?php echo $row_id; ?>', 'pw_<?php echo $row_id; ?>', 0)">
						</td>
						<td style="text-align: center;">
							<input onkeypress="return isDecimalInput(event)" type="text" class="input-small e_pump_test_pw" style="text-align: center; font-weight: bold;" name="ptd[<?php echo $row_id; ?>][pw]" id="pw_<?php echo $row_id; ?>" value="<?php echo $data['Main Well'] === 0 ? '0' : $data['Main Well']; ?>" onkeyup="call_next_val_loader(event, 'pw_<?php echo $row_id; ?>', 'ow1_<?php echo $row_id; ?>', 0)">
						</td>
						<?php for ($i = 1; $i <= $tot_obs_well; $i++) {
							$next_col_id = $i + 1;
							$curr_name = "ptd" . "[$row_id][ow$i]";
							$curr_input_id = "ow$i" . "_" . "$row_id";
							$next_input_id = "ow$next_col_id" . "_" . "$row_id";
							$call_next_row = 0;
							if ($i == $tot_obs_well) {
								$next_input_id = "time_" . ($row_id + 1);
								$call_next_row = 1;
							}
							$obs_well_key = "Obs Well$i";
							$obs_value = isset($data['Obs Wells'][$obs_well_key]) ? $data['Obs Wells'][$obs_well_key] : '';
							$update_id = isset($data['Obs Well IDs'][$obs_well_key]) ? $data['Obs Well IDs'][$obs_well_key] : '';
						?>
							<td style="text-align: center;">
								<span>
									<input type="hidden" name="update_id_obs_well[<?php echo $i; ?>][<?php echo $row_id; ?>]" id="update_id_obs_well_<?php echo $i; ?>_<?php echo $row_id; ?>" value="<?php echo $update_id; ?>" />
								</span>
								<input onkeypress="return isDecimalInput(event)" type="text" class="input-small e_obs_water_level_<?php echo $i; ?>" style="text-align: center; font-weight: bold;" name="<?php echo $curr_name; ?>" id="<?php echo $curr_input_id; ?>" value="<?php echo $obs_value === 0 ? '0' : $obs_value; ?>" onkeyup="call_next_val_loader(event, '<?php echo $curr_input_id; ?>', '<?php echo $next_input_id; ?>', <?php echo $call_next_row; ?>)">
							</td>
						<?php } ?>
					</tr>
				<?php $row_id++;
				} ?>
			</tbody>
		</table>
		<div class="row-fluid" style="margin-bottom:10px; margin-top:-16px!important;">
			<div class="control-group" style="float:right;">
				<div class="controls">
					<button type="button" style="margin-right: 1px; font-size: 12px;" id="btn2" class="btn btn-small btn-primary" onclick="load_new_row_edit()"><i class="icon-plus"></i><b>Add New</b></button>
					<button id="pt_data_manu_ins_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-success" onclick="pt_manu_data_multiple_update()"><i class="icon-save"></i><b>Save All</b></button>
					<?php
					if ($_SESSION['delete'] == 'Y') {
						echo '<button id="pt_data_manu_delete_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-danger" onclick="pt_data_delete_all()"><i class="icon-trash"></i><b>Delete All</b></button>';
					}
					?>
				</div>
			</div>
		</div>
	</div>
</form>





<!-- <script>
var tot_obs_well = <?php //echo $tot_obs_well; 
										?>; // Define tot_obs_well globally
</script> -->

<script>
	let inputReset = false; // Track whether input should be reset

	function isDecimalInput(event) {
		const key = event.keyCode || event.which;
		const keyChar = String.fromCharCode(key);

		const regex = /[0-9]|\.|\-/;

		// Only allow numeric, decimal, or minus sign input
		if (!regex.test(keyChar)) {
			event.preventDefault();
			return false;
		}

		const input = event.target;
		const currentValue = input.value;

		// If the input already contains a decimal point or minus sign, disallow another one
		if ((keyChar === "." && currentValue.indexOf(".") !== -1) ||
			(keyChar === "-" && currentValue.indexOf("-") !== -1)) {
			event.preventDefault();
			event.target.value = "";
			event.target.value += keyChar;
			return false;
		}

		//If the input would result in a value less than -99.99 or greater than 99.99, disallow it
		const newValue = parseFloat(currentValue + keyChar).toFixed(3);
		if (newValue < -99.99 || newValue > 99.99) {
			event.preventDefault();
			return false;
		}

		// If input should be reset, do so and allow new input
		if (inputReset) {
			input.value = "";
			inputReset = false;
		}

		// If the input would result in more than 2 decimal places, set inputReset flag
		const parts = currentValue.split(".");
		if (parts.length === 2 && parts[1].length >= 3 && keyChar !== "-") {
			event.preventDefault();
			event.target.value = "";
			event.target.value += keyChar;
			return false;
		}

		if (currentValue === "0" && keyChar !== "." && keyChar !== "-" && currentValue.indexOf(".") === -1) {
			event.preventDefault();
			return false;
		}

		return true;
	}

	function isTimeDecimalInput(event) {
		const key = event.keyCode || event.which;
		const keyChar = String.fromCharCode(key);

		const regex = /[0-9]|\.|\-/;

		// Only allow numeric, decimal, or minus sign input
		if (!regex.test(keyChar)) {
			event.preventDefault();
			return false;
		}

		const input = event.target;
		const currentValue = input.value;

		// If the input already contains a decimal point or minus sign, disallow another one
		if ((keyChar === "." && currentValue.indexOf(".") !== -1) ||
			(keyChar === "-" && currentValue.indexOf("-") !== -1)) {
			event.preventDefault();
			event.target.value = "";
			event.target.value += keyChar;
			return false;
		}

		//If the input would result in a value less than -99.99 or greater than 99.99, disallow it
		const newValue = parseFloat(currentValue + keyChar).toFixed(3);
		if (newValue < -9999.99 || newValue > 9999.99) {
			event.preventDefault();
			event.target.value = "";
			event.target.value += keyChar;
			return false;
		}

		// If input should be reset, do so and allow new input
		if (inputReset) {
			input.value = "";
			inputReset = false;
		}

		if (currentValue === "0" && keyChar !== "." && keyChar !== "-" && currentValue.indexOf(".") === -1) {
			event.preventDefault();
			return false;
		}

		return true;
	}
</script>
<script>
	function validateInput(input) {
		var regex = /(\b(on\w+)=|javascript:|(<\s*)(\/*)script)/i;
		if (input.length > 100 || regex.test(input)) {
			return false;
		}
		return true;
	}

	function validateTimeInput(input) {
		var regex = /(\b(on\w+)=|javascript:|(<\s*)(\/*)script)/i;
		if (regex.test(input)) {
			return false;
		}
		return true;
	}
</script>
<!-- <script>
	function call_next_val_loader(e, sel_col_id, next_col_id, call_next_row) {
		//alert('call_next_val_loader');
		//alert(sel_col_id);
		//alert(next_col_id);
		if (event.keyCode == 13 || event.keyCode == 'enter' || event.keyCode == 9 || event.keyCode == 'tab') {
			const byteSize = $("#" + sel_col_id).val().length;
			var curr_val = $("#" + sel_col_id).val();
			var col_name_arr = sel_col_id.split('_');
			var col_name = col_name_arr[0];
			//alert(col_name);
			if (col_name == 'time') {
				if (curr_val == "") {
					alert("Please enter the time value");
					$("#" + sel_col_id).select();
					return false;
				} else if (validateTimeInput(curr_val) == false) {
					alert("Please Check The Input Format");
					curr_val = "";
					$("#" + sel_col_id).val(curr_val);
				}
				if (curr_val > Math.floor(curr_val)) {
					curr_val = parseFloat(curr_val).toFixed(1);
				}
				$("#" + sel_col_id).val(curr_val);
				$("#" + next_col_id).select();
			} else {
				if (validateInput(curr_val) == false) {
					alert("Please Check The Input Format");
					curr_val = "";
					$("#" + sel_col_id).val(curr_val);
				}
				// else if (byteSize > 10) {
				//   alert("Date Length Cannot Be More Than 10 Bytes");
				//   // curr_val = "";
				//   $("#"+sel_col_id).val(curr_val);
				// }
				// if (curr_val > Math.floor(curr_val)) {
				// 	curr_val = parseFloat(curr_val).toFixed(3);
				// }
				$("#" + sel_col_id).val(curr_val);
				$("#" + next_col_id).select();
				if (call_next_row == 1) {
					load_new_row_edit();
					// console.log(tot_obs_well);
				}
			}
		}
	}
</script> -->


<script>
	function call_next_val_loader(e, sel_col_id, next_col_id, call_next_row) {
		if (e.keyCode == 13 || e.keyCode == 'enter' || e.keyCode == 9 || e.keyCode == 'tab') {
			var curr_val = $("#" + sel_col_id).val();
			var col_name_arr = sel_col_id.split('_');
			var col_name = col_name_arr[0];
	
	
			if(col_name=='date'){
				if(curr_val==""){
					alert("Please enter the date value");
					$("#"+sel_col_id).select();
					return false;
				}
				else{
					var operation = "date_checker";
					var datastr = "operation="+operation+"&input_date="+curr_val;
					$.ajax({
						url: 'module/ground_water_ex/pump_test_data_log_ajax.php', 
						type: 'post',
						data: datastr,
						cache: false,
						success: function(result) {
							//alert(result);
							if(result== 0){
							  alert('You only enter data till today');
							  $("#"+sel_col_id).val('');
							  $("#"+sel_col_id).select();
							  return false;
							}
							else{
							  $("#"+sel_col_id).val(result);
							  $("#"+next_col_id).select();
							}
					  }
					});
				}
			}
			else if (col_name == 'time') {
				if (curr_val == "") {
					alert("Please enter the time value");
					$("#" + sel_col_id).select();
					return false;
				} else if (validateTimeInput(curr_val) == false) {
					alert("Please Check The Input Format");
					curr_val = "";
					$("#" + sel_col_id).val(curr_val);
				}
				if (curr_val > Math.floor(curr_val)) {
					curr_val = parseFloat(curr_val).toFixed(1);
				}
				$("#" + sel_col_id).val(curr_val);
				$("#" + next_col_id).select();
			} else {
				if (validateInput(curr_val) == false) {
					alert("Please Check The Input Format");
					curr_val = "";
					$("#" + sel_col_id).val(curr_val);
				}
				$("#" + sel_col_id).val(curr_val);
				$("#" + next_col_id).select();

				// if (call_next_row == 1) {
				//     load_new_row_edit();
				// }
			}

			// Check if the current cell is the last cell in its row
			var $currentCell = $("#" + sel_col_id);
			var $row = $currentCell.closest('tr');
			var $lastCell = $row.find('td:last-child input');

			if ($currentCell.is($lastCell)) {
				var $nextRow = $row.next('tr');

				if ($nextRow.length) {
					var $nextFirstCell = $nextRow.find('td:first-child input');
					$nextFirstCell.select();
				} else {
					load_new_row_edit();
					$('#time_' + filed).select();
				}
			}
		}
	}
</script>

<script>
	var filed = <?php echo $val_array_index; ?>;
	function load_new_row_edit() {
		var tot_obs_well = $("#e_tot_obs_well").val();
		var curr_date_input = $("#date_"+filed).val();
		filed++;
		var datastr = "row_num="+filed+"&tot_obs_well="+tot_obs_well+"&curr_date_input="+curr_date_input;
		//alert(datastr);
		$.ajax({
			type: "post",
			url: "module/ground_water_ex/load_new_row_for_pt_ins_form_edit.php",
			data: datastr,
			success: function(st) {
				//alert("returned: "+st);
				$("#pt_ins_form_tbl_body").append(st);
				$('#time_' + filed).select();
				//$('#total_row').val(filed);
			}
		});
	}
</script>