<?php
	session_start();
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	extract($_GET);
	// print_r($_GET);
?>
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" />
<link rel="stylesheet" href="asset/custom/alertifyjs/css/alertify.rtl.css">
<link rel="stylesheet" href="asset/custom/alertifyjs/css/themes/default.rtl.css">
<link rel="stylesheet" href="asset/theme/css/custom_design.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
	.chart-grid {
		display: grid;
		grid-template-columns: repeat(<?php echo $grid_col; ?>, 1fr); /* dynamic columns */
		gap: 20px; /* Space between charts */
	}

	.chart-container {
		width: 100%; /* Make chart container fill grid cell */
		height: 300px; /* Fixed height for consistent look */
		border: 1px solid #ccc; /* Add border */
        padding: 5px;  /*Optional: Add padding inside the border */
        box-sizing: border-box; /* Include padding in width/height */
	}
</style>
<?php
	//$from_date = '16-MAR-2025'; $to_date = '22-MAR-2025';
	//echo $from_date;echo "<br/>";echo $to_date; 
	
	$from_date = date("d-M-Y", strtotime($from_date));
	$to_date = date("d-M-Y", strtotime($to_date));
	
	$db_from_date = strtoupper($from_date);
	$db_to_date = strtoupper($to_date);
	// echo $db_from_date;
	// exit();
	
	$stat_cols = "TRIM(KEYWORD) AS KEYWORD,TRIM(STATION_NAME) AS STATION_NAME,TRIM(RIVER_NAME) AS RIVER_NAME,
	TRIM(DISTRICT) AS DIST_NAME,
	CASE TRIM(DATA) WHEN 'RF' THEN 'R' ELSE 'W' END AS DATA_TYPE,DANGER_LEVEL,RECORDED_HIGH_WL";
	
	$stat_cond = "";
	if($stat_type=='ALL'){
		$stat_cond = "1=1";
	}
	else if($stat_type=='WL' || $stat_type=='RF'){
		$stat_cond = "UPPER(TRIM(DATA))='$stat_type'";
	}
	else{
		$stat_cond = "(',' || STATION_TAGS || ',') LIKE '%,$stat_type,%' ";
	}
	//only district selected
	if($dist!="" && $basin=="" && $m_div=="" && $river==""){
		$stat_cond .= " AND TRIM(DISTRICT)='$dist'";
	}
	//only basin selected
	else if($dist=="" && $basin!="" && $m_div=="" && $river==""){
		$stat_cond .= " AND TRIM(BASIN)='$basin'";
	}
	//only division selected
	else if($dist=="" && $basin=="" && $m_div!="" && $river==""){
		$stat_cond .= " AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//only river selected
	else if($dist=="" && $basin=="" && $m_div=="" && $river!=""){
		$stat_cond .= " AND TRIM(RIVER_NAME)='$river'";
	}
	//district and basin selected
	else if($dist!="" && $basin!="" && $m_div=="" && $river==""){
		$stat_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(BASIN)='$basin'";
	}
	//district and division selected
	else if($dist!="" && $basin=="" && $m_div!="" && $river==""){
		$stat_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//district and river selected
	else if($dist!="" && $basin=="" && $m_div=="" && $river!=""){
		$stat_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(RIVER_NAME)='$river'";
	}
	//basin and division selected
	else if($dist=="" && $basin!="" && $m_div!="" && $river==""){
		$stat_cond .= " AND TRIM(BASIN)='$basin' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//basin and river selected
	else if($dist=="" && $basin!="" && $m_div=="" && $river!=""){
		$stat_cond .= " AND TRIM(BASIN)='$basin' AND TRIM(RIVER_NAME)='$river'";
	}
	//district, basin, division and river selected
	else if($dist!="" && $basin!="" && $m_div!="" && $river!=""){
		$stat_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(BASIN)='$basin' 
		AND TRIM(MEASUREMEMT_DIVISION)='$m_div' AND TRIM(RIVER_NAME)='$river'";
	}
	//none is selected
	else{
		$stat_cond .= "";
	}
	$stat_cond .= "ORDER BY KEYWORD ASC";
	//echo "$stat_cond<br/>";
	$station_list = []; 

	foreach ($obj->View_colmn_By_Cond("FFWC.STATIONS_TBL",$stat_cols, $stat_cond) as $stat_info) {
		$station_list[] = [
			'name' => $stat_info['STATION_NAME'], 
			'keyword' => $stat_info['KEYWORD'], 
			'data_type' => $stat_info['DATA_TYPE'],
			'danger_level' => $stat_info['DANGER_LEVEL'],
			'recorded_hwl' => $stat_info['RECORDED_HIGH_WL'],
			'river_name' => $stat_info['RIVER_NAME'],
			'dist_name' => $stat_info['DIST_NAME']
		];
	  
	}
	
	// Example dynamic data (replace with your actual data source)
	$chartData = [];
	$modalData = [];
	$numCharts = count($station_list);


	
	$tbl = "FFWC.DATA_TBL";


	for ($i = 0; $i < $numCharts; $i++) {
		/*chart data*/
		$labels = []; 
		$data = [];
		$series_names = [];
		$titles = [];
		$graph_types = [];
		/*chart data*/
		/*modal_data*/
		$keywords = [];
		$to_dates = [];
		$data_types = [];
		$danger_level = [];
		$recorded_hwl = [];
		/*modal_data*/
		$key_id = strtolower($station_list[$i]['keyword']);
		$data_type = $station_list[$i]['data_type'];
		if($data_type=='R'){
			/*modal_data*/
			$keywords = $key_id;
			$to_dates = $db_to_date;
			$data_types = $data_type;
			/*modal_data*/
			$series_names = "Rainfall";
			$titles = $station_list[$i]['name']." (".$station_list[$i]['dist_name'].")";
			$graph_types = 'bar';
		}
		else{
			/*modal_data*/
			$keywords = $key_id;
			$to_dates = $db_to_date;
			$data_types = $data_type;
			/*modal_data*/
			$series_names = "Water Level";
			$titles = $station_list[$i]['name']." (".$station_list[$i]['river_name'].")";
			$graph_types = 'line';
		}
		$sel_dl = $station_list[$i]['danger_level'];
		$sel_rhwl = $station_list[$i]['recorded_hwl'];
		//$cond = "LOWER(STATION_CODE)='$key_id' and TO_DATE(M_DATE,'DD-MON-RRRR') BETWEEN '$db_from_date' and '$db_to_date' and D_TYPE='$data_type' ORDER BY M_DATE ASC";
		//$col = "TO_CHAR(M_DATE,'DD-MM-YYYY HH24:MI') AS READ_DATE,DATA_VALUE";
		foreach ($obj->ffwc_graph_data_loader($db_from_date,$db_to_date,$key_id,$data_type) as $value) {
			$read_dt_val = "";
			if($data_type=='W'){
				$read_dt_val = $value['READ_DATE_TIME'];
			}
			else{
				$read_dt_val = $value['READ_DATE'];
			}
			$labels[] = $read_dt_val;
			$data[] = $value['DATA_VALUE']; // Random data points
			$danger_level[] = $sel_dl;
			$recorded_hwl[] = $sel_rhwl;
		}
		
		$chartData[] = [
			'graph_type' => $graph_types,
			'display_mode' => $display_mode,
			'series_name' => $series_names,
			'title' => $titles,
			'labels' => $labels,
			'data' => $data,
			'danger_level_data' => $danger_level,
			'recorded_hwl_data' => $recorded_hwl,
		];
		$modalData[]=[
			'keyword' =>$keywords,
			'to_date' =>$to_dates,
			'data_type'=>$data_types,
			'display_mode' => $display_mode,
		];
	}
	//var_dump($chartData); exit;
?>
<div class="chart-grid">
	<?php
	// Generate canvas elements dynamically
	for ($i = 0; $i < $numCharts; $i++) {
		echo '<div class="chart-container">';
		// echo '<canvas id="chart' . $i . '"></canvas>';
		echo '<canvas id="chart' . $i . '" onclick="handleChartClick(' . $i . ')"></canvas>';
		echo '</div>';
	}
	?>
</div>

<!--<div class="span12">
	<input type="hidden" id="stattype" value="<?php echo $stat_type; ?>">
	<input type="hidden" id="dist" value="<?php echo $dist; ?>">
	<input type="hidden" id="basin" value="<?php echo $basin; ?>">
	<input type="hidden" id="mdiv" value="<?php echo $m_div; ?>">
	<input type="hidden" id="gridcol" value="<?php echo $grid_col; ?>">
</div>-->

<div id="stat_wise_graph" class="modal hide fade" style="margin-top: 20px; margin-left: -36%; width: 80%; " tabindex="-1">
    <div class="modal-header no-padding">
        <div class="table-header">
            <button type="button" class="close" data-dismiss="modal" style="opacity:1 !important"><i class="fa fa-window-close" style="font-size: 26px;font-weight: bold;color: #FFF;"></i> </button>
            <b>Graph for 30 days data</b>
        </div>
    </div>
    <div class="modal-body " id="stat_wise_graph_body" style="max-height: 600px;">
    </div>
    <div class="modal-footer "></div>
</div>

<script>
    // PHP data passed to JavaScript
    var chartData = <?php echo json_encode($chartData); ?>;

    // Loop through chart data and create line charts
    chartData.forEach(function(chart, index) {
        var ctx = document.getElementById('chart' + index).getContext('2d');
		var fill_graph = false;
		var graph_color = generateGraphColor();
		if(chart.graph_type=='bar'){
			fill_graph = true;
			graph_color = '#00ffff';
		}
		else{
			fill_graph = false;
			//graph_color = '#0066ff';
			graph_color = '#1aa3ff';
		}
		var minValue = Math.min(chart.data);
		var maxValue = Math.max(chart.data);
		if(chart.display_mode=="DL" && chart.series_name=="Water Level"){
			var newChart = new Chart(ctx, {
				type: chart.graph_type, // All charts are line charts
				data: {
					labels: chart.labels,
					datasets: [
						{
							label: chart.series_name,
							data: chart.data,
							borderColor: graph_color, //Random line color
							borderWidth: 3,
							pointRadius: 1.5,
							fill: fill_graph,
							backgroundColor: graph_color,
						},
						{
							label: 'Danger Level',
							data: chart.danger_level_data,
							borderColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#e60000',
							tension: 0.3
						},
					]
				},
				options: {
					/*elements: {
						point: {
							hoverRadius: 3 // Optional: Adjust hover radius if desired
						}
					},*/
					plugins: {
						legend: {
							display: false
						},
						title: {
							display: true,
							text: chart.title,
							font: {
								size: 16
							}
						}
					},
					scales: {
						y: {
							//beginAtZero: true
							suggestedMin: minValue,
							suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false,
				}
			});
		}
		else if(chart.display_mode=="HRL" && chart.series_name=="Water Level"){
			var newChart = new Chart(ctx, {
				type: chart.graph_type, // All charts are line charts
				data: {
					labels: chart.labels,
					datasets: [
						{
							label: chart.series_name,
							data: chart.data,
							borderColor: graph_color, //Random line color
							borderWidth: 3,
							pointRadius: 1.5,
							fill: fill_graph,
							backgroundColor: graph_color,
						},
						{
							label: 'Highest Recorded Level',
							data: chart.recorded_hwl_data,
							borderColor: '#5900b3',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#5900b3',
							tension: 0.3
						},
					]
				},
				options: {
					plugins: {
						legend: {
							display: false
						},
						title: {
							display: true,
							text: chart.title,
							font: {
								size: 16
							}
						}
					},
					scales: {
						y: {
							//beginAtZero: true
							suggestedMin: minValue,
							suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false,
				}
			});
		}
		else if(chart.display_mode=="BOTH" && chart.series_name=="Water Level"){
			var newChart = new Chart(ctx, {
				type: chart.graph_type, // All charts are line charts
				data: {
					labels: chart.labels,
					datasets: [
						{
							label: chart.series_name,
							data: chart.data,
							borderColor: graph_color, //Random line color
							borderWidth: 3,
							pointRadius: 1.5,
							fill: fill_graph,
							backgroundColor: graph_color,
						},
						{
							label: 'Danger Level',
							data: chart.danger_level_data,
							borderColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							tension: 0.3
						},
						{
							label: 'Highest Recorded Level',
							data: chart.recorded_hwl_data,
							borderColor: '#5900b3',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#5900b3',
							tension: 0.3
						},
					]
				},
				options: {
					plugins: {
						legend: {
							display: false
						},
						title: {
							display: true,
							text: chart.title,
							font: {
								size: 16
							}
						}
					},
					scales: {
						y: {
							//beginAtZero: true
							suggestedMin: minValue,
							suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false,
				}
			});
		}
        else{
			var newChart = new Chart(ctx, {
				type: chart.graph_type, // All charts are line charts
				data: {
					labels: chart.labels,
					datasets: [{
						label: chart.series_name,
						data: chart.data,
						borderColor: graph_color, //Random line color
						borderWidth: 3,
						pointRadius: 1.5,
						fill: fill_graph,
						backgroundColor: graph_color,
					}]
				},
				options: {
					plugins: {
						legend: {
							display: false
						},
						title: {
							display: true,
							text: chart.title,
							font: {
								size: 16
							}
						}
					},
					scales: {
						y: {
						  /*min: minValue,
						  max: maxValue*/
						  suggestedMin: minValue,
						  suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false,
				}
			});
		}
    });
	
	
	function generateGraphColor() {
		const bannedColors = [
			{ r: 230, g: 0, b: 0 },   // #e60000
			{ r: 245, g: 228, b: 31 } // #f5e41f
		];

		const minColorDistance = 60; // Minimum distance from banned colors
		const maxBrightness = 230;   // Cap brightness (0–255)

		let r, g, b;

		do {
			r = Math.floor(Math.random() * 256);
			g = Math.floor(Math.random() * 256);
			b = Math.floor(Math.random() * 256);
		} while (
			isTooBright(r, g, b, maxBrightness) ||
			isTooCloseToBannedColor(r, g, b, bannedColors, minColorDistance)
		);

		return `rgba(${r}, ${g}, ${b}, 1)`;
	}

	function getBrightness(r, g, b) {
		// Perceived brightness formula
		return 0.299 * r + 0.587 * g + 0.114 * b;
	}

	function colorDistance(r1, g1, b1, r2, g2, b2) {
		return Math.sqrt(
			Math.pow(r1 - r2, 2) +
			Math.pow(g1 - g2, 2) +
			Math.pow(b1 - b2, 2)
		);
	}

	function isTooBright(r, g, b, threshold) {
		return getBrightness(r, g, b) > threshold;
	}

	function isTooCloseToBannedColor(r, g, b, bannedColors, minDistance) {
		return bannedColors.some(color => {
			return colorDistance(r, g, b, color.r, color.g, color.b) < minDistance;
		});
	}

</script>

<script>
	
const modalData = <?php echo json_encode($modalData); ?>;

function handleChartClick(i) {
	var data = modalData[i];
	var keyword = data.keyword;
	var toDate = data.to_date;
	var dataType  = data.data_type;
	var modal_display_mode  = data.display_mode;
	
	var datastr = "key_id="+keyword+"&todate="+toDate+"&data_type="+dataType;
	//alert(datastr);
    $.ajax({
        url: "module/mobiledatalog/ffwc_graph_data.php",
        type: "POST",
        data: datastr,
		cache: false, // ⬅️ This disables caching
		success: function(response) {
			//alert(response);
			var chartResponse = JSON.parse(response);
			show30DayChart(chartResponse,modal_display_mode);
        }
    });
}




function show30DayChart(data,modal_display_mode) {
        const chartArea = document.getElementById("stat_wise_graph_body");
        chartArea.innerHTML = '<canvas id="last30Chart" style="height:400px;"></canvas>';

        var ctx = document.getElementById("last30Chart").getContext('2d');

        var color = generateGraphColor();
		var fill_graph = false;
		if(data.graph_type=='bar'){
			fill_graph = true;
			color = '#00ffff';
		}
		else{
			fill_graph = false;
			//color = '#0066ff';
			color = '#1aa3ff';
		}
		var minValue = Math.min(data.data);
		var maxValue = Math.max(data.data);
		var dangerLevel = data.danger_level_data[0];
		var recordedHlevel = data.recorded_hwl_data[0];
		if(modal_display_mode=="DL" && data.series_name=="Water Level"){
			new Chart(ctx, {
				type: data.graph_type,
				data: {
					labels: data.labels,
					datasets: [
						{
							label: data.series_name,
							data: data.data,
							borderColor: color,
							backgroundColor: color,
							borderWidth: 3,
							pointRadius: 1.5,
							fill: fill_graph
						},
						{
							label: 'Danger Level ('+dangerLevel+')',
							data: data.danger_level_data,
							borderColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							tension: 0.3
						},
					]
				},
				options: {
					plugins: {
						title: {
							display: true,
							text: data.title,
							font: { size: 16 }
						}
					},
					scales: {
						y: {
						  suggestedMin: minValue,
						  suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false
				}
			});
		}
		else if(modal_display_mode=="HRL" && data.series_name=="Water Level"){
			new Chart(ctx, {
				type: data.graph_type,
				data: {
					labels: data.labels,
					datasets: [
						{
							label: data.series_name,
							data: data.data,
							borderColor: color,
							backgroundColor: color,
							borderWidth: 3,
							pointRadius: 1.5,
							fill: fill_graph
						},
						{
							label: 'Highest Recorded Level ('+recordedHlevel+')',
							data: data.recorded_hwl_data,
							borderColor: '#5900b3',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#5900b3',
							//borderDash: [5, 5],
							pointRadius: 0,
							tension: 0.3
						},
					]
				},
				options: {
					plugins: {
						title: {
							display: true,
							text: data.title,
							font: { size: 16 }
						}
					},
					scales: {
						y: {
						  suggestedMin: minValue,
						  suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false
				}
			});
		}
		else if(modal_display_mode=="BOTH" && data.series_name=="Water Level"){
			new Chart(ctx, {
				type: data.graph_type,
				data: {
					labels: data.labels,
					datasets: [
						{
							label: data.series_name,
							data: data.data,
							borderColor: color,
							backgroundColor: color,
							borderWidth: 3,
							pointRadius: 1.5,
							fill: fill_graph
						},
						{
							label: 'Danger Level ('+dangerLevel+')',
							data: data.danger_level_data,
							borderColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#e60000',
							//borderDash: [5, 5],
							pointRadius: 0,
							tension: 0.3
						},
						{
							label: 'Highest Recorded Level ('+recordedHlevel+')',
							data: data.recorded_hwl_data,
							borderColor: '#5900b3',
							//borderDash: [5, 5],
							pointRadius: 0,
							fill: false,
							backgroundColor: '#5900b3',
							//borderDash: [5, 5],
							pointRadius: 0,
							tension: 0.3
						},
					]
				},
				options: {
					plugins: {
						title: {
							display: true,
							text: data.title,
							font: { size: 16 }
						}
					},
					scales: {
						y: {
						  suggestedMin: minValue,
						  suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false
				}
			});
		}
        else{
			new Chart(ctx, {
				type: data.graph_type,
				data: {
					labels: data.labels,
					datasets: [{
						label: data.series_name,
						data: data.data,
						borderColor: color,
						backgroundColor: color,
						borderWidth: 3,
						pointRadius: 1.5,
						fill: fill_graph
					}]
				},
				options: {
					plugins: {
						title: {
							display: true,
							text: data.title,
							font: { size: 16 }
						}
					},
					scales: {
						y: {
						  suggestedMin: minValue,
						  suggestedMax: maxValue
						}
					},
					responsive: true,
					maintainAspectRatio: false
				}
			});
		}

        $("#stat_wise_graph").modal("show");
    }
</script>