<?php
	session_start();
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	extract($_REQUEST);
    // print_r($_REQUEST);
	$station_details = $obj->Details_By_Cond("FFWC.STATIONS_TBL","LOWER(KEYWORD)='$key_id'");
	$station_name = $station_details['STATION_NAME'];
	$sel_dl = $station_details['DANGER_LEVEL'];
	$sel_rhwl = $station_details['RECORDED_HIGH_WL'];
	
	$to_datelist = date("d-M-Y", strtotime($todate));
    $to_date_tslist = strtotime($todate);

    // 30 days before timestamp
    $from_date_tslist = strtotime("-30 days", $to_date_tslist);

    $from_datelist = date("d-M-Y", $from_date_tslist); // Result: "14-Mar-2023"

    // Format both dates for Oracle's TO_DATE
    $db_to_datelist = date("d-M-Y", $to_date_tslist);        // e.g., 13-Apr-2023
    $db_from_datelist = date("d-M-Y", $from_date_tslist);

	$db_to_datelist = strtoupper($db_to_datelist);       
    $db_from_datelist = strtoupper($db_from_datelist);     

	$labels = [];
	$data = [];
	$danger_level = [];
	$recorded_hwl = [];
	foreach ($obj->ffwc_graph_data_loader($db_from_datelist,$db_to_datelist,$key_id,$data_type) as $row) {
		$read_dt_val = "";
		if($data_type=='W'){
			$read_dt_val = $row['READ_DATE_TIME'];
		}
		else{
			$read_dt_val = $row['READ_DATE'];
		}
			
		$labels[] = $read_dt_val;
		$data[] = $row['DATA_VALUE'];
		$danger_level[] = $sel_dl;
		$recorded_hwl[] = $sel_rhwl;
	}

	$response = [
		'graph_type' => $data_type == 'R' ? 'bar' : 'line',
		'series_name' => $data_type == 'R' ? 'Rainfall' : 'Water Level',
		'title' => ucfirst($data_type == 'R' ? 'Rainfall' : 'Water Level') . " Graph for $station_name from $from_datelist to $to_datelist",
		'labels' => $labels,
		'data' => $data,
		'danger_level_data' => $danger_level,
		'recorded_hwl_data' => $recorded_hwl,
	];
	
	echo json_encode($response);
?>

