<?php
	session_start();
	// ============
	// error_reporting(E_ALL);
	// ini_set('display_errors', 1);
	include("../../asset/theme/css/myfunc.php");
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	extract($_REQUEST);
	// ============
	$branchid = $_SESSION['LOGIN_BRANCH'];
	
	$header_list = [
		"STATION_CODE" => "Station ID",
		"STATION_NAME" => "Station Name",
		"KEYWORD" => "Keyword",
		"RIVER_NAME" => "River Name",
		"BASIN" => "Basin",
		"DISTRICT" => "District",
		"UPZILA" => "Upazila",
		"MEASUREMEMT_DIVISION" => "Measurememt Division",
		"MEASUREMENT_SUB_DIVISION" => "Measurememt Sub Division",
		"LATITUDE" => "Latitude",
		"LONGITUDE" => "Longitude",
		"MOBILE_NO" => "Mobile No",
		"DANGER_LEVEL" => "Danger Level",
		"RECORDED_HIGH_WL" => "QC High WL",
		"QC_MEAN_WL" => "QC Low WL",
		"PRE_MONSOON_DL" => "Pre Monsoon DL",
		"HIGH_WL_DATE" => "Date of RHWL",
		"PHONE_NO" => "Contact Info",
		"STATION_TAGS" => "Station Tags"
	];
	

	$allowed_keys = explode(",", $wl_stat_col_list);
	$allowed_keys = array_map('trim', $allowed_keys);
	$filtered = array_intersect_key($header_list, array_flip($allowed_keys));

	$ao_columns = [];
	// Optional: Set first column sortable, rest as `null`, and maybe last sortable (if needed)
	$ao_columns[] = '{ "bSortable": true }'; // first column

	foreach ($allowed_keys as $key) {
		$ao_columns[] = 'null';
	}
	$ao_columns[] = '{ "bSortable": true }'; // last column

	// Convert to string for JS
	$ao_columns_js = '[' . implode(',', $ao_columns) . ']';
	
	$where_cond = "STATION_TYPE='1'";
	
	
	if($stat_tag!=""){
		$where_cond .= " AND (',' || STATION_TAGS || ',') LIKE '%,$stat_tag,%'";
	}
	else{
		$where_cond .= "";
	}
	
	if($dist!="" && $basin=="" && $m_div=="" && $river==""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist'";
	}
	//only basin selected
	else if($dist=="" && $basin!="" && $m_div=="" && $river==""){
		$where_cond .= " AND TRIM(BASIN)='$basin'";
	}
	//only division selected
	else if($dist=="" && $basin=="" && $m_div!="" && $river==""){
		$where_cond .= " AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//only river selected
	else if($dist=="" && $basin=="" && $m_div=="" && $river!=""){
		$where_cond .= " AND TRIM(RIVER_NAME)='$river'";
	}
	//district and basin selected
	else if($dist!="" && $basin!="" && $m_div=="" && $river==""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(BASIN)='$basin'";
	}
	//district and division selected
	else if($dist!="" && $basin=="" && $m_div!="" && $river==""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//district and river selected
	else if($dist!="" && $basin=="" && $m_div=="" && $river!=""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(RIVER_NAME)='$river'";
	}
	//basin and division selected
	else if($dist=="" && $basin!="" && $m_div!="" && $river==""){
		$where_cond .= " AND TRIM(BASIN)='$basin' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//basin and river selected
	else if($dist=="" && $basin!="" && $m_div=="" && $river!=""){
		$where_cond .= " AND TRIM(BASIN)='$basin' AND TRIM(RIVER_NAME)='$river'";
	}
	//division and river selected
	else if($dist=="" && $basin=="" && $m_div!="" && $river!=""){
		$where_cond .= " AND TRIM(MEASUREMEMT_DIVISION)='$m_div' AND TRIM(RIVER_NAME)='$river'";
	}
	//district, basin, division and river selected
	else if($dist!="" && $basin!="" && $m_div!="" && $river!=""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(BASIN)='$basin' 
		AND TRIM(MEASUREMEMT_DIVISION)='$m_div' AND TRIM(RIVER_NAME)='$river'";
	}
	//none is selected
	else{
		$where_cond .= "";
	}
	$where_cond .= " ORDER BY STATION_NAME ASC";
	$table = "FFWC.STATIONS_TBL";
	$column = "PKID,$wl_stat_col_list";
	$sl = 0;
?>
<div>
	<table id="ffwc_wl_stat_datatbl" class="table table-striped table-bordered table-hover">
		<thead>
			<th style="text-align: center;">Sl</th>
		<?php	
			// Print the result
			foreach ($filtered as $key => $value) {
				echo '<th style="text-align: center;">'.$value.'</th>';
			}
		?>	
			<th style="text-align: center;">Action</th>
        </thead>
		<tbody>
		<?php
			foreach ($obj->View_colmn_By_Cond($table, $column, $where_cond) as $wl_stat_info) {
                $sl++;
				$pk_id = $wl_stat_info['PKID'];
				echo "<tr>";
					echo "<td style='text-align: center;'>$sl</td>";
					foreach ($filtered as $key => $value) {
						$cell_val = "";
						if($key=="STATION_TAGS"){
							$STATION_TAGS = $wl_stat_info[$key];
				
							$tag_lists = "";
							if($STATION_TAGS!=NULL || $STATION_TAGS!=null || $STATION_TAGS!=""){
								$tag_tbl = "FFWC.STATION_TAGS";
								$tag_cond = "ID IN ($STATION_TAGS)";
								foreach($obj->View_colmn_By_Cond($tag_tbl,"*",$tag_cond) as $tag_info){
									$tag_lists .= $tag_info['TAG_NAME'].", ";
								}
								$tag_lists = substr($tag_lists,0,-2);
							}
							else{
								$tag_lists = "";
							}
							$cell_val = $tag_lists;
						}
						else{
							$cell_val = $wl_stat_info[$key];
						}
						echo '<td style="text-align: center;">'.$cell_val.'</td>';
					}
					echo '<td style="text-align:center;">';
					echo '<a class="label label-info" style="hover:cursor; width: 38px;" href="#ffwc_modal-stat-view" data-toggle="modal" onclick="load_ffwc_station_vw_modal(\'' . $pk_id . '\')"> <i class="fa fa-eye"></i> View</a>';
					if($_SESSION['edit']=='Y'){
						echo '<br/><a class="label label-success" style="hover:cursor; width: 38px;" href="#ffwc_modal-stat-edit" data-toggle="modal" onclick="ffwc_load_station_edit_modal(\'' . $pk_id . '\')"> <i class="fa fa-edit"></i> Edit</a>';
					}	
				echo '</td>';
				echo "</tr>";
			}
		?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
   var oTable2 = $('#ffwc_wl_stat_datatbl').dataTable({
    "aoColumns": <?php echo $ao_columns_js; ?>,
    "iDisplayLength": 50
	});
</script>