$(document).ready(function(){
	load_ffwc_rf_stat_list();
});

function changedata(){
	const columnVisibility = document.getElementById('columnVisibilityrf');
    columnVisibility.style.display = columnVisibility.style.display === 'none' ? 'block' : 'none';
}

function toggleColumn(index) {
    const table = document.getElementById('ffwc_rf_stat_list');
    const checkbox = document.getElementById(`col${index + 1}`);
    const show = checkbox.checked ? 'table-cell' : 'none';

    // Toggle <th>
    const ths = table.querySelectorAll('thead th');
    if (ths[index]) {
        ths[index].style.display = show;
    }

    // Toggle <td> for each row
    const rows = table.querySelectorAll('tbody tr');
    rows.forEach(row => {
        const cells = row.querySelectorAll('td');
        if (cells[index]) {
            cells[index].style.display = show;
        }
    });
}

function load_sec_by_sd_id(sub_div){
	var datastr = "sub_div="+sub_div;
	  //alert(datastr);
	$("#sec_code_list_holder").load('module/surface_water/sw_sec_code_by_sub_div.php',datastr);
}

function e_load_sec_by_sd_id(e_sub_div){
	var datastr = "sub_div="+e_sub_div;
	//alert(datastr);
	$("#e_sec_code_list_holder").load('module/surface_water/sw_edit_sec_code_by_sub_div.php',datastr);
}
/////////--Validation--/////////
function validateInput(input) {
    if (!input || input.trim() === '') {
        return false; // Reject null or empty values
    }

    var regex = /(\b(on\w+)=|javascript:|(<\s*)(\/*)script)/i;
    if (input.length > 200 || regex.test(input)) {
        return false; // Reject values that match the regex or exceed 200 characters
    }

    return true; // Accept valid input
}

/////////--Validation--/////////

function load_ffwc_rf_stat_list(){
	var stat_tag = $("#stat_tag").val();
	var dist = $("#dist").val();
	var basin = $("#basin").val();
	var m_div = $("#m_div").val();
	var rf_stat_col_list = $("#rf_stat_col_list").val();
	//alert(wl_stat_col_list);
	if(!rf_stat_col_list){
		alert('Please Select Columns to see the data.');
	 	//$('#s_id').val('');
	 	$('#rf_stat_col_list').focus();
        return false;
	}
	else{
		var datastr = "stat_tag="+stat_tag+"&dist="+dist+"&basin="+basin+"&m_div="+m_div+"&rf_stat_col_list="+rf_stat_col_list;
		//alert(datastr);
		$('#cover-spin').show();
		$.ajax({
			url: "module/mobiledatalog/ffwc_rf_station_datatable.php",
			datatype: 'POST',
			data: datastr,
			success: function (data) {
				$('#cover-spin').hide();
				//alert(data);
				$("#show_ffwc_rf_stat_list").html(data);
			}
		});
	}
}

function load_ffwc_rf_stat_add_form(){
	$("#add_ffwc_rf_modal_body").html("");
	$("#add_ffwc_rf_modal_body").load("module/mobiledatalog/ffwc_rf_station_add_form.php");
}

//////////----Insert Data----/////////
function add_ffwc_rf_station(){
	//alert('add_ffwc_rf_station');
	var operation = "insert_ffwc_station_data";
	var s_id = $('#rf_s_id').val().trim();
	var stat_name =  $('#rf_stat_name').val().trim();
    var keyword =  $('#rf_key_word').val().trim();
    var data_type = $('#rf_data_type').val().trim();
    var basin = $('#rf_basin').val().trim();

	var stat_type = 2;

    var dist =  $('#rf_dist').val().trim();
    var upz =  $('#rf_upz').val().trim();
    var latitude =  $('#rf_lat').val().trim();
    var longitude =  $('#rf_long').val().trim();
    var mea_division =  $('#rf_mea_d').val().trim();
	var mea_sub_division =  $('#rf_mea_sd').val().trim();
	var phone =  $('#rf_phone_no').val().trim();
	var qch_rf =  $('#qch_rf').val().trim();
	var qcl_rf =  $('#qcl_rf').val().trim();
	var stationtagname =  $('#rf_stationtagname').val();
	var contactinfo =  $('#rf_contactinfo').val();
    //var riv_name =  "";

	if(s_id==""){
		alert('Station ID cannot be empty');
	 	$('#rf_s_id').focus();
        return false;
	}
	else if(validateInput(s_id) == false){
		alert('Please Insert The Station ID correctly');
	 	$('#rf_s_id').val('');
	 	$('#rf_s_id').focus();
        return false;
	}
    else if(stat_name==""){
		alert('Station Name cannot be empty');
	 	$('#rf_stat_name').focus();
        return false;
	}
	else if(validateInput(stat_name) == false){
		alert('Please Insert The Station Name correctly');
	 	$('#rf_stat_name').val('');
	 	$('#rf_stat_name').focus();
        return false;
	}
	else if(keyword==""){
	 	alert('Keyword cannot be empty');
	 	$('#rf_key_word').focus();
        return false;
	}
	else if(validateInput(keyword) == false){
	 	alert('Please Insert The keyword correctly');
	 	$('#rf_key_word').val('');
	 	$('#rf_key_word').focus();
        return false;
	}
	else if(phone==""){
	 	alert('Mobile No cannot be empty');
	 	$('#rf_phone_no').focus();
        return false;
	}
	else if(validateInput(phone) == false){
	 	alert('Please Insert The Mobile No correctly');
	 	$('#rf_phone_no').val('');
	 	$('#rf_phone_no').focus();
        return false;
	}
	else if(qch_rf==""){
	 	alert('QC High Rainfall cannot be empty');
	 	$('#qch_rf').focus();
        return false;
	}
	else if(validateInput(qch_rf) == false){
	 	alert('Please Insert The QC High Rainfall correctly');
	 	$('#qch_rf').val('');
	 	$('#qch_rf').focus();
        return false;
	}	
	else if(qcl_rf==""){
	 	alert('QC Low Rainfall cannot be empty');
	 	$('#qcl_rf').focus();
        return false;
	}
	else if(validateInput(qcl_rf) == false){
	 	alert('Please Insert The QC Low Rainfall correctly');
	 	$('#qcl_rf').val('');
	 	$('#qcl_rf').focus();
        return false;
	}
	else{
		var datastr = "operation="+operation+"&s_id="+s_id+"&stat_name="+stat_name+
		"&keyword="+keyword+"&data_type="+data_type+"&dist="+dist+"&upz="+upz+
		"&mea_d="+mea_division+"&mea_sd="+mea_sub_division+"&phone_no="+phone+
		"&stat_type="+stat_type+"&basin="+basin+"&latitude="+latitude+"&longitude="+longitude+
		"&qch_rf="+qch_rf+"&qcl_rf="+qcl_rf+"&stationtagname="+stationtagname+"&contactinfo="+contactinfo;
		//alert(datastr);
		$('#cover-spin').show(0);
		$.ajax({
			url:"module/mobiledatalog/ffwc_station_ajax.php",
			datatype:'post',
			data: datastr,
			success:function(data){
				$('#cover-spin').hide();
			//	alert(data);
				if(data !== 1){
					alert('Information has been added successfully');
					$('#ffwc_rf_stat_add_form').modal('hide');
					load_ffwc_rf_stat_list();
				}
				else{
					alert('error occurred');
				}
			}
		});
	}
}
//////////----Insert Data----/////////

function load_ffwc_rf_station_edit_modal(pk_id){
	$("#edit_ffwc_rf_modal_body").html("");
	var datastr = "pk_id="+pk_id;
	$("#edit_ffwc_rf_modal_body").load("module/mobiledatalog/ffwc_rf_station_edit_form.php",datastr);
}

function update_ffwc_rf_station(){
	var operation = "update_ffwc_station_data";
	var pk_id = $('#pk_id').val();
	var s_id = $('#e_rf_s_id').val().trim();
	var stat_name =  $('#e_rf_stat_name').val().trim();
    var keyword =  $('#e_rf_key_word').val().trim();
    var data_type = $('#e_rf_data_type').val().trim();
    var basin = $('#e_rf_basin').val().trim();

	var stat_type = 2;

    var dist =  $('#e_rf_dist').val().trim();
    var upz =  $('#e_rf_upz').val().trim();
    var latitude =  $('#e_rf_lat').val().trim();
    var longitude =  $('#e_rf_long').val().trim();
    var mea_division =  $('#e_rf_mea_d').val().trim();
	var mea_sub_division =  $('#e_rf_mea_sd').val().trim();
	var phone =  $('#e_rf_phone_no').val().trim();
	var qch_rf =  $('#e_qch_rf').val().trim();
	var qcl_rf =  $('#e_qcl_rf').val().trim();
	var contactinfo =  $('#updatecontact').val().trim();
	var e_stationtagname =  $('#updatestationtag').val();
    var riv_name =  "";
	
	if(s_id==""){
		alert('Station ID cannot be empty');
	 	$('#e_rf_s_id').focus();
        return false;
	}
	else if(validateInput(s_id) == false){
		alert('Please Insert The Station ID correctly');
	 	$('#e_rf_s_id').val('');
	 	$('#e_rf_s_id').focus();
        return false;
	}
	else if(stat_name==""){
		alert('Station Name cannot be empty');
	 	$('#e_rf_stat_name').focus();
        return false;
	}
	else if(validateInput(stat_name) == false){
		alert('Please Insert The Station Name correctly');
	 	$('#e_rf_stat_name').val('');
	 	$('#e_rf_stat_name').focus();
        return false;
	}
	else if(keyword==""){
	 	alert('Keyword cannot be empty');
	 	$('#e_rf_key_word').focus();
        return false;
	}
	else if(validateInput(keyword) == false){
	 	alert('Please Insert The keyword correctly');
	 	$('#e_rf_key_word').val('');
	 	$('#e_rf_key_word').focus();
        return false;
	}
	else if(phone==""){
	 	alert('Mobile No cannot be empty');
	 	$('#e_rf_phone_no').focus();
        return false;
	}
	else if(validateInput(phone) == false){
	 	alert('Please Insert The Mobile No correctly');
	 	$('#e_rf_phone_no').val('');
	 	$('#e_rf_phone_no').focus();
        return false;
	}
	else if(qch_rf==""){
	 	alert('QC High Rainfall cannot be empty');
	 	$('#e_qch_rf').focus();
        return false;
	}
	else if(validateInput(qch_rf) == false){
	 	alert('Please Insert The QC High Rainfall correctly');
	 	$('#e_qch_rf').val('');
	 	$('#e_qch_rf').focus();
        return false;
	}	
	else if(qcl_rf==""){
	 	alert('QC Low Rainfall cannot be empty');
	 	$('#e_qcl_rf').focus();
        return false;
	}
	else if(validateInput(qcl_rf) == false){
	 	alert('Please Insert The QC Low Rainfall correctly');
	 	$('#e_qcl_rf').val('');
	 	$('#e_qcl_rf').focus();
        return false;
	}
	else{
		var datastr = "operation="+operation+"&pk_id="+pk_id+"&s_id="+s_id+"&stat_name="+stat_name+
		"&keyword="+keyword+"&data_type="+data_type+"&dist="+dist+"&upz="+upz+
		"&mea_d="+mea_division+"&mea_sd="+mea_sub_division+"&phone_no="+phone+
		"&riv_name="+riv_name+"&stat_type="+stat_type+"&basin="+basin+
		"&latitude="+latitude+"&longitude="+longitude+"&qch_rf="+qch_rf+"&qcl_rf="+qcl_rf+
		"&updatestationtag="+e_stationtagname+"&updatecontact="+contactinfo;
	//	alert(datastr);
		$('#cover-spin').show(0);
		$.ajax({
			url:"module/mobiledatalog/ffwc_station_ajax.php",
			datatype:'post',
			data: datastr,
			success:function(data){
				$('#cover-spin').hide();
				//alert(data);
				if(data !== 1){
					//alert(datastr);
					alert('Information has been updated successfully');
					$('#ffwc_rf_stat_edit_form').modal('hide');
					load_ffwc_rf_stat_list();
				}
				else{
					//alert(datastr);
					alert('error occurred');
				}
			}
		});
	}
}

//////////----View Form----/////////
function load_ffwc_rf_station_vw_modal(pk_id){
	$("#ffwc_rf_stat_vw_body").html("");
	var datastr = "pk_id="+pk_id;
	//alert(datastr);
	$("#ffwc_rf_stat_vw_body").load("module/mobiledatalog/ffwc_rf_station_details_vw.php",datastr);
}
//////////----View Form----/////////
