var selectedDivWL;

function load_wl_info(station_wl) {
	var display_mode = $("#display_mode").val();
	var stations_wl = document.querySelectorAll('.station-list-wl .station_wl');
	stations_wl.forEach(function (item) {
		item.classList.remove('selected');
	});

	station_wl.classList.add('selected');

	// Update the selectedDivWL variable with the clicked station
	selectedDivWL = station_wl;

	var key_id = station_wl.getAttribute('data-station-key');
	var stationName = station_wl.getAttribute('data-station-name');
	var riverName = station_wl.getAttribute('data-river-name');

	var day = $('#day5').val();
	var date = $('#to_date').val();

	var datastr1 = "key_id=" + key_id + "&stationName=" + stationName + "&riverName=" + riverName + "&day=" + day + "&date=" + date;
	var datastr = "key_id=" + key_id + "&day=" + day + "&date=" + date;
	// alert(datastr1);
	$('#data_to_show_ffwc_wl').load('module/mobiledatalog/ffwc_water_level_datatable.php', datastr1);
	$('#cover-spin').show(0);

	$.ajax({
		type: "post",
		url: "module/mobiledatalog/ffwc_water_level_graph.php",
		data: datastr,
		success: function (str) {
			if ($.trim(str)) {
				$('#cover-spin').hide();

				var ffwc_wl_data = $.parseJSON(str);
				console.log(ffwc_wl_data);

				// Prepare data for Chart.js
				var labels = [];
				var waterLevelData = [];
				var dangerLevelData = [];
				var highestLevelData = [];

				for (var i = 0; i < ffwc_wl_data.length; i++) {
					labels.push(ffwc_wl_data[i][0]); // Date
					waterLevelData.push(parseFloat(ffwc_wl_data[i][1]));
					dangerLevelData.push(parseFloat(ffwc_wl_data[i][2]));
					highestLevelData.push(parseFloat(ffwc_wl_data[i][3]));
				}
				var minValue = Math.min(waterLevelData);
				var maxValue = Math.max(waterLevelData);
				var dangerLevel = dangerLevelData[0];
				var recordedHlevel = highestLevelData[0];
				// Destroy previous chart instance if exists
				if(display_mode=="BOTH"){
					if (window.ffwcChart) {
						window.ffwcChart.destroy();
					}

					var ctx = document.getElementById('graph_canvas_ffwc_wl').getContext('2d');
					window.ffwcChart = new Chart(ctx, {
						type: 'line',
						data: {
							labels: labels,
							datasets: [
								{
									label: 'Water Level',
									data: waterLevelData,
									borderColor: '#1aa3ff',
									//backgroundColor: 'rgba(0, 57, 230, 0.1)',
									backgroundColor: '#1aa3ff',
									pointRadius: 3,
									fill: false,
									tension: 0.3
								},
								{
									label: 'Danger Level ('+dangerLevel+')',
									data: dangerLevelData,
									borderColor: '#e60000',
									backgroundColor: '#e60000',
									//borderDash: [5, 5],
									pointRadius: 0,
									fill: false,
									tension: 0.3
								},
								{
									label: 'Highest Recorded Level ('+recordedHlevel+')',
									data: highestLevelData,
									borderColor: '#5900b3',
									backgroundColor: '#5900b3',
									//borderDash: [2, 4],
									pointRadius: 0,
									fill: false,
									tension: 0.3
								}
							]
						},
						options: {
							responsive: true,
							maintainAspectRatio: false,
							scales: {
								x: {
									title: {
										display: true,
										text: 'Date'
									}
								},
								y: {
									title: {
										display: true,
										text: 'Water Level (m)'
									},
									suggestedMin: minValue,
									suggestedMax: maxValue
								}
							},
							plugins: {
								title: {
									display: true,
									text: 'FFWC Water Level Information'
								},
								legend: {
									position: 'top'
								}
							}
						}
					});
				}
				else if(display_mode=="DL"){
					if (window.ffwcChart) {
						window.ffwcChart.destroy();
					}

					var ctx = document.getElementById('graph_canvas_ffwc_wl').getContext('2d');
					window.ffwcChart = new Chart(ctx, {
						type: 'line',
						data: {
							labels: labels,
							datasets: [
								{
									label: 'Water Level',
									data: waterLevelData,
									borderColor: '#1aa3ff',
									backgroundColor: '#1aa3ff',
									pointRadius: 3,
									fill: false,
									tension: 0.3
								},
								{
									label: 'Danger Level ('+dangerLevel+')',
									data: dangerLevelData,
									borderColor: '#e60000',
									backgroundColor: '#e60000',
									//borderDash: [5, 5],
									pointRadius: 0,
									fill: false,
									tension: 0.3
								}
							]
						},
						options: {
							responsive: true,
							maintainAspectRatio: false,
							scales: {
								x: {
									title: {
										display: true,
										text: 'Date'
									}
								},
								y: {
									title: {
										display: true,
										text: 'Water Level (m)'
									},
									suggestedMin: minValue,
									suggestedMax: maxValue
								}
							},
							plugins: {
								title: {
									display: true,
									text: 'FFWC Water Level Information'
								},
								legend: {
									position: 'top'
								}
							}
						}
					});
				}
				else if(display_mode=="HRL"){
					if (window.ffwcChart) {
						window.ffwcChart.destroy();
					}

					var ctx = document.getElementById('graph_canvas_ffwc_wl').getContext('2d');
					window.ffwcChart = new Chart(ctx, {
						type: 'line',
						data: {
							labels: labels,
							datasets: [
								{
									label: 'Water Level',
									data: waterLevelData,
									borderColor: '#1aa3ff',
									backgroundColor: '#1aa3ff',
									pointRadius: 3,
									fill: false,
									tension: 0.3
								},
								{
									label: 'Highest Recorded Level ('+recordedHlevel+')',
									data: highestLevelData,
									borderColor: '#5900b3',
									backgroundColor: '#5900b3',
									//borderDash: [2, 4],
									pointRadius: 0,
									fill: false,
									tension: 0.3
								}
							]
						},
						options: {
							responsive: true,
							maintainAspectRatio: false,
							scales: {
								x: {
									title: {
										display: true,
										text: 'Date'
									}
								},
								y: {
									title: {
										display: true,
										text: 'Water Level (m)'
									},
									suggestedMin: minValue,
									suggestedMax: maxValue
								}
							},
							plugins: {
								title: {
									display: true,
									text: 'FFWC Water Level Information'
								},
								legend: {
									position: 'top'
								}
							}
						}
					});
				}
				else{
					if (window.ffwcChart) {
						window.ffwcChart.destroy();
					}

					var ctx = document.getElementById('graph_canvas_ffwc_wl').getContext('2d');
					window.ffwcChart = new Chart(ctx, {
						type: 'line',
						data: {
							labels: labels,
							datasets: [
								{
									label: 'Water Level',
									data: waterLevelData,
									borderColor: '#1aa3ff',
									backgroundColor: '#1aa3ff',
									pointRadius: 3,
									fill: false,
									tension: 0.3
								}
							]
						},
						options: {
							responsive: true,
							maintainAspectRatio: false,
							scales: {
								x: {
									title: {
										display: true,
										text: 'Date'
									}
								},
								y: {
									title: {
										display: true,
										text: 'Water Level (m)'
									},
									suggestedMin: minValue,
									suggestedMax: maxValue
								}
							},
							plugins: {
								title: {
									display: true,
									text: 'FFWC Water Level Information'
								},
								legend: {
									position: 'top'
								}
							}
						}
					});
				}
			}
		}
	});
}


function ffwc_load_station_edit_modal(pk) {
	var pid = pk;
	var datastr = "pk=" + pid;

	// alert(datastr);
	if (pid == undefined) {
		alert("Data Migration of this particular station is not been done, please wait for the migration to edit this stations data.");
	}
	else {
		$("#ffwc_model_edit_body").load("module/mobiledatalog/ffwc_wl_edit_modal.php", datastr);
	}
	//alert(datastr);
}


function ffwc_load_station_add_modal(key_id){
	var keyid = key_id;
	var datastr = "keyid=" + keyid;
	$("#ffwc_model_add_body").load("module/mobiledatalog/ffwc_wl_add_modal.php",datastr);
}
function save_wl_data() {
	var operation = "save_wl_data";
	var pk = $('#pk_id').val();
	var wl_data = $('#wl_data').val();
	// alert(wl_data);
	var datastr = "operation=" + operation + "&wl_data=" + wl_data + "&pkid=" + pk;
	// alert(datastr);
	$.ajax({
		url: "module/mobiledatalog/ffwc_wl_ajax_update.php",
		datatype: 'post',
		data: datastr,
		success: function (data) {
			//	$('#cover-spin').hide();
			// alert(data);
			//console.log(data);
			if (data !== 1) {
				//alert(datastr);
				alert('Information has been updated successfully');
				$('.modal .close').click();
				// document.getElementById('ffwc_model_edit_body').style.display = 'none';
				load_wl_info(selectedDivWL);
			}
			else {
				//alert(datastr);
				alert('error occurred');
			}
		}
	});
}

function save_water_data(){
	// alert('ok');
	var operation = "save_water_data";
	var stationcode = $('#stationcode').val();
	var date_wl = $('#date_wl').val();
	var waterlevel = $('#waterlevel').val();
	
	if(date_wl==""){
		alert('Please mention the Date & Time');
	 	$('#date_wl').focus();
        return false;
	}
	else if(waterlevel==""){
		alert('Please mention the Water Level');
	 	$('#date_wl').focus();
        return false;
	}
	else{
		var datastr = "operation="+operation+"&date_wl="+date_wl+"&waterlevel="+waterlevel+"&stationcode="+stationcode;
		//alert(datastr);
		$('#cover-spin').show();
		$.ajax({
			url: "module/mobiledatalog/ffwc_wl_ajax.php",
			datatype: 'post',
			data: datastr,
			success: function (data) {
				$('#cover-spin').hide();
				//alert(data);
				if (data==1) {
					alert('Water Level has been added successfully');
					$('#modal_ffwc_wl_add').modal('hide');
					load_wl_info(selectedDivWL);
				}
				else {
					alert('error occurred');
				}
			}
		});
	}
	
}