$(document).ready(function(){
	load_wl_stat_info_list();
});

function load_wl_stat_info_list(){
	var stat_tag = $("#stat_tag").val();
	var dist = $("#dist").val();
	var basin = $("#basin").val();
	var m_div = $("#m_div").val();
	var river = $("#river").val();
	var wl_stat_col_list = $("#wl_stat_col_list").val();
	//alert(wl_stat_col_list);
	if(!wl_stat_col_list){
		alert('Please Select Columns to see the data.');
	 	//$('#s_id').val('');
	 	$('#wl_stat_col_list').focus();
        return false;
	}
	else{
		var datastr = "stat_tag="+stat_tag+"&dist="+dist+"&basin="+basin+"&river="+river+
		"&m_div="+m_div+"&wl_stat_col_list="+wl_stat_col_list;
		//alert(datastr);
		$('#cover-spin').show();
		$.ajax({
			url: "module/mobiledatalog/ffwc_station_datatable.php",
			datatype: 'POST',
			data: datastr,
			success: function (data) {
				$('#cover-spin').hide();
				//alert(data);
				$("#wl_stat_datatbl_holder").html(data);
			}
		});
	}
}

function changedata(){
	// alert('ok');
	const columnVisibility = document.getElementById('columnVisibility');
    columnVisibility.style.display = columnVisibility.style.display === 'none' ? 'block' : 'none';
}
function toggleColumn(index) {
    const table = document.getElementById('ffwc_wl_stat_datatbl');
    const checkbox = document.getElementById(`col${index + 1}`);
    const show = checkbox.checked ? 'table-cell' : 'none';

    // Toggle <th>
    const ths = table.querySelectorAll('thead th');
    if (ths[index]) {
        ths[index].style.display = show;
    }

    // Toggle <td> for each row
    const rows = table.querySelectorAll('tbody tr');
    rows.forEach(row => {
        const cells = row.querySelectorAll('td');
        if (cells[index]) {
            cells[index].style.display = show;
        }
    });
}

function load_sec_by_sd_id(sub_div){
	var datastr = "sub_div="+sub_div;
	  //alert(datastr);
	$("#sec_code_list_holder").load('module/surface_water/sw_sec_code_by_sub_div.php',datastr);
}

function e_load_sec_by_sd_id(e_sub_div){
	var datastr = "sub_div="+e_sub_div;
	//alert(datastr);
	$("#e_sec_code_list_holder").load('module/surface_water/sw_edit_sec_code_by_sub_div.php',datastr);
}
/////////--Validation--/////////
function validateInput(input) {
    if (!input || input.trim() === '') {
        return false; // Reject null or empty values
    }

    var regex = /(\b(on\w+)=|javascript:|(<\s*)(\/*)script)/i;
    if (input.length > 200 || regex.test(input)) {
        return false; // Reject values that match the regex or exceed 200 characters
    }

    return true; // Accept valid input
}

/////////--Validation--/////////
function add_station_ffwc(){
	$("#add_station_ffwc").html("");
	$("#add_station_ffwc").load("module/mobiledatalog/add_station_ffwc_modal.php");
}


function form_reset(){
	document.getElementById("add_station_modal").reset();
}

//////////----View Form----/////////
function load_ffwc_station_vw_modal(pk_id){
	$("#ffwc_model_stat_vw_body").html("");
	var datastr = "pk_id="+pk_id;
	//alert(datastr);
	$("#ffwc_model_stat_vw_body").load("module/mobiledatalog/ffwc_station_details_vw.php",datastr);
}
//////////----View Form----/////////

//////////----Edit Form----/////////
function ffwc_load_station_edit_modal(pk_id){
	$("#ffwc_model_stat_edit_body").html("");
	var datastr = "pk_id="+pk_id;
	//alert(datastr);
	$("#ffwc_model_stat_edit_body").load("module/mobiledatalog/ffwc_station_edit_form.php",datastr);
}
//////////----Edit Form----/////////

//////////----Insert Data----/////////
function add_ffwc_wl_station(){
	//console.log("Checking!");
	var operation = "insert_ffwc_station_data";
	var data_type = $('#data_type').val();
	var s_id = $('#s_id').val();
	var stat_name =  $('#stat_name').val();
    var keyword =  $('#key_word').val();
	var riv_name =  $('#riv_name').val();
	var basin =  $('#basin').val();
	var district =  $('#dist').val();
	var upazila =  $('#upz').val();
	var latitude =  $('#latitude').val();
    var longitude =  $('#longitude').val();
	var mea_division =  $('#mea_d').val();
	var mea_sub_division =  $('#mea_sd').val();
	var phone =  $('#phone_no').val();
	var rhwl =  $('#rhwl').val();
	var dt_rhwl =  $('#dt_rhwl').val();
	var qcm_wl =  $('#qcm_wl').val();
	var dng_wl =  $('#dng_wl').val();
	var pm_dng_wl =  $('#pm_dng_wl').val();
	// var is_fav =  $('#is_fav').val();
	var stationtagname =  $('#stationtagname').val();
	var contactinfo =  $('#contactinfo').val();
	var stat_type = 1;
	
	if(s_id==""){
		alert('Station ID cannot be empty');
	 	//$('#s_id').val('');
	 	$('#s_id').focus();
        return false;
	}
	else if(validateInput(s_id) == false){
		alert('Please Insert The Station ID Correctly');
	 	$('#s_id').val('');
	 	$('#s_id').focus();
        return false;
	}
    else if(stat_name==""){
		alert('Station Name cannot be empty');
	 	$('#stat_name').focus();
        return false;
	}
	else if(validateInput(stat_name) == false){
		alert('Please Insert The Station Name correctly');
	 	$('#stat_name').val('');
	 	$('#stat_name').focus();
        return false;
	}
	else if(keyword==""){
		alert('Keyword cannot be empty');
	 	$('#key_word').focus();
        return false;
	}
	else if(validateInput(keyword) == false){
		alert('Please Insert The Keyword correctly');
	 	$('#key_word').val('');
	 	$('#key_word').focus();
        return false;
	}
	else if(phone==""){
	 	alert('Mobile Number cannot be empty');
	 	$('#phone_no').focus();
        return false;
	}
	else if(validateInput(phone) == false){
	 	alert('Please Insert The Mobile Number correctly');
	 	$('#phone_no').val('');
	 	$('#phone_no').focus();
        return false;
	}
	else if(rhwl==""){
	 	alert('QC Highest Water Level cannot be empty');
	 	$('#rhwl').focus();
        return false;
	}
	else if(validateInput(rhwl) == false){
	 	alert('Please Insert QC Highest Water Level correctly');
	 	$('#rhwl').val('');
	 	$('#rhwl').focus();
        return false;
	}
	else if(qcm_wl==""){
	 	alert('QC Mean Water Level cannot be empty');
	 	$('#qcm_wl').focus();
        return false;
	}
	else if(validateInput(qcm_wl) == false){
	 	alert('Please Insert QC Mean Water Level correctly');
	 	$('#qcm_wl').val('');
	 	$('#qcm_wl').focus();
         return false;
	}
	else{
		var datastr = "operation="+operation+"&data_type="+data_type+"&s_id="+s_id+
		"&stat_name="+stat_name+"&keyword="+keyword+"&riv_name="+riv_name+
		"&basin="+basin+"&dist="+district+"&upz="+upazila+"&latitude="+latitude+
		"&longitude="+longitude+"&mea_d="+mea_division+"&mea_sd="+mea_sub_division+
		"&phone_no="+phone+"&rhwl="+rhwl+"&dt_rhwl="+dt_rhwl+"&qcm_wl="+qcm_wl+
		"&dng_wl="+dng_wl+"&pm_dng_wl="+pm_dng_wl+"&stat_type="+stat_type+"&stationtagname="+stationtagname+"&contactinfo="+contactinfo;
		//alert(datastr);

		$('#cover-spin').show(0);
		$.ajax({
			url:"module/mobiledatalog/ffwc_station_ajax.php",
			datatype:'post',
			data: datastr,
			success:function(data){
			//	$('#cover-spin').hide();
				//alert(data);
				if(data !== 1){
					alert('Information has been added successfully');
					$('#ffwc_modal_station').modal('hide');
					load_wl_stat_info_list();
				}
				else{
					alert('error occurred');
				}
			}
		});
	}
}
//////////----Insert Data----/////////

//////////----Insert Data----/////////
function update_ffwc_wl_station(){
	var operation = "update_ffwc_station_data";
	var data_type = $('#data_type').val();
	var pk_id = $('#pk_id').val();
	var s_id = $('#s_id').val();
	var stat_name =  $('#stat_name').val();
    var keyword =  $('#key_word').val();
	var riv_name =  $('#riv_name').val();
	var basin =  $('#basin').val();
	var district =  $('#dist').val();
	var upazila =  $('#upz').val();
	var latitude =  $('#latitude').val();
    var longitude =  $('#longitude').val();
	var mea_division =  $('#mea_d').val();
	var mea_sub_division =  $('#mea_sd').val();
	var phone =  $('#phone_no').val();
	var rhwl =  $('#rhwl').val();
	var dt_rhwl =  $('#dt_rhwl').val();
	var qcm_wl =  $('#qcm_wl').val();
//	var dt_rlwl =  $('#dt_rlwl').val();
	var dng_wl =  $('#dng_wl').val();
	var pm_dng_wl =  $('#pm_dng_wl').val();
	// var is_fav_up =  $('#is_fav').val();
	var updatestationtag =  $('#updatestationtag').val();
	var updatecontact =  $('#updatecontact').val();

	var stat_type = 1;

    
	if(s_id==""){
		alert('Station ID cannot be empty');
	 	//$('#s_id').val('');
	 	$('#s_id').focus();
        return false;
	}
	else if(validateInput(s_id) == false){
		alert('Please Insert The Station ID correctly');
	 	$('#s_id').val('');
	 	$('#s_id').focus();
        return false;
	}
    else if(stat_name==""){
		alert('Station Name cannot be empty');
	 	$('#stat_name').focus();
        return false;
	} 
	else if(validateInput(stat_name) == false){
		alert('Please Insert The Station Name correctly');
	 	$('#stat_name').val('');
	 	$('#stat_name').focus();
         return false;
	}
	else if(keyword==""){
		alert('Keyword cannot be empty');
	 	$('#key_word').focus();
        return false;
	}
	else if(validateInput(keyword) == false){
		alert('Please Insert The Keyword correctly');
	 	$('#key_word').val('');
	 	$('#key_word').focus();
         return false;
	}
	else if(phone==""){
	 	alert('Mobile Number cannot be empty');
	 	$('#phone_no').focus();
        return false;
	}
	else if(validateInput(phone) == false){
	 	alert('Please Insert The Phone No. correctly');
	 	$('#phone_no').val('');
	 	$('#phone_no').focus();
         return false;
	}
	else if(rhwl==""){
	 	alert('QC Highest Water Level cannot be empty');
	 	$('#rhwl').focus();
        return false;
	}
	else if(validateInput(rhwl) == false){
	 	alert('Please Insert Recorded highest water level correctly');
	 	$('#rhwl').val('');
	 	$('#rhwl').focus();
         return false;
	}
	else if(qcm_wl==""){
	 	alert('QC Mean Water Level cannot be empty');
	 	$('#qcm_wl').focus();
        return false;
	}
	else if(validateInput(qcm_wl) == false){
	 	alert('Please Insert QC mean water level correctly');
	 	$('#qcm_wl').val('');
	 	$('#qcm_wl').focus();
         return false;
	}
	else{
		var datastr ="operation="+operation+"&data_type="+data_type+"&pk_id="+pk_id+
		"&s_id="+s_id+"&stat_name="+stat_name+"&keyword="+keyword+"&riv_name="+riv_name+
		"&basin="+basin+"&dist="+district+"&upz="+upazila+"&latitude="+latitude+
		"&longitude="+longitude+"&mea_d="+mea_division+"&mea_sd="+mea_sub_division+
		"&phone_no="+phone+"&rhwl="+rhwl+"&dt_rhwl="+dt_rhwl+"&qcm_wl="+qcm_wl+
		"&dng_wl="+dng_wl+"&pm_dng_wl="+pm_dng_wl+"&stat_type="+stat_type+"&updatecontact="+updatecontact+"&updatestationtag="+updatestationtag;
		//alert(datastr);
		$.ajax({
			url:"module/mobiledatalog/ffwc_station_ajax.php",
			datatype:'post',
			data: datastr,
			success:function(data){
			//	$('#cover-spin').hide();
				//alert(data);
				//console.log(data);
				if(data !== 1){
					//alert(datastr);
					alert('Information has been updated successfully');
					$('#ffwc_modal-stat-edit').modal('hide');
					load_wl_stat_info_list();
				}
				else{
					//alert(datastr);
					alert('error occurred');
				}
			}
		});
	}
}
//////////----Update Data----/////////
