<?php
	session_start();
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	
	$show_to_date = date("d-m-Y");
	$to_date_cal = date("Y-m-d");
	$to_date_ts = strtotime($to_date_cal);
	$from_date_ts = strtotime("-6 days", $to_date_ts);
	$from_date_cal = date("Y-m-d", $from_date_ts);
	$show_from_date = date("d-m-Y", strtotime($from_date_cal));

?> 
<style>
	.chzn-container-single .chzn-drop .chzn-search input[type="text"] {
		background-image: none !important;
		padding-left: 5px !important; /* adjust as needed */
	}
</style>
<!-- <div id="cover-spin"></div> -->
<div class="table-header">
	<i class="icon-bar-chart"></i> Graphical View of FFWC Stations  
</div>
<div class="row-fluid" id="ffwc_graph_filter" style="padding-bottom: 10px; margin-top: -4px; background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black;">
	<table style="width: 100%;  margin-left: 5px; margin-top: 10px;">
		<tr>
			<td style="font-weight: bold; width: 15%;">Station Type</td>
			<td style="font-weight: bold; width: 10%;">Basin</td>
			<td style="font-weight: bold; width: 10%;">River</td>
			
			<td style="font-weight: bold; width: 10%;">Division</td>
			<td style="font-weight: bold; width: 10%;">District</td>
			
			<td style="font-weight: bold; width: 5%;">From Date</td>
			<td style="font-weight: bold; width: 5%;">To Date</td>
			
			<td style="font-weight: bold; width: 5%;">Column No.</td>
			<td style="font-weight: bold; width: 10%;">Display Mode</td>
			<td style="font-weight: bold; width: 10%;"></td>
		</tr>
		<tr>
			<td>
				<select id="stat_type" name="stat_type" class="chosen-select-on" style="height: 12px !important;">
					<?php
					$tag_tbl = "FFWC.STATION_TAGS";
					$tag_cols = "ID,TAG_NAME";
					$tag_cond = "STATUS='A' ORDER BY TAG_NAME ASC";

					foreach ($obj->View_colmn_By_Cond($tag_tbl, $tag_cols, $tag_cond) as $tag_info) {
						echo '<option value="'.$tag_info['ID'].'" '.$is_default.'>'.$tag_info['TAG_NAME'].'</option>';
					}
					?>
					<option value="WL">Water Level</option>
					<option value="RF">Rainfall</option>
					<option value="ALL">All</option>
				</select>
			</td>
			<td>
				<select id="basin" name="basin" class="chosen-select-on" style="height: 12px !important;" onchange="reset_params('basin')">
					<option value=""></option>
					<?php
					$basin_tbl = '(SELECT TRIM(BASIN) AS TRIM_BASIN FROM FFWC.STATIONS_TBL ORDER BY BASIN ASC) BASIN_TBL';
					$basin_col = 'DISTINCT(TRIM_BASIN) as BASIN';
					$basin_cond = 'TRIM_BASIN IS NOT NULL ORDER BY TRIM_BASIN';

					foreach ($obj->View_colmn_By_Cond($basin_tbl, $basin_col, $basin_cond) as $basin_info) {
						echo '<option value="'.$basin_info['BASIN'].'">'.$basin_info['BASIN'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="river" name="river" class="chosen-select-on" style="height: 12px !important;" onchange="reset_params('river')">
					<option value=""></option>
					<?php
					$river_tbl = '(SELECT TRIM(RIVER_NAME) AS TRIM_RIVER FROM FFWC.STATIONS_TBL ORDER BY RIVER_NAME ASC) RIVER_TBL';
					$river_col = 'DISTINCT(TRIM_RIVER) as RIVER';
					$river_cond = 'TRIM_RIVER IS NOT NULL ORDER BY TRIM_RIVER';

					foreach ($obj->View_colmn_By_Cond($river_tbl, $river_col, $river_cond) as $river_info) {
						echo '<option value="'.$river_info['RIVER'].'">'.$river_info['RIVER'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="m_div" name="m_div" class="chosen-select-on" style="height: 12px !important;" onchange="reset_params('m_div')">
					<option value=""></option>
					<?php
					$m_div_tbl = '(SELECT TRIM(MEASUREMEMT_DIVISION) AS TRIM_M_DIV FROM FFWC.STATIONS_TBL ORDER BY MEASUREMEMT_DIVISION ASC) M_DIV_TBL';
					$m_div_col = 'DISTINCT(TRIM_M_DIV) as M_DIV';
					$m_div_cond = 'TRIM_M_DIV IS NOT NULL ORDER BY TRIM_M_DIV';

					foreach ($obj->View_colmn_By_Cond($m_div_tbl, $m_div_col, $m_div_cond) as $m_div_info) {
						echo '<option value="'.$m_div_info['M_DIV'].'">'.$m_div_info['M_DIV'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="dist" name="dist" class="chosen-select-on" style="height: 12px !important;" onchange="reset_params('dist')">
					<option value=""></option>
					<?php
					$dist_tbl = '(SELECT TRIM(DISTRICT) AS TRIM_DIST FROM FFWC.STATIONS_TBL ORDER BY DISTRICT ASC) DIST_TBL';
					$dist_col = 'DISTINCT(TRIM_DIST) AS DIST';
					$dist_cond = 'TRIM_DIST IS NOT NULL ORDER BY TRIM_DIST';

					foreach ($obj->View_colmn_By_Cond($dist_tbl, $dist_col, $dist_cond) as $dist_info) {
						echo '<option value="'.$dist_info['DIST'].'">'.$dist_info['DIST'].'</option>';
					}
					?>
				</select>
			</td>
			<td style="padding-top: 10px;">
				<input style="width: 100px; height:15px!important;" id="from_date" name="from_date" class="date-picker" type="text" data-date-format="dd-mm-yyyy" placeholder="dd-mm-yyyy" value="<?php echo $show_from_date; ?>" />
			</td>
			<td style="padding-top: 10px;">
				<input style="width: 100px; height:15px!important;" id="to_date" name="to_date" class="date-picker" type="text" data-date-format="dd-mm-yyyy" placeholder="dd-mm-yyyy" value="<?php echo $show_to_date; ?>" />
			</td>
			<td>
				<select id="grid_col" name="grid_col" class="chosen-select-on" style="height: 12px !important;">
					<?php
					$col_num_tbl = "FFWC.MULTI_GRAPH_DISPLAY_COLS_NUM";
					$col_num_cols = "NUMBER_OF_COLUMNS,IS_DEFAULT";
					$col_num_cond = "STATUS='A' ORDER BY NUMBER_OF_COLUMNS ASC";

					foreach ($obj->View_colmn_By_Cond($col_num_tbl, $col_num_cols, $col_num_cond) as $col_num_info) {
						$is_default = "";
						if($col_num_info['IS_DEFAULT']==1){
							$is_default = "selected";
						}
						echo '<option value="'.$col_num_info['NUMBER_OF_COLUMNS'].'" '.$is_default.'>'.$col_num_info['NUMBER_OF_COLUMNS'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="display_mode" name="display_mode" class="chosen-select-off" style="height: 12px !important;" onchange="reload_wl_view()">
					<option value="NONE">--Select--</option>
					<option value="DL">Danger Level</option>
					<option value="HRL">Highest Recorded Level</option>
					<option value="BOTH">Both</option>
				</select>
			</td>
			<td style="padding-left: 20px;">
				<button type="button" onclick="load_multi_graph_page()" id="mgd_loader_btn" class="btn btn-minier btn-success" style="padding: 4px !important;">
					<i class="icon-search"></i> <b style="font-size: 12px;">Graphs</b>
				</button>
			</td>
		</tr>
	</table>
</div>
<div class="row-fluid" style="margin-top: 7px;" id="ffwc_graph_grid_holder"></div>

<script type="text/javascript">
    $('.date-picker').datepicker().next().on(ace.click_event, function() {
        $(this).prev().focus();
    });
    $(".date-picker").attr("autocomplete", "off");
</script>
<script>
	$( document ).ready(function() {
      load_multi_graph_page();
    });
	$('.chosen-select-on').chosen({
		allow_single_deselect: true
	});
	//resize the chosen on window resize
	$(window)
		.off('resize.chosen')
		.on('resize.chosen', function() {
			$('.chosen-select-on').each(function() {
				var $this = $(this);
				$this.next().css({
					'width': '90%'
				});
			});
		}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if (event_name != 'sidebar_collapsed') return;
		$('.chosen-select-on').each(function() {
			var $this = $(this);
			$this.next().css({
				'width': '90%'
			});
		});
	});
   
	function reset_params(sel_param){
		// alert(sel_param);
		if(sel_param=='dist'){
			$('#basin').val('').trigger('liszt:updated');
			$('#m_div').val('').trigger('liszt:updated');
			$('#river').val('').trigger('liszt:updated');
		}
		else if(sel_param=='basin'){
			$('#dist').val('').trigger('liszt:updated');
			$('#m_div').val('').trigger('liszt:updated');
			$('#river').val('').trigger('liszt:updated');
		}
		else if(sel_param=='river'){
			$('#dist').val('').trigger('liszt:updated');
			$('#basin').val('').trigger('liszt:updated');
			$('#m_div').val('').trigger('liszt:updated');
		}
		else{
			$('#dist').val('').trigger('liszt:updated');
			$('#basin').val('').trigger('liszt:updated');
			$('#river').val('').trigger('liszt:updated');
		}
	}
	
	function load_multi_graph_page(){
		var stat_type = $("#stat_type").val();
		var dist = $("#dist").val();
		var basin = $("#basin").val();
		var m_div = $("#m_div").val();
		var river = $("#river").val();
		var from_date = $("#from_date").val();
		var to_date = $("#to_date").val();
		var grid_col = $("#grid_col").val();
		var display_mode = $("#display_mode").val();
		
		var date_str = "from_date="+from_date+"&to_date="+to_date;
		// alert(date_str);
		$.ajax({
            url: 'module/mobiledatalog/graph_grid_date_checker.php',
            type: 'get',
            data: date_str,
            success: function (res){
				if(res==1){
					var datastr = "stat_type="+stat_type+"&dist="+dist+"&basin="+basin+"&river="+river
					+"&m_div="+m_div+"&from_date="+from_date+"&to_date="+to_date+"&grid_col="+grid_col
					+"&display_mode="+display_mode;
					// alert(datastr);
					$('#cover-spin').show(0);
					
					$.ajax({
						url: 'module/mobiledatalog/ffwc_dashboard_graph_grid.php',
						type: 'get',
						data: datastr,
						success: function (data){
						//alert(data);
							$('#cover-spin').hide();
							$('#ffwc_graph_grid_holder').html(data);
						}
					});
				}
				else{
					alert(res);
					$('#ffwc_graph_grid_holder').html("");
				}
            }
        });
	}
</script>

<script>
	$('.chosen-select-off').chosen({allow_single_deselect: true, disable_search: true});
	//resize the chosen on window resize
	$(window)
		.off('resize.chosen')
		.on('resize.chosen', function() {
			$('.chosen-select-off').each(function() {
				var $this = $(this);
				$this.next().css({
					'width': '100%'
				});
			});
		}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if (event_name != 'sidebar_collapsed') return;
		$('.chosen-select-off').each(function() {
			var $this = $(this);
			$this.next().css({
				'width': '100%'
			});
		});
	});
</script>
