<style>
	.excl_input {
		width: 100%;
		box-sizing: border-box;
	}
	input[readonly] {
		background-color: #f0f0f0;
	}
</style>
<?php
	session_start();
	error_reporting(1);  //E_ALL
	ini_set('display_errors', TRUE);
	ini_set('display_startup_errors', TRUE);
	
	require_once('../../asset/custom/PHPExcel_class/PHPExcel.php');
	require_once('../../asset/custom/PHPExcel_class/PHPExcel/Calculation.php');
	require_once('../../asset/custom/PHPExcel_class/PHPExcel/Cell.php');
	
	include("../../php_crud/my_class.php");
	$obj = new my_class();

	$data_type = trim($_POST['data_type']);
	$stat_col_list = trim($_POST['stat_col_list']);
	
	$file = $_FILES['stat_file']['name'];

	$dir = '../../asset/custom/upload/';	 
	$excel_file = $dir .$file;

	if(file_exists($excel_file)){
		//echo "file_exists<br/>";
	  unlink($excel_file);
	}


	$header_col_list = "SL,KEYWORD,$stat_col_list";

	$header_list = [
		"SL" => "Sl",
		"KEYWORD" => "Keyword",
		"STATION_CODE" => "Station ID",
		"STATION_NAME" => "Station Name",
		"RIVER_NAME" => "River Name",
		"BASIN" => "Basin",
		"DISTRICT" => "District",
		"UPZILA" => "Upazila",
		"MEASUREMEMT_DIVISION" => "Measurememt Division",
		"MEASUREMENT_SUB_DIVISION" => "Measurememt Sub Division",
		"LATITUDE" => "Latitude",
		"LONGITUDE" => "Longitude",
		"MOBILE_NO" => "Mobile No",
		"DANGER_LEVEL" => "Danger Level",
		"RECORDED_HIGH_WL" => "QC High WL",
		"QC_MEAN_WL" => "QC Low WL",
		"PRE_MONSOON_DL" => "Pre Monsoon DL",
		"HIGH_WL_DATE" => "Date of RHWL",
		"QC_HIGH_RF" => "QC High RF",
		"QC_LOW_RF" => "QC Low RF",
		"PHONE_NO" => "Contact Info",
		"STATION_TAGS" => "Station Tags"
	];
	
	$allowed_header_keys = explode(",", $header_col_list);
	//$allowed_header_keys = array_map('trim', $allowed_header_keys);
	//$filtered_header = array_intersect_key($header_list, array_flip($allowed_header_keys));
	
if(is_writable($dir)) 
{
	//echo "write directory<br/>";
	if(move_uploaded_file($_FILES['stat_file']['tmp_name'] , $excel_file))	
	{									
		//echo "file_moved<br/>";
		$i =0;
		
		$inputFileType = 'Excel5';			
		$inputFileName =  $excel_file;
			
		try {
			//echo "<br/>inside try";
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			//echo "<br/>input file worked";
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			//echo "<br/>objReader worked";
			$objPHPExcel = $objReader->load($inputFileName);
			//echo "<br/>objPHPExcel worked";
		} catch (Exception $e) {
			echo $excel_file;
			echo "<br/>";
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}
			
		$worksheet = $objPHPExcel->getSheet(0);
		$highestRow = $worksheet->getHighestRow();
		$highestC = $worksheet->getHighestColumn();
			
		$headerRow = $worksheet->rangeToArray('A5:' . $worksheet->getHighestColumn() . '5')[0];
		
		$columnMap = [];
		foreach ($headerRow as $index => $header) {
			foreach ($allowed_header_keys as $key) {
				if ($header === $header_list[$key]) {
					$columnMap[$key] = $index;
				}
			}
		}
		
		$data = [];
		$highestRow = $worksheet->getHighestRow();

		for ($row = 6; $row <= $highestRow; $row++) {
			$rowArray = $worksheet->rangeToArray("A{$row}:" . $worksheet->getHighestColumn() . "{$row}", null, true, false)[0];

			$rowData = [];
			foreach ($columnMap as $key => $colIndex) {
				$rowData[$key] = $rowArray[$colIndex] ?? null;
			}

			// Optional: Skip entirely empty rows
			if (array_filter($rowData)) {
				$data[] = $rowData;
			}
		}
		

		// Output the result
		//print_r($data);
	}
	else{
		echo "upload error";
	}
}else{
   echo "File Could not Upload .Check Directory permission missing";	   
}
unlink($excel_file);	
?>
<div class="row-fluid" style="margin-bottom:5px;">
	<div class="control-group" style="float:left;">
		<div class="controls">
			<button id="btn_save_excl_stat_info" type="button" style="margin-left: 1px; font-size: 12px;" 
			class="btn btn-small btn-success " onclick="save_excl_stat_info()"><i class="icon-save"></i><b>Save All</b></button>
		</div>
	</div>
	<div class="control-group" style="float:right;">
		<div class="controls">
			<button id="btn_save_excl_stat_info" type="button" style="margin-right: 1px; font-size: 12px;" 
			class="btn btn-small btn-success " onclick="save_excl_stat_info()"><i class="icon-save"></i><b>Save All</b></button>
		</div>
	</div>
</div>

<table style='border-collapse: collapse; width: 100%;'>
    <thead>
        <tr>
            <?php foreach ($allowed_header_keys as $key): ?>
                <th style="padding: 8px; border: 1px solid #ccc;"><?php echo htmlspecialchars($header_list[$key]); ?></th>
            <?php endforeach; ?>
        </tr>
    </thead>
    <tbody>
        <?php 
			$displayData = array_slice($data, 0, max(0, count($data) - 3));
			foreach ($displayData as $rowIndex => $row): ?>
            <tr>
                <?php foreach ($allowed_header_keys as $colIndex => $key):
					$value = $row[$key] ?? '';
					if($key=='HIGH_WL_DATE'){
						if (is_numeric($value)) {
							// Convert Excel date serial number to Unix timestamp
							$timestamp = PHPExcel_Shared_Date::ExcelToPHP($value);
							// Format the timestamp as 'd-M-y' (e.g., 28-May-25)
							$value = date('d-M-y', $timestamp);
						} else {
							// If it's not numeric, assume it's already a formatted date string
							$value = $value;
						}
					}
				?>
                    <td style="padding: 8px; border: 1px solid #ccc;">
                        <input class="excl_input"
                            type="text" 
                            name="data[<?php echo $rowIndex; ?>][<?php echo $key; ?>]"
                            value="<?php echo htmlspecialchars($value); ?>"
                            <?php echo ($colIndex < 2) ? 'readonly' : ''; ?>
                        >
                    </td>
                <?php endforeach; ?>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<div class="row-fluid" style="margin-top:5px;">
	<div class="control-group" style="float:left;">
		<div class="controls">
			<button id="btn_save_excl_stat_info" type="button" style="margin-left: 1px; font-size: 12px;" 
			class="btn btn-small btn-success " onclick="save_excl_stat_info()"><i class="icon-save"></i><b>Save All</b></button>
		</div>
	</div>
	<div class="control-group" style="float:right;">
		<div class="controls">
			<button id="btn_save_excl_stat_info" type="button" style="margin-right: 1px; font-size: 12px;" 
			class="btn btn-small btn-success " onclick="save_excl_stat_info()"><i class="icon-save"></i><b>Save All</b></button>
		</div>
	</div>
</div>