<?php
	//error_reporting(1);//(E_ALL);
	//ini_set('display_errors', TRUE);
	//ini_set('display_startup_errors', TRUE);
	
	require_once('../../asset/vendor/autoload.php');

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
	use PhpOffice\PhpSpreadsheet\Style\Color;
	use PhpOffice\PhpSpreadsheet\Style\Fill;
	use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
	use PhpOffice\PhpSpreadsheet\Shared\Date;

	include("../../php_crud/my_class.php");
	$obj = new my_class();

	extract($_REQUEST);
	$header_col_list = "SL,KEYWORD,$stat_col_list";
	$stat_col_list = "KEYWORD,$stat_col_list";
	/*echo "data type: $data_type<br/>District: $dist<br/>Basin: $basin<br/>M Div: $m_div<br/>
	Station List: $station_list<br/>Column List: $stat_col_list";*/
	
	$header_list = [
		"SL" => "Sl",
		"KEYWORD" => "Keyword",
		"STATION_CODE" => "Station ID",
		"STATION_NAME" => "Station Name",
		"RIVER_NAME" => "River Name",
		"BASIN" => "Basin",
		"DISTRICT" => "District",
		"UPZILA" => "Upazila",
		"MEASUREMEMT_DIVISION" => "Measurememt Division",
		"MEASUREMENT_SUB_DIVISION" => "Measurememt Sub Division",
		"LATITUDE" => "Latitude",
		"LONGITUDE" => "Longitude",
		"MOBILE_NO" => "Mobile No",
		"DANGER_LEVEL" => "Danger Level",
		"RECORDED_HIGH_WL" => "QC High WL",
		"QC_MEAN_WL" => "QC Low WL",
		"PRE_MONSOON_DL" => "Pre Monsoon DL",
		"HIGH_WL_DATE" => "Date of RHWL",
		"QC_HIGH_RF" => "QC High RF",
		"QC_LOW_RF" => "QC Low RF",
		"PHONE_NO" => "Contact Info",
		"STATION_TAGS" => "Station Tags"
	];

	$allowed_keys = explode(",", $stat_col_list);
	$allowed_keys = array_map('trim', $allowed_keys);
	$filtered = array_intersect_key($header_list, array_flip($allowed_keys));
	
	$allowed_header_keys = explode(",", $header_col_list);
	$allowed_header_keys = array_map('trim', $allowed_header_keys);
	$filtered_header = array_intersect_key($header_list, array_flip($allowed_header_keys));
	
	$formated_station_list = str_replace(",","','",$station_list);
	$cond_stat_list = "'$formated_station_list'";
	
	$file_name = "";
	$headline = "";
	$stat_type = ""; 
	if($data_type=='W'){
		$file_name = "WL_Station_List";
		$headline = "Water Level Station Information";
		$stat_type = "STATION_TYPE='1'"; 
	}
	else{
		$file_name = "RF_Station_List";
		$headline = "Rainfall Station Information";
		$stat_type = "STATION_TYPE='2'"; 
	}
	
	$where_cond .= "$stat_type AND UPPER(KEYWORD) IN ($cond_stat_list) ORDER BY KEYWORD ASC";
	$table = "FFWC.STATIONS_TBL";
	
	
	
	
	// Create spreadsheet and set data
	$spreadsheet = new Spreadsheet();
	$sheet = $spreadsheet->getActiveSheet();
	$sheet->mergeCells('A1:S1'); // Example of merging cells
	$sheet->setCellValue('A1',$headline);
	$sheet->getStyle('A1:S1')->getAlignment()->setHorizontal('center');;
	$sheet->getStyle('A1:S1')->getAlignment()->setWrapText(true);
	$sheet->getStyle('A1:S1')->getFont()->setBold(true);
	
	$sheet->mergeCells('A2:S2'); // Example of merging cells
	$sheet->setCellValue('A2',"1. Please Do Not Change the Column Names.");
	$sheet->getStyle('A2:S2')->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('A2:S2')->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 
	
	$sheet->mergeCells('A3:S3'); // Example of merging cells
	$sheet->setCellValue('A3',"2. Please give date input in DD-MON-YY format. i.e. 01-Jan-25");
	$sheet->getStyle('A3:S3')->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('A3:S3')->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED);
	
	$sheet->mergeCells('A4:S4'); // Example of merging cells
	$sheet->setCellValue('A4',"3. Please do not edit the data of the Keyword column, System will be unable to save your data if you change the keyword in excel. Please use the system panel if you want to change the keyword.");
	$sheet->getStyle('A4:S4')->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('A4:S4')->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 


	$colIndex = 0; // A = 0, B = 1, C = 2...
	foreach ($filtered_header as $key => $value) {
		// Convert column index to Excel column letter
		$columnLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($colIndex + 1);
		$cell = $columnLetter . '5';
		$sheet->setCellValue($cell, $value);
		$sheet->getStyle($cell)->getFont()->setBold(true);
		$sheet->getStyle($cell)->getAlignment()->setWrapText(true);
		$colIndex++;
	}

	$row_num = 5;
	$sl = 0;
	$stat_col_list = str_replace("HIGH_WL_DATE","TO_DATE(HIGH_WL_DATE,'DD-MON-RR') AS HIGH_WL_DATE",$stat_col_list);
	foreach ($obj->View_colmn_By_Cond($table, $stat_col_list, $where_cond) as $wl_stat_info) {
        $sl++;
		$row_num++;
		$ValcolIndex = 1;
		$sheet->setCellValue('A'.$row_num, $sl);
		foreach ($filtered as $key => $value) {
			$columnLetter = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::stringFromColumnIndex($ValcolIndex + 1);
			$cell = $columnLetter.$row_num;
			$cell_data = "";
			if($key=='HIGH_WL_DATE'){
				$dateValue = $wl_stat_info[$key];
				if (!empty($dateValue)) {
					// Use DateTime instead of strtotime to control the time part
					$dateObj = DateTime::createFromFormat('Y-m-d', $dateValue);

					if ($dateObj !== false) {
						$dateObj->setTime(0, 0, 0); // Strip the time to 00:00:00

						// Convert to Excel float value
						$excelDate = Date::PHPToExcel($dateObj);

						// Set value and format in the sheet
						$sheet->setCellValue($cell, $excelDate);
						$sheet->getStyle($cell)
							  ->getNumberFormat()
							  ->setFormatCode(NumberFormat::FORMAT_DATE_DDMMMYY); // 'dd-mmm-yy'
					} else {
						// Fallback if format doesn't match
						$sheet->setCellValueExplicit($cell, $dateValue, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
					}
				} else {
					$sheet->setCellValue($cell, '');
				}	
			}
			else{
				$sheet->setCellValue($cell,$wl_stat_info[$key]); 
			}
			
			$ValcolIndex++;
		}
	}
	
	$sheet->getStyle('B2:B'.$row_num)->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('B2:B'.$row_num)->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 
	
	$warning_row_num_1 = $row_num+1;
	$warning_row_num_2 = $row_num+2;
	$warning_row_num_3 = $row_num+3;
	
	$sheet->mergeCells('A'.$warning_row_num_1.':S'.$warning_row_num_1); // Example of merging cells
	$sheet->setCellValue('A'.$warning_row_num_1,"1. Please Do Not Change the Column Names.");
	$sheet->getStyle('A'.$warning_row_num_1.':S'.$warning_row_num_1)->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('A'.$warning_row_num_1.':S'.$warning_row_num_1)->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 
	
	$sheet->mergeCells('A'.$warning_row_num_2.':S'.$warning_row_num_2); // Example of merging cells
	$sheet->setCellValue('A'.$warning_row_num_2,"2. Please give date input in DD-MON-YY format. i.e. 01-Jan-25");
	$sheet->getStyle('A'.$warning_row_num_2.':S'.$warning_row_num_2)->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('A'.$warning_row_num_2.':S'.$warning_row_num_2)->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 
	
	$sheet->mergeCells('A'.$warning_row_num_3.':S'.$warning_row_num_3); // Example of merging cells
	$sheet->setCellValue('A'.$warning_row_num_3,"3. Please do not edit the data of the Keyword column, System will be unable to save your data if you change the keyword in excel. Please use the system panel if you want to change the keyword.");
	$sheet->getStyle('A'.$warning_row_num_3.':S'.$warning_row_num_3)->getFill()->setFillType(Fill::FILL_SOLID) ->getStartColor()->setRGB('FFFF00');
	$sheet->getStyle('A'.$warning_row_num_3.':S'.$warning_row_num_3)->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 
	

	// Redirect output to a client’s web browser (Excel)
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$file_name.'.xlsx"');
	header('Cache-Control: max-age=0');

	// If you're using IE9 or earlier
	header('Cache-Control: max-age=1');

	// Disable caching
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: cache, must-revalidate');
	header('Pragma: public');

	// Output file to browser
	$writer = new Xlsx($spreadsheet);
	$writer->save('php://output');
exit;
?>