<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
?>

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" />
<link rel="stylesheet" href="asset/theme/css/custom_design.css">

<script src="module/mobiledatalog/js/station_setup.js" type="text/javascript"></script>
<link rel="stylesheet" href="asset/ms/multiple-select.css" />
<script src="asset/ms/jquery.multiple.select.js"></script>

<style type="text/css">
	.chzn-container-single .chzn-drop .chzn-search input[type="text"] {
		background-image: none !important;
		padding-left: 5px !important; /* adjust as needed */
	}
	{
		cursor:pointer;
	}
	.alertify-notifier .ajs-message.ajs-success{
		color: #fff;
		text-shadow: -1px -1px 0 rgba(0, 0, 0, 0,5);
	}
	.form-vertical{
		padding: 10px !important;
	}

	.full-width {
		width: 95% !important;
	}
	.control-group {
		padding-left: 10px;
	}
	.padding-10{
		padding: 10px;
	}
    .overflow{
        overflow-y: visible;
    }
</style>
<style>
		/* Dropdown-style div */
.custom-dropdown {
  display: none;
  position: absolute;
  background-color: white;
  border: 1px solid #ccc;
  width: 166px;
  padding: 9px;
  box-shadow: 0 8px 16px rgba(0,0,0,0.2);
  border-radius: 8px;
  z-index: 1000;
  left: 21%;
  max-height: 250px; /* Add a maximum height */
  overflow-y: auto;  /* Enable scrolling if needed */
}

.custom-dropdown label {
  display: flex;
  align-items: center;
  gap: 8px;
  padding: 1px 1px;
  font-size: 14px;
  cursor: pointer;
  border-radius: 4px;
  transition: background-color 0.2s ease;
}

.custom-dropdown label:hover {
  background-color: #f1f1f1;
}

input[type="checkbox"] {
position: relative !important;
opacity: 100 !important;
}

.custom-dropdown label.selected {
  background-color: #e0f0ff; /* light blue background */
  font-weight: bold;
}

</style>
<div id="cover-spin"></div>
<div class="row-fluid">
	<div class="table-header">
    	Water Lavel Station Information
	<?php if($_SESSION['add']=='Y'){ ?>
		<button type ="button" href="#ffwc_modal_station" data-toggle="modal" onclick="add_station_ffwc()" id="add_station_ffwc_btn" class="btn btn-small btn-yellow" style="margin-right:10px;margin-top:3px;float:right;hover:cursor;">
		&nbsp;<i class="fa fa-plus-circle"></i> Add Station</a>
		</button>
	<?php } ?>
	</div>
	</legend>
</div>	

<div class="row-fluid" id="wl_stat_filer_holder"  style="background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black; padding-bottom:10px;">
	<table  style="width: 100%;  margin-left: 5px; margin-top: 10px;">
		<tr>
			<td style="font-weight: bold; width: 15%;">Station Tags<font color="#FF0000"></font></td>
			<td style="font-weight: bold; width: 15%;">Basin<font color="#FF0000"></font></td>
			<td style="font-weight: bold; width: 15%;">River<font color="#FF0000"></font></td>
			
			<td style="font-weight: bold; width: 10%;">Division<font color="#FF0000"></font></td>
			<td style="font-weight: bold; width: 15%;">District<font color="#FF0000"></font></td>
			<td style="font-weight: bold; width: 20%;">Table Columns<font color="#FF0000">*</font></td>
			<td style="font-weight: bold; width: 10%;"></td>
		</tr>
		<tr>
			<td>
				<select id="stat_tag" name="stat_tag" class="chosen-select-on" style="height: 15px !important;">
					<option value=""></option>
					<?php
					$tag_tbl = "FFWC.STATION_TAGS";
					$tag_cols = "ID,TAG_NAME";
					$tag_cond = "STATUS='A' ORDER BY TAG_NAME ASC";

					foreach ($obj->View_colmn_By_Cond($tag_tbl, $tag_cols, $tag_cond) as $tag_info) {
						echo '<option value="'.$tag_info['ID'].'">'.$tag_info['TAG_NAME'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="basin" name="basin" class="chosen-select-on" style="height: 15px !important;" onchange="reset_params('basin')">
					<option value=""></option>
					<?php
					$basin_tbl = '(SELECT TRIM(BASIN) AS TRIM_BASIN FROM FFWC.STATIONS_TBL ORDER BY BASIN ASC) BASIN_TBL';
					$basin_col = 'DISTINCT(TRIM_BASIN) as BASIN';
					$basin_cond = 'TRIM_BASIN IS NOT NULL ORDER BY TRIM_BASIN';

					foreach ($obj->View_colmn_By_Cond($basin_tbl, $basin_col, $basin_cond) as $basin_info) {
						echo '<option value="'.$basin_info['BASIN'].'">'.$basin_info['BASIN'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="river" name="river" class="chosen-select-on" style="height: 12px !important;" onchange="reset_params('river')">
					<option value=""></option>
					<?php
					$river_tbl = '(SELECT TRIM(RIVER_NAME) AS TRIM_RIVER FROM FFWC.STATIONS_TBL ORDER BY RIVER_NAME ASC) RIVER_TBL';
					$river_col = 'DISTINCT(TRIM_RIVER) as RIVER';
					$river_cond = 'TRIM_RIVER IS NOT NULL ORDER BY TRIM_RIVER';

					foreach ($obj->View_colmn_By_Cond($river_tbl, $river_col, $river_cond) as $river_info) {
						echo '<option value="'.$river_info['RIVER'].'">'.$river_info['RIVER'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="m_div" name="m_div" class="chosen-select-on" style="height: 15px !important;" onchange="reset_params('m_div')">
					<option value=""></option>
					<?php
					$m_div_tbl = '(SELECT TRIM(MEASUREMEMT_DIVISION) AS TRIM_M_DIV FROM FFWC.STATIONS_TBL ORDER BY MEASUREMEMT_DIVISION ASC) M_DIV_TBL';
					$m_div_col = 'DISTINCT(TRIM_M_DIV) as M_DIV';
					$m_div_cond = 'TRIM_M_DIV IS NOT NULL ORDER BY TRIM_M_DIV';

					foreach ($obj->View_colmn_By_Cond($m_div_tbl, $m_div_col, $m_div_cond) as $m_div_info) {
						echo '<option value="'.$m_div_info['M_DIV'].'">'.$m_div_info['M_DIV'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="dist" name="dist" class="chosen-select-on" style="height: 15px !important;" onchange="reset_params('dist')">
					<option value=""></option>
					<?php
					$dist_tbl = '(SELECT TRIM(DISTRICT) AS TRIM_DIST FROM FFWC.STATIONS_TBL ORDER BY DISTRICT ASC) DIST_TBL';
					$dist_col = 'DISTINCT(TRIM_DIST) AS DIST';
					$dist_cond = 'TRIM_DIST IS NOT NULL ORDER BY TRIM_DIST';

					foreach ($obj->View_colmn_By_Cond($dist_tbl, $dist_col, $dist_cond) as $dist_info) {
						echo '<option value="'.$dist_info['DIST'].'">'.$dist_info['DIST'].'</option>';
					}
					?>
				</select>
			</td>
			<td>
				<select id="wl_stat_col_list" name="wl_stat_col_list" multiple="multiple" class="multi_check">
					<option value="STATION_CODE" selected>Station ID</option>
					<option value="STATION_NAME" selected>Station Name</option>
					<option value="KEYWORD" selected>Keyword</option>
					<option value="RIVER_NAME" selected>River Name</option>
					<option value="BASIN" selected>Basin</option>
					<option value="DISTRICT" selected>District</option>
					<option value="UPZILA" selected>Upazila</option>
					<option value="MEASUREMEMT_DIVISION">Measurememt Division</option>
					<option value="MEASUREMENT_SUB_DIVISION">Measurememt Sub Division</option>
					<option value="LATITUDE">Latitude</option>
					<option value="LONGITUDE">Longitude</option>
					<option value="MOBILE_NO">Mobile No</option>
					<option value="DANGER_LEVEL">Danger Level</option>
					<option value="RECORDED_HIGH_WL">QC High WL</option>
					<option value="QC_MEAN_WL">QC Low WL</option>
					<option value="PRE_MONSOON_DL">Pre Monsoon DL</option>
					<option value="HIGH_WL_DATE">Date of RHWL</option>
					<option value="PHONE_NO">Contact Info</option>
					<option value="STATION_TAGS">Station Tags</option>
				</select>
			</td>
			<td>
				<button class="btn btn-small btn-success" type="button" onclick="load_wl_stat_info_list()">
					<i class="icon-search"></i> Search
				</button>
			</td>
		</tr>
	</table>
</div>

<div class="row-fluid" id="wl_stat_datatbl_holder" style="margin-top: 10px;"></div>



<div id="ffwc_modal_station" class="modal hide fade" style="margin-top: -35px; margin-left: -35%; width: 75%;" tabindex="-1">
	<div class="modal-header no-padding">
		<div class="table-header">
			<button type="button" class="close" data-dismiss="modal" style="opacity:1 !important"><i class="fa fa-window-close" style="font-size: 26px;font-weight: bold;color: #FFF;"></i> </button>
			Water Lavel Station Information Add Form
		</div>
	</div>
	<div class="modal-body overflow" id="add_station_ffwc" style="max-height: 80% !important; padding-bottom: 20px; overflow:visible;">
	</div>
	<div class="modal-footer">
		<div class="row-fluid">
			<button class="btn btn-small btn-success pull-right" type="button" id="btn_save" onclick="add_ffwc_wl_station()">
				<i class="fa fa-check-circle"></i>
				Save
			</button>
		</div>
	</div>								
</div>

<div id="ffwc_modal-stat-edit" class="modal hide fade" style="margin-top: -35px; margin-left: -35%; width: 75%;" tabindex="-1">
	<div class="modal-header no-padding">
		<div class="table-header">
			<button type="button" class="close" data-dismiss="modal" style="opacity:1 !important"><i class="fa fa-window-close" style="font-size: 26px;font-weight: bold;color: #FFF;"></i> </button>
			Water Lavel Station Information Edit Form
		</div>
	</div>
	<div class="modal-body overflow" id="ffwc_model_stat_edit_body" style="max-height: 80%;">
	</div>
	<div class="modal-footer">
		<div class="row-fluid">
			<button class="btn btn-small btn-success pull-right" type="button" id="btn_update" onclick="update_ffwc_wl_station()">
				<i class="icon-ok bigger-100"></i>
				Update
			</button>
		</div>
	</div>								
</div>
	
<div id="ffwc_modal-stat-view" class="modal hide fade" style="margin-top: 5%; margin-left: -30%; width: 65%;" tabindex="-1">
	<div class="modal-header no-padding">
		<div class="table-header">
			<button type="button" class="close" data-dismiss="modal" style="opacity:1 !important"><i class="fa fa-window-close" style="font-size: 26px;font-weight: bold;color: #FFF;"></i> </button>
			Water Lavel Station Information
		</div>
	</div>
	<div class="modal-body overflow" id="ffwc_model_stat_vw_body" style="max-height: 900px;">
	</div>							
</div>

<script type="text/javascript">
	$('.chosen-select-on').chosen({
		allow_single_deselect: true
	});
	//resize the chosen on window resize
	$(window)
		.off('resize.chosen')
		.on('resize.chosen', function() {
			$('.chosen-select-on').each(function() {
				var $this = $(this);
				$this.next().css({
					'width': '90%'
				});
			});
		}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if (event_name != 'sidebar_collapsed') return;
		$('.chosen-select-on').each(function() {
			var $this = $(this);
			$this.next().css({
				'width': '90%'
			});
		});
	});
	
	function reset_params(sel_param){
		// alert(sel_param);
		if(sel_param=='dist'){
			$('#basin').val('').trigger('liszt:updated');
			$('#m_div').val('').trigger('liszt:updated');
			$('#river').val('').trigger('liszt:updated');
		}
		else if(sel_param=='basin'){
			$('#dist').val('').trigger('liszt:updated');
			$('#m_div').val('').trigger('liszt:updated');
			$('#river').val('').trigger('liszt:updated');
		}
		else if(sel_param=='river'){
			$('#dist').val('').trigger('liszt:updated');
			$('#basin').val('').trigger('liszt:updated');
			$('#m_div').val('').trigger('liszt:updated');
		}
		else{
			$('#dist').val('').trigger('liszt:updated');
			$('#basin').val('').trigger('liszt:updated');
			$('#river').val('').trigger('liszt:updated');
		}
	//	load_station_list();
	}
</script>

<script type="text/javascript">
	$(function() {
        $('#wl_stat_col_list').change(function() {
            console.log($(this).val());
        }).multipleSelect({
            width: '70%'
        });
    });
</script>