<?php
ini_set('display_startup_errors', TRUE);
session_start();
include("../../asset/theme/css/myfunc.php");
include("../../php_crud/my_class.php");
$obj = new my_class();

extract($_GET);

$stat_list="";
$from_year = (int)$from_year;
$to_year = (int)$to_year;


$table_name = "SW_STATION_AUTO_MANUAL";
$columns = "STATION_ID,RIVER_NAME,DISTRICT_NAME,UPZL_NAME";
$where_cond = "RIVER_CODE='$river_id' AND ','||STATION_TYPE||','LIKE'%,'||'13'||',%' ORDER BY STATION_ID ASC";

foreach($obj->View_colmn_By_Cond($table_name,"STATION_ID",$where_cond) as $st_data){
  $stat_list .= "'".$st_data["STATION_ID"]."',";
}
$stat_list = substr($stat_list,0,-1);

if (file_exists('../../asset/custom/upload/av_morph_'.$river_id.'_'.$from_year.'_'.$to_year.'.xlsx')) {
        unlink('../../asset/custom/upload/av_morph_'.$river_id.'_'.$from_year.'_'.$to_year.'.xlsx');
}

require_once('../../asset/custom/PHPExcel_class/PHPExcel.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/Calculation.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/Cell.php');

$filename = '../../asset/custom/upload/av_morph_'.$river_id.'_'.$from_year.'_'.$to_year.'.xlsx';
try {
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setCreator("MokNathal")
                ->setLastModifiedBy("MokNathal")
                ->setTitle("STAFF REPORT")
                ->setSubject("STAFF REPORT")
                ->setDescription("STAFF REPORT")
                ->setKeywords("STAFF REPORT")
                ->setCategory("STAFF REPORT");
		$styleArray = array(
			'font'  => array(
				'bold'  => true,
				'color' => array('rgb' => 'FF0000')
			),
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

        //heading start
        $objPHPExcel->getActiveSheet()->mergeCells('A1:E7');
		$objPHPExcel->getActiveSheet()->getStyle('A1:E7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
		$objPHPExcel->setActiveSheetIndex(0)->getCell('A1')->setValue( "Bangladesh Water Development Board \n Processing and Flood Forecasting Circle\n 72-Green Road, Dhaka-1215, Bangladesh\nPhone: +88-02-58151530\nEmail   : se.pffc@bwdb.gov.bd\nWeb      :  www.hydrology.bwdb.gov.bd");
		$objPHPExcel->getActiveSheet()->getStyle('A1:E7')->getAlignment()->setWrapText(true);

        $objPHPExcel->getActiveSheet()->mergeCells('A8:E8');
        $objPHPExcel->getActiveSheet()->getStyle('A8:E8')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->setActiveSheetIndex(0)->getCell('A8')->setValue( "Morphology Availability Information");
        $objPHPExcel->getActiveSheet()->getStyle('A8:E8')->getAlignment()->setWrapText(true);

        $objPHPExcel->getActiveSheet()->mergeCells('A9:B9');
        $objPHPExcel->getActiveSheet()->getStyle('A9:B9')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "From Year: ".$from_year);
        $objPHPExcel->getActiveSheet()->getStyle('A9:B9')->getAlignment()->setWrapText(true);

        $objPHPExcel->getActiveSheet()->mergeCells('D9:E9');
        $objPHPExcel->getActiveSheet()->getStyle('D9:E9')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "To Year: ".$to_year);
        $objPHPExcel->getActiveSheet()->getStyle('D9:E9')->getAlignment()->setWrapText(true);
        //headiing end
        //$objPHPExcel->getActiveSheet()->mergeCells('A1:L1');
        $heading_row_num = 10;
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A'.$heading_row_num, 'Station id')
                ->setCellValue('B'.$heading_row_num, 'River Name')
                ->setCellValue('C'.$heading_row_num, 'Station Location')
                ->setCellValue('D'.$heading_row_num, 'Year')
                ->setCellValue('E'.$heading_row_num, 'Data Count');

        $objPHPExcel->getActiveSheet()->getStyle('A'.$heading_row_num)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('B'.$heading_row_num)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$heading_row_num)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$heading_row_num)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('E'.$heading_row_num)->getFont()->setBold(true);
       

        $objPHPExcel->getActiveSheet()->getStyle('A'.$heading_row_num)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('B'.$heading_row_num)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('C'.$heading_row_num)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$heading_row_num)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('E'.$heading_row_num)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
       

        $i = 11;
        foreach ($obj->load_morph_data_count($stat_list,$from_year,$to_year) as $morph_data_count) {
                $station_id = $morph_data_count['STATION_ID'];
                $river_name = $morph_data_count['RIVER_NAME'];
                $location = $morph_data_count['UPZL_NAME'].','.$morph_data_count['DISTRICT_NAME'];
                $year = $morph_data_count['YEAR_VAL'];
                $tot_data_num = $morph_data_count['DATA_COUNT'];
               

                $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $station_id)
                        ->setCellValue('B'.$i, $river_name)
                        ->setCellValue('C'.$i, $location)
                        ->setCellValue('D'.$i, $year)
                        ->setCellValue('E'.$i, $tot_data_num);
				if($tot_data_num==0){
					$objPHPExcel->getActiveSheet()->getStyle('E'.$i)->applyFromArray($styleArray);
				}
                $i++;
        }
        foreach (range('A1', 'E1') as $columnID) {
                $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
        }
        $objPHPExcel->getActiveSheet()->setTitle('Morphology Information');
        $objPHPExcel->setActiveSheetIndex(0);
        ob_clean();

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('../../asset/custom/upload/av_morph_'.$river_id.'_'.$from_year.'_'.$to_year.'.xlsx');
        header('Location: ../../asset/custom/upload/av_morph_'.$river_id.'_'.$from_year.'_'.$to_year.'.xlsx');
} catch (Exception $e) {
        echo 'Caught exception: ', $e->getMessage(), "\n";
}
?>