function load_stat_for_mcg(sel_riv_id) {
	$("#mcyg_graph_holder").html("");
	var datastr = "sel_riv_id="+sel_riv_id;
	//alert(datastr);
	$("#mcg_stat_list_holder").load('module/morphology/morph_station_list_by_river.php', datastr);
}

function load_morph_yearly_comp_graph_holder(){
	$("#mcyg_graph_holder").html("");
	var river = $("#mcg_river").val();
	var station = $("#morph_station").val();
	var station_arr = station.split("#");
	var station_id = station_arr[0];
	var river_name = station_arr[1];
	var district_name = station_arr[2];
	var upzl_name = station_arr[3];
	var from_year = $("#mcg_from_year").val();
	var to_year = $("#mcg_to_year").val();
	
	var datastr = "station_id="+station_id+"&river_name="+river_name+
	"&district_name="+district_name+"&upzl_name="+upzl_name+
	"&from_year="+from_year+"&to_year="+to_year;
	
	if (river==0) {
		alert('Please Select River');
		$("#mcg_river").focus();
		return false;
	}else if (!station) {
		alert('Please Select Station');
		$("#morph_station").focus();
		return false;
	}
	else if (!from_year) {
		alert('Please select From Year');
		$("#mcg_from_year").focus();
		return false;
	}
	else if (!to_year) {
		alert('Please select To Year');
		$("#mcg_to_year").focus();
		return false;
	}
	else{
		//alert(datastr);
		$("#mcyg_graph_holder").load('module/morphology/morph_yearly_com_graph_holder.php', datastr);
	}
}

function show_morph_yearly_comp_graph() {
	var river = $("#mcg_river").val();
	var station = $("#morph_station").val();
	var station_arr = station.split("#");
	var station_id = station_arr[0];
	var river_name = station_arr[1];
	var district_name = station_arr[2];
	var upzl_name = station_arr[3];
	var from_year = $("#mcg_from_year").val();
	var to_year = $("#mcg_to_year").val();
	
  
    var datastr = "station="+station_id+"&year="+from_year+"&to_year="+to_year;
	//alert(datastr);
    $.ajax({
        type: "post",
        url: "module/morphology/morphology_graph.php",
        data: datastr,
        success: function (str) {
		//	alert(str);
            if ($.trim(str)) {
                console.log(str);
                $('#cover-spin').hide();

                var data = $.parseJSON(str);

                // Destroy existing chart instance if it exists
                let chartStatus = Chart.getChart("linechart"); // <canvas> id
                if (chartStatus !== undefined) {
                    chartStatus.destroy();
                }

                // Restructure data for Chart.js
                var chartData = {
                    labels: [], // Array to store x-axis labels (distances)
                    datasets: [],
                };

                // Extract dates from the data
                var dates = Object.keys(data);

                // Iterate through the dates in the data
                for (var i = 0; i < dates.length; i++) {
                    var date = dates[i];
                    var distances = data[date].map(function (item) {
                        return item[0]; // Extracting the first value (distance)
                    });

                    // Add distances to the labels array
                    chartData.labels = distances;

                    // Extract RL values for the current date
                    var rlValues = data[date].map(function (item) {
                        return item[1]; // Extracting the second value (RL value)
                    });

                    // Add a dataset for the current date
                    chartData.datasets.push({
                        label: date,
                        data: rlValues,
                        fill: false,
                        borderColor: getRandomColor(),
                        spanGaps: true,
                        // pointRadius: 5, // Adjust the point size as needed
                        // pointHoverRadius: 7, // Adjust the point size on hover as needed
                    });
                }

                // Chart configuration
                var ctx = document.getElementById("morph_yr_comp_graph").getContext("2d");
                lineChart = new Chart(ctx, {
                    type: "line",
                    data: chartData,
                    options: {
                        scales: {
                            x: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Distance (m)', // x-axis label
                                },
                            },
                            y: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'RL (m)', // y-axis label
                                },
                            },
                        },
                        plugins: {
                            title: {
                                display: true,
                                text: ["Morphology Yearly Comparision Graph for Station: "+station_id+", River: "+river_name+", District: "+district_name+", Upazila: "+upzl_name, "From "+ from_year + " to " + to_year],
                                font: {
                                    size: 18 // Adjust the font size as needed
                                },
                            },
                            tooltip: {
                                callbacks: {
                                    title: function (tooltipItems) {
                                        // Display distance in the tooltip title
                                        var dataIndex = tooltipItems[0].dataIndex;
                                        var dateLabel = chartData.labels[dataIndex];
                                        return 'Distance: ' + dateLabel;
                                    },
                                    label: function (context) {
                                        // Display line label, date, and RL value in the tooltip body with a line break
                                        var lineLabel = chartData.datasets[context.datasetIndex].label;
                                        return [lineLabel + ', RL: ' + context.parsed.y + ' m'];
                                    },
                                },
                            },

                        },
                    },
                });

            }
        }
    });
    // Function to generate a random color for the chart line
    function getRandomColor() {
        var letters = '0123456789ABCDEF';
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }
}

//print graph strat
function download_morph_yearly_comp_graph() {
	//alert('download_morphology_graph_chart');
	var chartContainer = document.getElementById('morph_yr_comp_graph');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Morphology Graph';
			link.click();
		});
	});
}
//print graph end