function load_mph_graph() {
    // Assuming you have the necessary variables (station_id, tidal_status, year, month) defined

    // Ajax data
    // var graph_str = "station_id=" + station_id + "&tidal_status=" + tidal_status + "&year=" + year + "&month=" + month;

    // Ajax request
    $.ajax({
        type: "post",
        url: "module/morphology/test_morphology_graph.php",
        success: function (str) {
            if ($.trim(str)) {
                $('#cover-spin').hide();
                var data = $.parseJSON(str);

                // Destroy existing chart instance if it exists
                let chartStatus = Chart.getChart("linechart"); // <canvas> id
                if (chartStatus != undefined) {
                    chartStatus.destroy();
                }

                // Create chart using Chart.js
                var chartData = {
                    labels: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10"], // Values instead of dates
                    datasets: [
                        {
                            label: "01-11-23",
                            data: data['01-11-23'],
                            fill: false,
                            borderColor: 'rgba(0, 0, 255, 1)',
                            spanGaps: true,
                        },
                        {
                            label: "02-11-23",
                            data: data['02-11-23'],
                            fill: false,
                            borderColor: 'rgba(255, 0, 0, 1)',
                            spanGaps: true,
                        },
                        {
                            label: "03-11-23",
                            data: data['03-11-23'],
                            fill: false,
                            borderColor: 'rgba(0, 128, 0, 1)',
                            spanGaps: true,
                        },
                    ],
                };

                // Assuming you have the necessary variables (statName, station_id, riverName) defined
                var ctx = document.getElementById("linechart").getContext("2d");
                lineChart = new Chart(ctx, {
                    type: "line",
                    data: chartData,
                    options: {
                        scales: {
                            x: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Data Count', // x-axis label
                                },
                            },
                            y: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Morphology(mm)', // y-axis label
                                },
                            },
                        },
                        // Your other chart options here
                    },
                });
            }
        }
    });
}

//js file upload
function upload_json_data(){
    alert('upload_json_data');
        //alert('load_sms_text_data');
        var input = document.getElementById('sms_file');
        var file = input.files[0];
        alert(file);
        var formData = new FormData(); 
        formData.append('file', file, file.name);
        alert(formData);
        if(!input || !input.files || input.files.length === 0){
            alert('Please select a file.');
            return;
        }else{
        $('#cover-spin').show(0);
            $.ajax({
                type:'post' ,
                url:'module/morphology/json_file_upload.php',		
                data: formData ,
                contentType: false,
                processData: false,						 
                success:function(res){
                    $('#cover-spin').hide();
                    alert(res);	
                    //$('#ffwc_sms').html(res);
                }					
            });   
        }
    }
    





