function flush_data() {
	$("#evcyg_graph_holder").html("");
	$('#eycg_sub_div').val('').trigger('liszt:updated');
	$('#eycg_yl_sub_div').val('').trigger('liszt:updated');
	$('#ev_station').val('').trigger('liszt:updated');
	$('#ev_yl_station').val('').trigger('liszt:updated');
	$('#evcg_year_list').val('').trigger('liszt:updated');
	$('#eycg_from_year').val('');
	$('#eycg_to_year').val('');
}
function load_stat_for_eycg(sel_subdiv_id, op_type) {
	$("#evcyg_graph_holder").html("");
//	alert(op_type);
	var datastr = "sel_subdiv_id=" + sel_subdiv_id;
	if (op_type == "year_range") {
		//alert('line 16');
		$("#eycg_stat_list_holder").load('module/surface_water/evaporation_station_list_by_subdiv.php', datastr);
	}
	else{
		//alert('line 20');
		$("#eycg_yl_stat_list_holder").load('module/surface_water/evaporation_yl_station_list_by_subdiv.php', datastr);	
	}
}

function load_ev_year_list_by_station(sel_station_id){
	var datastr = "sel_station_id=" + sel_station_id;
	//alert(datastr);
	$("#cover-spin").show();
	$.ajax({
		type: "get",
		url: "module/surface_water/ev_year_list_by_station_id.php",
		data: datastr,
		success: function (str) {
		  $("#cover-spin").hide();
		  $("#evcg_year_list_holder").html(str);
		},
	});
}

function load_ev_yearly_comp_graph_holder(search_type){
	$("#evcyg_graph_holder").html("");
	if (search_type == "year_range") {
		var station_id = $("#ev_station").val();
		var from_year = $("#eycg_from_year").val();
		var to_year = $("#eycg_to_year").val();
		
		var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		
		if (!station_id) {
			alert('Please Select Station');
			$("#ev_station").focus();
			return false;
		}
		else if (!from_year) {
			alert('Please select From Year');
			$("#eycg_from_year").focus();
			return false;
		}
		else if (!to_year) {
			alert('Please select To Year');
			$("#eycg_to_year").focus();
			return false;
		}
		else{
			//alert(datastr);
			$("#evcyg_graph_holder").load('module/surface_water/evaporation_yearly_com_graph_holder.php', datastr);
		}
	}
	else{
		var station_id = $("#ev_yl_station").val();
		var year_list = $("#evcg_year_list").val();
		var datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		if (!station_id) {
			alert('Please Select Station');
			$("#ev_yl_station").focus();
			return false;
		}
		else if (!year_list) {
			alert('Please select Years');
			$("#evcg_year_list").focus();
			return false;
		}
		else{
			//alert(datastr);
			$("#evcyg_graph_holder").load('module/surface_water/evaporation_yearly_com_graph_holder.php', datastr);
		}
	}
}

function load_ev_yearly_comp_graph() {
	var search_type = $("#ev_grph_sel_search_type").val();
	var station_id = $("#ev_grph_sel_station_id").val();
	var station_name = $("#ev_grph_sel_station_name").val();
	var subdiv = $("#ev_grph_sel_subdiv").val();
	var district_name = $("#ev_grph_sel_district").val();
	var upzl_name = $("#ev_grph_sel_upz").val();
	
	var datastr = "";
	var year_for_title = "";
	if (search_type == "year_range") {
		var from_year = $("#ev_grph_sel_from_year").val();
		var to_year = $("#ev_grph_sel_to_year").val();
		datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		year_for_title = "Time Period: " + from_year + " to " + to_year;
	} else {
		var year_list = $("#ev_grph_sel_year_list").val();
		datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		year_for_title = "Years: " + year_list;
	}
//	var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year;
//	alert(datastr);
	$('#cover-spin').show();
	$.ajax({
		type: "post",
		url: "module/surface_water/evaporation_graph_year_wise.php",
		data: datastr,
		success: function (str) {
		//	alert(str);
			if ($.trim(str)) {
				//console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				// Destroy existing chart instance if it exists
				let chartStatus = Chart.getChart("ev_yr_comp_graph"); // <canvas> id
				if (chartStatus != undefined) {
					chartStatus.destroy();
				}
				// Restructure data for Chart.js
				var chartData = {
					labels: [], // Array to store x-axis labels (distances)
					datasets: [],
				};
				// Iterate through each year in the data
				for (var year in data) {
					if (data.hasOwnProperty(year)) {
						var yearlyData = data[year];

						// Extract distances from the first array (assuming all arrays have the same distances)
						if (chartData.labels.length === 0) {
							chartData.labels = yearlyData.map(function (item) {
								// Extracting only the month and date from the first value (date)
								return item[0];
							});
						}

						// Extract RL values for the current year
						var rlValues = yearlyData.map(function (item) {
							return item[1]; // Extracting the second value (RL value)
						});
						var sel_color = getRandomColor();
						// Add a dataset for the current year
						chartData.datasets.push({
							label: year,
							data: rlValues,
							fill: false,
							backgroundColor: sel_color,
							borderColor: sel_color,
							spanGaps: true,
						});
					}
				}
				//Assuming you have the necessary variables (statName, station_id, riverName) defined
				var ctx = document.getElementById("ev_yr_comp_graph").getContext("2d");
				lineChart = new Chart(ctx, {
					type: "bar",
					data: chartData,
					options: {
						scales: {
							x: {
								display: true,
								title: {
									display: true,
									text: 'Date (Month-Day)', // x-axis label
								},
							},
							y: {
								display: true,
								title: {
									display: true,
									text: 'Evaporation (mm)', // y-axis label
								},
							},
						},
						plugins: {
							title: {
								display: true,
								text: ["Evaporation Yearly Comparision Graph for Station: "+station_id+" ("+station_name+"), "+year_for_title,"Sub-Division: "+subdiv+", District: "+district_name+", Upazila: "+upzl_name],
								font: {
									size: 14, // Adjust the font size as needed
									lineHeight: 1.5
								},
								padding: {
									top: 5,
									bottom: 10
								},				
							},
						},
						// Your other chart options here
					},
				});
			}
		}
	});

	// Function to generate a random color for the chart line
	function getRandomColor() {
		var letters = '0123456789ABCDEF';
		var color = '#';

		// Generate a color
		for (var i = 0; i < 6; i++) {
			color += letters[Math.floor(Math.random() * 16)];
		}

		// Check if the color is whitish (lightness value greater than a threshold)
		if (isWhitish(color, 0.9)) {
			// If whitish, generate a different color
			var newColor = getRandomColor();

			// Return the different color
			return newColor;
		}

		// If not whitish, return the generated color
		return color;
	}

	// Function to check if a color is whitish based on its lightness value
	function isWhitish(hexColor, threshold) {
		// Convert hex to RGB
		var r = parseInt(hexColor.substring(1, 3), 16);
		var g = parseInt(hexColor.substring(3, 5), 16);
		var b = parseInt(hexColor.substring(5, 7), 16);

		// Calculate lightness value
		var lightness = (Math.max(r, g, b) + Math.min(r, g, b)) / 510;

		// Check if lightness is greater than the threshold
		return lightness > threshold;
	}
}

//print graph strat
function download_ev_yearly_comp_graph() {
	//alert('download_rainfall_chart');
	var chartContainer = document.getElementById('ev_yr_comp_graph');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Evaporation Yearly Comparison Graph';
			link.click();
		});
	});
}
//print graph end