function flush_data() {
  //	alert('flush_data');
	$("#rfcyg_graph_holder").html("");
	$('#rycg_sub_div').val('').trigger('liszt:updated');
	$('#rycg_sub_div1').val('').trigger('liszt:updated');
	$('#rf_station').val('').trigger('liszt:updated');
	$('#rf_yl_station').val('').trigger('liszt:updated');
	$('#rfcg_year_list').val('').trigger('liszt:updated');
	$('#rycg_from_year').val('');
	$('#rycg_to_year').val('');
}

function load_stat_for_rycg(sel_subdiv_id,op_type) {
	$("#rfcyg_graph_holder").html("");
	var datastr = "sel_subdiv_id=" + sel_subdiv_id + "&op_type=" + op_type;
	//alert(datastr);
	if (op_type == "year_range") {
		$("#rycg_stat_list_holder").load(
		  "module/surface_water/rf_station_list_by_sub_div.php",
		  datastr
		);
	} else {
		$("#rycg_stat_list_yl_holder").load(
		  "module/surface_water/rf_station_list_yl_by_subdiv.php",
		  datastr
		);
	}
}

function load_rf_year_list_by_station(sel_station_id){
	var datastr = "sel_station_id=" + sel_station_id;
//	alert(datastr);
	$("#cover-spin").show();
	$.ajax({
		type: "get",
		url: "module/surface_water/rf_year_list_by_station_id.php",
		data: datastr,
		success: function (str) {
			$("#cover-spin").hide();
			$("#rycg_year_list_holder").html(str);
		},
	});
}

function load_rf_yearly_comp_graph_holder(search_type){
	$("#rfcyg_graph_holder").html("");
	if (search_type == "year_range") {
		var station_id = $("#rf_station").val();
		var from_year = $("#rycg_from_year").val();
		var to_year = $("#rycg_to_year").val();
		
		var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		
		if (!station_id) {
			alert('Please Select Station');
			$("#rf_station").focus();
			return false;
		}
		else if (!from_year) {
			alert('Please select From Year');
			$("#rycg_from_year").focus();
			return false;
		}
		else if (!to_year) {
			alert('Please select To Year');
			$("#rycg_to_year").focus();
			return false;
		}
		else{
		//	alert(datastr);
			$("#rfcyg_graph_holder").load('module/surface_water/rainfall_yearly_com_graph_holder.php', datastr);
		}
	}
	else{
		var station_id = $("#rf_yl_station").val();
		var year_list = $("#rfcg_year_list").val();
		var datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		if (!station_id) {
			alert('Please Select Station');
			$("#rf_yl_station").focus();
			return false;
		}
		else if (!year_list) {
			alert('Please select From Year');
			$("#year_list").focus();
			return false;
		}
		else{
			//alert(datastr);
			$("#rfcyg_graph_holder").load('module/surface_water/rainfall_yearly_com_graph_holder.php', datastr);
		}
	}
}

function load_rf_yearly_comp_graph() {
	var station_id = $("#grph_sel_station_id").val();
	var station_name = $("#grph_sel_station_name").val();
	var subdiv = $("#grph_sel_subdiv").val();
	var district_name = $("#grph_sel_district").val();
	var upzl_name = $("#grph_sel_upz").val();
	var search_type = $("#grph_sel_search_type").val();
	

	var datastr = "";
	var year_for_title = "";
	if (search_type == "year_range") {
		var from_year = $("#grph_sel_from_year").val();
		var to_year = $("#grph_sel_to_year").val();
		datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;;
		year_for_title = "Time Period: " + from_year + " to " + to_year;
	}
	else{
		var year_list = $("#grph_sel_year_list").val();
		datastr ="station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		year_for_title = "Years: " + year_list;
	}
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({
		type: "post",
		url: "module/surface_water/rainfall_graph_year_wise.php",
		data: datastr,
		success: function (str) {
			//alert(str);
			if ($.trim(str)) {
				//console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				// Destroy existing chart instance if it exists
				let chartStatus = Chart.getChart("rf_yr_comp_graph"); // <canvas> id
				if (chartStatus != undefined) {
					chartStatus.destroy();
				}
				// Restructure data for Chart.js
				var chartData = {
					labels: [], // Array to store x-axis labels (distances)
					datasets: [],
				};
				
				// Iterate through each year in the data
				for (var year in data) {
					if (data.hasOwnProperty(year)) {
						var yearlyData = data[year];

						// Extract distances from the first array (assuming all arrays have the same distances)
						if (chartData.labels.length === 0) {
							chartData.labels = yearlyData.map(function (item) {
								// Extracting only the month and date from the first value (date)
								return item[0];
							});
						}

						// Extract RL values for the current year
						var rlValues = yearlyData.map(function (item) {
							return item[1]; // Extracting the second value (RL value)
						});
						var sel_color = getRandomColor();
						// Add a dataset for the current year
						chartData.datasets.push({
							label: year,
							data: rlValues,
							fill: false,
							backgroundColor: sel_color,
							borderColor: sel_color,
							spanGaps: true,
						});
					}
				}
				//Assuming you have the necessary variables (statName, station_id, riverName) defined
				var ctx = document.getElementById("rf_yr_comp_graph").getContext("2d");
				lineChart = new Chart(ctx, {
					type: "bar",
					data: chartData,
					options: {
						scales: {
							x: {
								display: true,
								title: {
									display: true,
									text: 'Date (Month-Day)', // x-axis label
								},
							},
							y: {
								display: true,
								title: {
									display: true,
									text: 'Rainfall (mm)', // y-axis label
								},
							},
						},
						plugins: {
							title: {
								display: true,
								text: ["Rainfall Yearly Comparision Graph for Station: "+station_id+" ("+station_name+"), "+year_for_title,"Sub-Division: "+subdiv+", District: "+district_name+", Upazila: "+upzl_name],
								font: {
									size: 14, // Adjust the font size as needed
									lineHeight: 1.5
								},
								padding: {
									top: 5,
									bottom: 10
								},				
							},
						},
						// Your other chart options here
					},
				});
			}
		}
	});

	// Function to generate a random color for the chart line
	function getRandomColor() {
		var letters = '0123456789ABCDEF';
		var color = '#';

		// Generate a color
		for (var i = 0; i < 6; i++) {
			color += letters[Math.floor(Math.random() * 16)];
		}

		// Check if the color is whitish (lightness value greater than a threshold)
		if (isWhitish(color, 0.9)) {
			// If whitish, generate a different color
			var newColor = getRandomColor();

			// Return the different color
			return newColor;
		}

		// If not whitish, return the generated color
		return color;
	}

	// Function to check if a color is whitish based on its lightness value
	function isWhitish(hexColor, threshold) {
		// Convert hex to RGB
		var r = parseInt(hexColor.substring(1, 3), 16);
		var g = parseInt(hexColor.substring(3, 5), 16);
		var b = parseInt(hexColor.substring(5, 7), 16);

		// Calculate lightness value
		var lightness = (Math.max(r, g, b) + Math.min(r, g, b)) / 510;

		// Check if lightness is greater than the threshold
		return lightness > threshold;
	}
}

//print graph strat
function download_rf_yearly_comp_graph() {
	//alert('download_rainfall_chart');
	var chartContainer = document.getElementById('rf_yr_comp_graph');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Rainfall Yearly Comparison Graph';
			link.click();
		});
	});
}
//print graph end