////-- load_river_name_by_station_id for Data Entry --////
function load_river_name_by_station_id(sel_river_id){
	var station_arr = sel_river_id.split("#");
	var station_id = station_arr[1];
	var river_code = station_arr[0];
    var datastr ="sel_river_id="+river_code+"&station_id="+station_id;
    //alert(datastr);
	$('#view_sal_data').html("");
	$('#sal_curve_chart').html("");
	$.ajax({
		url: 'module/surface_water/river_name_by_station_id.php', 
		type: 'get',
		data: datastr,
		cache: false,
		success: function(data) {
			var values = data.split("#");
            $("#river_name").val(values[0]);
            $("#station_name_holder").val(values[1]);
		}
	});
}
////-- load_river_name_by_station_id for Data Entry --////

////-- load_river_name_by_station_id for Data Upload --////
function load_river_name_by_station_id_excel(sel_river_id){
	var station_arr = sel_river_id.split("#");
	var station_id = station_arr[1];
	var river_code = station_arr[0];
    var datastr ="sel_river_id="+river_code+"&station_id="+station_id;
	//alert(datastr);
	$('#view_sal_data').html("");
	$('#sal_curve_chart').html("");
	$.ajax({
		url: 'module/surface_water/river_name_by_station_id.php', 
		type: 'get',
		data: datastr,
		cache: false,
		success: function(data) {
			var values = data.split("#");
            $("#river_name_1").val(values[0]);
            $("#station_1_name_holder").val(values[1]);
		}
	});
}
////-- load_river_name_by_station_id for Data Upload --////

////--Reload Functions--////
function flushData() {
	//alert('flush');
	$('#view_sal_data').html("");
	$('#curve_chart').html("");
	$('#station').val('');
	$('#river_name').val('');
	$('#station_1').val('');
	$('#river_name_1').val('');
	$('#from_year').val('');
	$('#to_year').val('');
	$('#station_name_holder').val('');
	$('#station_1_name_holder').val('');

	// alert($('#station').val());
	// alert($('#station_1').val());
	// alert($('#river_name').val());
	// alert($('#river_name_1').val());
}


function loadDeForm(){
	$('#view_sal_data').html("");
	$('#curve_chart').html("");
	$('#station').val('');
	$('#river_name').val('');
	$('#station_name_holder').val('');
	$('#act_tab_name').val('data_entry');
	$('.nav-tabs a[href="#sal_data_list"]').tab('show');
}

function loadExcelData(){
//	alert('loadDeForm');
	$('#view_sal_data').html("");
	$('#curve_chart').html("");
	$('#station_1').val('');
	$('#river_name_1').val('');
	$('#station_1_name_holder').val('');
	$('#act_tab_name').val('data_upload');
	$('.nav-tabs a[href="#sal_data_list"]').tab('show');
}

function load_ac_sal_man_tab(){
	var active_tab = $('.sal_data_content .tab-pane.active').attr('id');
	//alert(active_tab);
	if (active_tab == 'sal_data_list') {
	//	alert('line 71');
		load_sal_info();
	}
	else {
		//alert('line 75');
		load_sal_graph_holder();
	}
}

function load_sal_graph_holder() {
	var active_tab = $('.sal_form_tab .tab-pane.active').attr('id');
	//alert(active_tab);
	if (active_tab == 'data_upload') {
		return false;
	}
	else {
		var station = $('#station').val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];

		var river_name =  $('#river_name').val();
		var from_year =  $('#from_year').val();
		var to_year =  $('#to_year').val();
		
		var datastr = "station_id="+station_id+"&river_name="+river_name+"&from_year="+from_year+"&to_year="+to_year;
	//	alert(datastr);
		$('#sal_graph_data').load('module/surface_water/sal_graph_holder.php', datastr);
	}

}

$('#from_year').on("keypress",function(){
	$("#sal_sva_btn").css({"display":"none"});
	$('#view_sal_data').html("");
	$('#curve_chart').html("");
});
$('#to_year').on("keypress",function(){
	$("#sal_sva_btn").css({"display":"none"});
	$('#view_sal_data').html("");
	$('#curve_chart').html("");
});
////--Reload Functions--////

////-- Function For Data Display --////
// function load_sal_info(show_mode){
function load_sal_info(show_mode){
	// alert("load_sal_info");

    var station = $('#station').val();
	var station_arr = station.split("#");
	var station_id = station_arr[1];
	var river_code = station_arr[0];

	var river_name =  $('#river_name').val();
   	var from_year =  $('#from_year').val();
   	var to_year =  $('#to_year').val();
   	// var datastr = "show_mode="+show_mode+"&river_name="+river_name+"&station="+station_id+"&from_year="+from_year+"&to_year="+to_year;
   	var datastr = "river_name="+river_name+"&station="+station_id+"&from_year="+from_year+"&to_year="+to_year;
	//alert(datastr);
 	// $('#cover-spin').show(0);
    $.ajax({
		url: 'module/surface_water/salinity_info_datatable.php', 
		type: 'get',
		data: datastr,
		cache: false,
		success: function(data) {
                // alert(data);
            	// $('#cover-spin').hide();
                $("#view_sal_data").html(data);
				$('#date_1').select();
			}
	});
	
}
////-- Function For Data Display --////

/////////--Validation--/////////
function validateInput(input) {
	var regex = /(\b(on\w+)=|javascript:|(<\s*)(\/*)script)/i;
	if (input.length > 100 || regex.test(input)) {
	  return false;
	}
	return true;
}
/////////--Validation--/////////

////-- Single Save --////
function save_single_sal_info(sel_day,press_op){
	var act_tab_name = $('.sal_form_tab .tab-pane.active').attr('id');
	//var act_tab_name = $("#act_tab_name").val();
	//alert(act_tab_name);
	if(act_tab_name=='data_entry'){
		var station = $("#station").val();
		alert(station);
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		//var river_code = station_arr[0];
	}
	else{
		var station = $("#station_1").val();
		alert(station);
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		//var river_code = station_arr[0];
	}
	var station = station_id;
   // alert(station);
	var old_date = $('#old_date_'+sel_day).val();
	var in_date = $('#date_'+sel_day).val();
	var ech = $('#ech_'+sel_day).val();
	var ecl = $('#ecl_'+sel_day).val();
    var ch = $('#ch_'+sel_day).val();
	var cl = $('#cl_'+sel_day).val();
	var temp = $('#temp_'+sel_day).val();
    var orp = $('#orp_'+sel_day).val();
	var ph = $('#ph_'+sel_day).val();
	var dos = $('#dos_'+sel_day).val();
    var dom = $('#dom_'+sel_day).val();
	var sal = $('#sal_'+sel_day).val();
	var ssg = $('#ssg_'+sel_day).val();
	var tur = $('#tur_'+sel_day).val();
	var note = encodeURIComponent($.trim($('#note_'+sel_day).val()));
	var note_val = $('#note_'+sel_day).val();
	const date_bytesize = in_date.length;
	const note_bytesize = note_val.length;
	var operation = "single_save";
	if(old_date == ''){
		old_date =$('#date_'+sel_day).val();
	}else{
		old_date = $('#old_date_'+sel_day).val();
	}
	if(in_date == ""){
		alert('Please Enter Date');
	}
	else if(validateInput(in_date) == false){
		alert('Please Insert The Correct Date');
		$('#date_'+sel_day).val('');
		$('#date_'+sel_day).focus();
        return false;
	}
	else if(date_bytesize > 20){
		alert("Date Length Cannot Be More Than 20 Bytes");
		$('#date_'+sel_day).val('');
		$('#date_'+sel_day).focus();
        return false;
	}
	else if(validateInput(note_val) == false){
		alert('Please Check The Note Format');
		$('#note_'+sel_day).val('');
		$('#note_'+sel_day).focus();
        return false;
	}
	else if (note_val.match(/[$&+,:;=?[\]@#|{}'<>.^*()%!-/]/,"")){
		alert('Please Check The Note Format');
		$('#note_'+sel_day).val('');
		$('#note_'+sel_day).focus();
        return false;
	}
	else if(note_bytesize > 200){
		alert("Note Length Cannot Be More Than 200 Bytes");
		$('#note_'+sel_day).val('');
		$('#note_'+sel_day).focus();
        return false;
	}
	else{
		datastr = "old_date="+old_date+"&in_date="+in_date+"&station="+station+"&ech="+ech+"&ecl="+ecl+"&ch="+ch+"&cl="+cl+"&temp="+temp+
        "&orp="+orp+"&ph="+ph+"&dos="+dos+"&dom="+dom+"&sal="+sal+"&ssg="+ssg+
		"&tur="+tur+"&note="+note+"&operation="+operation;
	   // alert(datastr);
		$.ajax({
			url: 'module/surface_water/salinity_info_ajax.php', 
			type: 'post',
			data: datastr,
			cache: false,
			success: function(result) {
				alert(result);
				if(result==1){
					//alert('Data has been saved successfully');
					if(press_op=='btn_click'){
						alert('Data has been saved successfully');
					}
					var table = document.getElementById("sal_data_table");
					var tbodyRowCount = table.tBodies[0].rows.length;
					if(sel_day==tbodyRowCount){
						load_new_row();
						
					}
				}
				else{
					alert(result);
				}
			}
		});
	}
}
////-- Single Save --////

////-- Multi Save --////
function sal_multiple_save(){
	//alert("sal_multiple_save");
	var act_tab_name = $('.sal_form_tab .tab-pane.active').attr('id');
	if(act_tab_name=='data_entry'){
		var station = $("#station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		//var river_code = station_arr[0];
	}
	else{
		var station = $("#station_1").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		//var river_code = station_arr[0];
	}
	var station = station_id;
	//alert(station);
	var table = document.getElementById("sal_data_table");
	var tbodyRowCount = table.tBodies[0].rows.length;
	//alert(tbodyRowCount);
	$('#cover-spin').show(0);
	for(var sel_day = 1; sel_day <= tbodyRowCount; sel_day++){
		var in_date = $('#date_'+sel_day).val();
		
		var old_date = $('#old_date_'+sel_day).val();
		if(old_date == ''){
			old_date =$('#date_'+sel_day).val();
		}else{
			old_date = $('#old_date_'+sel_day).val();
		}
		var ech = $('#ech_'+sel_day).val();
		var ecl = $('#ecl_'+sel_day).val();
		var ch = $('#ch_'+sel_day).val();
		var cl = $('#cl_'+sel_day).val();
		var temp = $('#temp_'+sel_day).val();
		var orp = $('#orp_'+sel_day).val();
		var ph = $('#ph_'+sel_day).val();
		var dos = $('#dos_'+sel_day).val();
		var dom = $('#dom_'+sel_day).val();
		var sal = $('#sal_'+sel_day).val();
		var ssg = $('#ssg_'+sel_day).val();
		var tur = $('#tur_'+sel_day).val();
		var note = encodeURIComponent($.trim($('#note_'+sel_day).val()));
		var operation = "single_save";
		if(in_date != ""){
			
			datastr = "old_date="+old_date+"&in_date="+in_date+"&station="+station+"&ech="+ech+"&ecl="+ecl+"&ch="+ch+"&cl="+cl+"&temp="+temp+
			"&orp="+orp+"&ph="+ph+"&dos="+dos+"&dom="+dom+"&sal="+sal+"&ssg="+ssg+
			"&tur="+tur+"&note="+note+"&operation="+operation;
			//alert(datastr);

			$.ajax({
				url: 'module/surface_water/salinity_info_ajax.php',  
				type: 'post',
				data: datastr,
				cache: false,
				success: function(result) {
					//alert(result);
					if(result==1){
						
					}
					else{
						alert(result);
					}
				}
			});
		}
		else{
			alert("Please Insert Date");
			$('#cover-spin').hide();
			break;
		}
	}
	if(sel_day >= tbodyRowCount){
		//alert(sel_day);
		alert('Data has been saved successfully');
		$('#cover-spin').hide();
	}
}

////-- Multi Save --////

//////////--Delete--///////////
function delete_data(row_id){
	//alert("delete_data");
	var row_id = row_id;
	var date = $("#date_"+row_id).val();
	var operation = 'delete';
	var act_tab_name = $("#act_tab_name").val();
	if(act_tab_name=='data_entry'){
		var station = $("#station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		//var river_code = station_arr[0];
	}
	else{
		var station = $("#station_1").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		//var river_code = station_arr[0];
	}
	var station = station_id;

	datastr = "in_date="+date+"&station="+station+"&operation="+operation;
	//alert(datastr);
	if(confirm('Are you sure you want to delete the selected row?')){
		$.ajax({
			url: 'module/surface_water/salinity_info_ajax.php',
			type:'post',
			data:datastr,
			success:function(str){
				//alert(str);
				if(str==1){
					alert("Data has been deleted successfully"); 
				
				}else{
					alert('Fail to delete data');
				}
				load_sal_info();
			}
		});
	}
	
}

function salinity_delete_all(){
	//alert("salinity_delete_all");
	var station = $("#station").val();
	var station_arr = station.split("#");
	var station_id = station_arr[1];
	//alert(station_id);
    var table = document.getElementById("sal_data_table");
	var tbodyRowCount = table.tBodies[0].rows.length;
	//alert(tbodyRowCount);
	var sel_day = 1;
	var successfulDeletions = 0;

	if(confirm('Are you sure you want to delete all row?')){
		function delete_sal_row(sel_day) {
            if (sel_day <= tbodyRowCount) {
		var date       = $('#date_'+sel_day).val(); 
		var operation  = "delete_all";
		var datastr    = "sel_date="+date+"&station="+station_id+"&operation="+operation;
	    //alert(datastr);
		$('#cover-spin').show(0);
		$.ajax({
			url: 'module/surface_water/salinity_info_ajax.php',
			type: 'post',
			data: datastr,
			cache: false,
			success: function(result) {
				if (result == 1) {
					successfulDeletions++;
					delete_sal_row(sel_day + 1); // Continue to delete the next row
				} else {
					// Handle the case when deletion fails
				}

				// Check if all rows have been successfully deleted
				if (successfulDeletions === tbodyRowCount) {
					// All rows have been deleted, trigger the alert and reload the page
					//load_water_level_info();
					$('#cover-spin').hide();
					alert('Data has been deleted successfully');
					load_sal_info();
				}
			}
		});
	}
	}
	// Start deleting rows
	delete_sal_row(sel_day);
	}
}


function load_sal_graph(){
	var station_id = $("#grph_sel_station_id").val();
	var from_year = $("#grph_sel_from_year").val();
	var to_year = $("#grph_sel_to_year").val();
	var station_name = $("#grph_sel_stat_name").val();
	var river_name = $("#grph_sel_river_name").val();
	var sub_div_name = $("#grph_sel_sdiv_name").val();
	var dist_name = $("#grph_sel_dist_name").val();
	var upzl_name = $("#grph_sel_upzl_name").val();

	var graph_str = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year;
	var sal_title_line1 = 'Salinity Information for Station: '+station_id+'('+station_name+'), Time Period: '+from_year+' to '+to_year;
	var sal_title_line2 = 'River: '+river_name+', Upazila: '+upzl_name+', Disctrict: '+dist_name+', Sub-Division: '+sub_div_name;
//	alert(graph_str);
	$('#cover-spin').show(0);
	$.ajax({
		type:"post",
		url:"module/surface_water/salinity_graph.php",
		data:graph_str,
		success:function(str){
			//alert(str);
			if($.trim(str)){
				$('#cover-spin').hide();
				var data_list = $.parseJSON(str);
				var date_input= data_list['date'];
				//alert(date_input);
				var data_input = data_list['data'];
				//alert(data_input);
				var timeSeries =  date_input;
				var datasets = [
					{
						label: 'EC HIGHTIDE (micromho/cm)',
						data: data_input,
						//borderColor: 'rgba(255, 99, 132, 1)',
						backgroundColor: 'rgba(0, 153, 255, 1)',
						borderColor: 'rgba(0, 153, 255, 1)',
						fill: false,
					},
				];
				var data = {
					labels: timeSeries,
					datasets: datasets,
				};
				var ctx = document.getElementById('sal_curve_chart').getContext('2d');
				var lineChart = new Chart(ctx, {
					type: 'line',
					data: data,
					options: {
						scales: {
							x: {
								title: {
									    display: true,
									    text: 'Date'
									},
								},
							y: {
								display: true,
								title: {
										display: true,
										text: 'EC HIGHTIDE (micromho/cm)'
									},
								},
						},
						plugins: {
							title: {
								display: true,
								text: [sal_title_line1,sal_title_line2],
								font: {
									size: 16
								},
							},
						},
			 		},
				});
			}
		}
	});
}

function dl_sal_graph() {
//	alert('dl_sal_graph');
	var chartContainer = document.getElementById('sal_curve_chart');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		//alert('line 698');
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Salinity Graph';
			link.click();
		});
	});
}