function flush_data() {
	$("#salcyg_graph_holder").html("");
	$('#salcg_river').val('').trigger('liszt:updated');
	$('#salcg_river_sl').val('').trigger('liszt:updated');
	$('#salcg_river1').val('').trigger('liszt:updated');
	$('#sal_station').val('').trigger('liszt:updated');
	$('#sal_station_sl').val('').trigger('liszt:updated');
	$('#sal_yl_station').val('').trigger('liszt:updated');
	$('#salcg_year_list').val('').trigger('liszt:updated');
	$('#sal_year_station_range_sl').val('').trigger('liszt:updated');
	$('#salcg_from_year').val('');
	$('#salcg_to_year').val('');
	$('#salcg_from_year_sl').val('');
	$('#salcg_to_year_sl').val('');
}

function load_stat_by_river_for_salcg(sel_river_id, op_type) {
	$("#salcyg_graph_holder").html("");
	var sel_river_id = $('#salcg_river_range').val();
	var datastr = "sel_river_id="+sel_river_id+"&op_type="+op_type;
	var datastr2 = "sel_river_id="+sel_river_id+"&op_type="+op_type;
	//  alert(datastr2);
	if (op_type == "year_range") {
		$("#salcg_stat_list_holder").load(
		  "module/surface_water/sal_station_list_by_river.php",
		  datastr
		);
	}else  if(op_type == 'year_list') {
		$("#salcg_stat_list_yl_holder").load(
		  "module/surface_water/sal_station_list_yl_by_river.php",
		  datastr
		);
	}else if(op_type == 'station_year_range') {
		$("#salcg_stat_list_yl_holder_range").load(
		  "module/surface_water/sal_station_list_yl_by_river_range.php",
		  datastr2
		);
	}
	else {
		$("#salcg_stat_list_holder_sl").load(
		  "module/surface_water/sal_station_list_by_river_single.php",
		  datastr
		);
	}
}

function load_sal_year_list_by_station(sel_station_id){
	//alert('load_year_list_by_station');
	var datastr = "sel_station_id=" + sel_station_id;
	//alert(datastr);
	$("#cover-spin").show();
	$.ajax({
		type: "get",
		url: "module/surface_water/sal_year_list_by_station_id.php",
		data: datastr,
		success: function (str) {
		  $("#cover-spin").hide();
		  $("#salcg_year_list_holder").html(str);
		},
	});
}

function load_sal_year_list_by_station_range(){

    var selectedRivers = $("#sal_yl_station_range").val(); // Get selected values as an array
    if (selectedRivers.length === 0) {
        return; // No selection, so exit function
    }
    var datastr = "sel_station_id_list=" + selectedRivers;
    // alert(datastr);
	$("#cover-spin").show();
	$.ajax({
		type: "get",
		url: "module/surface_water/sal_year_list_by_station_id_range.php",
		data: datastr,
		success: function (str) {
        //   alert(str);
		  $("#cover-spin").hide();
		  $("#salcg_year_list_holder_range").html(str);
		},
	});
}
function load_stat_by_river_for_salcg() {
    var selectedValues = $("#salcg_river_range").val(); // Get selected values as an array
    if (selectedValues.length === 0) {
        return; // No selection, so exit function
    }
    var datastr = "sel_river_id_list=" + selectedValues;
    // alert(datastr);
    $("#cover-spin").show();
    
    $.ajax({
        type: "POST",
        // url: "module/surface_water/sal_year_list_by_station_id_range.php",
        url: "module/surface_water/sal_station_list_yl_by_river_range.php",
        data: datastr,
        success: function (response) {
            // alert(response);
            $("#cover-spin").hide();
            $("#salcg_stat_list_yl_holder_range").html(response);
        },
     
    });
}

function load_sal_yearly_comp_graph_holder(search_type){
	$("#salcyg_graph_holder").html("");
	if (search_type == "year_range") {
		var station_id = $("#sal_station").val();
		var from_year = $("#salcg_from_year").val();
		var to_year = $("#salcg_to_year").val();
		
		var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		
		if (!station_id) {
			alert('Please Select Station');
			$("#sal_station").focus();
			return false;
		}
		else if (!from_year) {
			alert('Please select From Year');
			$("#salcg_from_year").focus();
			return false;
		}
		else if (!to_year) {
			alert('Please select To Year');
			$("#salcg_to_year").focus();
			return false;
		}
		else{
		//	alert(datastr);
			$("#salcyg_graph_holder").load('module/surface_water/salinity_yearly_com_graph_holder.php', datastr);
		}
	}
	else if(search_type == 'year_list'){
		var station_id = $("#sal_yl_station").val();
		var year_list = $("#salcg_year_list").val();
		var datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		if (!station_id) {
			alert('Please Select Station');
			$("#sal_yl_station").focus();
			return false;
		}
		else if (!year_list) {
			alert('Please select From Year');
			$("#salcg_year_list").focus();
			return false;
		}
		else{
		//	alert(datastr);
			$("#salcyg_graph_holder").load('module/surface_water/salinity_yearly_com_graph_holder.php', datastr);
		}
	}
	else if(search_type == 'station_year_list'){
		// alert('ok');
        var salriverdata = $("#salcg_river_range").val();
        var station_id = $("#sal_yl_station_range").val();
        var year_list_range = $("#salcg_year_list_range").val();
		var datastr = "station_id="+station_id+"&year_list="+year_list_range+"&search_type="+search_type;
		if (!year_list_range) {
			alert('Please select From Year');
			$("#salcg_year_list_range").focus();
			return false;
		}
		$("#cover-spin").show();
		$.ajax({
			type: "POST",
			url: "module/surface_water/salinity_yearly_com_graph_holder_range.php",
			data: datastr,
			success: function (response) {
				// alert(response);
				$("#cover-spin").hide();
				$("#salcyg_graph_holder").html(response);
			},
		 
		});

	}

	else {
		var station_id_sl = $("#sal_station_sl").val();
		var from_year_sl = $("#salcg_from_year_sl").val();
		var to_year_sl = $("#salcg_to_year_sl").val();
		
		var datastr = "station_id="+station_id_sl+"&from_year="+from_year_sl+"&to_year="+to_year_sl+"&search_type="+search_type;
		
		if (!station_id_sl) {
			alert('Please Select Station');
			$("#sal_station_sl").focus();
			return false;
		}
		else if (!from_year_sl) {
			alert('Please select From Year');
			$("#salcg_from_year_sl").focus();
			return false;
		}
		else if (!to_year_sl) {
			alert('Please select To Year');
			$("#salcg_to_year_sl").focus();
			return false;
		}
		else{
			// alert(datastr);
			$("#salcyg_graph_holder").load('module/surface_water/salinity_yearly_com_graph_holder_single.php', datastr);
		}
	}
}

function load_sal_yearly_comp_graph(){
	var search_type = $("#sal_grph_sel_search_type").val();
	var station_id = $("#sal_grph_sel_station_id").val();
	var station_name = $("#sal_grph_sel_station_name").val();
	var river = $("#sal_grph_sel_river").val();
	var district_name = $("#sal_grph_sel_district").val();
	var upzl_name = $("#sal_grph_sel_upz").val();
	var datastr = "";
	var year_for_title = "";
	if (search_type == "year_range") {
		var from_year = $("#sal_grph_sel_from_year").val();
		var to_year = $("#sal_grph_sel_to_year").val();
		datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		year_for_title = "Time Period: " + from_year + " to " + to_year;
	} else {
		var year_list = $("#sal_grph_sel_year_list").val();
		datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		year_for_title = "Years: " + year_list;
	}
	//alert(datastr);
	//	$('#cover-spin').show();
	$.ajax({
		type: "post",
		url: "module/surface_water/salinity_graph_year_wise.php",
		data: datastr,
		success: function (str) {
			//alert(str);
			if ($.trim(str)) {
				//console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				// alert(data);
				// exit();
				// Destroy existing chart instance if it exists
				let chartStatus = Chart.getChart("sal_yr_comp_graph"); // <canvas> id
				if (chartStatus != undefined) {
					chartStatus.destroy();
				}
				// Restructure data for Chart.js
				var chartData = {
					labels: [], // Array to store x-axis labels (distances)
					datasets: [],
				};
				
				// Iterate through each year in the data
				for (var year in data) {
					if (data.hasOwnProperty(year)) {
						var yearlyData = data[year];

						// Extract distances from the first array (assuming all arrays have the same distances)
						if (chartData.labels.length === 0) {
							chartData.labels = yearlyData.map(function (item) {
								// Extracting only the month and date from the first value (date)
								return item[0];
							});
						}

						// Extract RL values for the current year
						var rlValues = yearlyData.map(function (item) {
							return item[1]; // Extracting the second value (RL value)
						});
						var sel_color = getRandomColor();
						// Add a dataset for the current year
						chartData.datasets.push({
							label: year,
							data: rlValues,
							fill: false,
							backgroundColor: sel_color,
							borderColor: sel_color,
							spanGaps: true,
						});
					}
				}
				//Assuming you have the necessary variables (statName, station_id, riverName) defined
				var ctx = document.getElementById("sal_yr_comp_graph").getContext("2d");
				lineChart = new Chart(ctx, {
					type: "line",
					data: chartData,
					options: {
						scales: {
							x: {
								display: true,
								title: {
									display: true,
									text: 'Date (Month-Day)', // x-axis label
								},
							},
							y: {
								display: true,
								title: {
									display: true,
									text: 'EC HIGHTIDE (micromho/cm)', // y-axis label
								},
							},
						},
						plugins: {
							title: {
								display: true,
								text: ["Salinity Yearly Comparision Graph for Station: "+station_id+"("+station_name+"), "+year_for_title,"District: "+district_name+", Upazila: "+upzl_name ],
								
								font: {
									size: 14, // Adjust the font size as needed
									lineHeight: 1.5
								},
								padding: {
									top: 5,
									bottom: 10
								},				
							},
						},
						// Your other chart options here
					},
				});
			}
		}
	});
	
	// Function to generate a random color for the chart line
	function getRandomColor() {
		var letters = '0123456789ABCDEF';
		var color = '#';

		// Generate a color
		for (var i = 0; i < 6; i++) {
			color += letters[Math.floor(Math.random() * 16)];
		}

		// Check if the color is whitish (lightness value greater than a threshold)
		if (isWhitish(color, 0.8)) {
			// If whitish, generate a different color
			var newColor = getRandomColor();

			// Return the different color
			return newColor;
		}

		// If not whitish, return the generated color
		return color;
	}

	// Function to check if a color is whitish based on its lightness value
	function isWhitish(hexColor, threshold) {
		// Convert hex to RGB
		var r = parseInt(hexColor.substring(1, 3), 16);
		var g = parseInt(hexColor.substring(3, 5), 16);
		var b = parseInt(hexColor.substring(5, 7), 16);

		// Calculate lightness value
		var lightness = (Math.max(r, g, b) + Math.min(r, g, b)) / 510;

		// Check if lightness is greater than the threshold
		return lightness > threshold;
	}
}

//print graph strat
function download_sal_yearly_comp_graph() {
	//alert('download_rainfall_chart');
	var chartContainer = document.getElementById('sal_yr_comp_graph');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Salinity Yearly Comparison Graph';
			link.click();
		});
	});
}
//print graph end

function load_sal_yearly_comp_graph_range(){
	var search_type = $("#sal_grph_sel_search_type_range").val();
	var station_id = $("#sal_grph_sel_station_id_range").val();
	var station_name = $("#sal_grph_sel_station_name_range").val();
	var river = $("#sal_grph_sel_river_range").val();
	var district_name = $("#sal_grph_sel_district_range").val();
	var upzl_name = $("#sal_grph_sel_upz_range").val();
	var year_list = $("#sal_grph_sel_year_list_range").val();
	var datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
	var year_for_title = "Years: " + year_list;

	
	// alert(year_for_title);
	$.ajax({
		type: "post",
		url: "module/surface_water/salinity_graph_year_station_wise_range.php",
		data: datastr,
		success: function (str) {
			// alert(str);
			if ($.trim(str)) {
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				// Destroy existing chart instance if it exists
				let chartStatus = Chart.getChart("sal_yr_comp_graph_range"); // <canvas> id
				if (chartStatus != undefined) {
					chartStatus.destroy();
				}

				// Prepare data for Chart.js
				var chartData = {
					labels: [], // To store unique station names
					datasets: [],
				};

				// Get unique station names for labels
				const allStations = new Set();
				for (const year in data) {
					if (data.hasOwnProperty(year)) {
						data[year].forEach(item => {
							allStations.add(item[2]);
						});
					}
				}
				chartData.labels = Array.from(allStations);

				// Iterate through each year to create a dataset
				for (var year in data) {
					if (data.hasOwnProperty(year)) {
						var yearlyData = data[year];
						var dataPoints = [];
						var sel_color = getRandomColorupdate(); // Function to get a random color for each dataset

						yearlyData.forEach(item => {
							dataPoints.push({
								x: item[2], // Station ID as x-value
								y: parseFloat(item[1]),
								date: item[0],
								rawValue: item[1],
								station: item[2] // Keep station info
							});
						});

						// Filter dataPoints to only include stations present in chartData.labels
						const filteredDataPoints = dataPoints.filter(dp => chartData.labels.includes(dp.x));

						// Sort data points by station ID and then by date for proper line connection
						filteredDataPoints.sort((a, b) => {
							if (a.x === b.x) {
								return new Date(a.date) - new Date(b.date);
							}
							return chartData.labels.indexOf(a.x) - chartData.labels.indexOf(b.x);
						});

						// Add a dataset for the current year
						chartData.datasets.push({
							label: year,
							data: filteredDataPoints,
							fill: false,
							backgroundColor: sel_color,
							borderColor: sel_color,
							spanGaps: false,
							type: 'line', // Explicitly set type to line
							pointRadius: 5, // Add point radius for better visibility
						});
					}
				}

				// Create the line chart
				var ctx = document.getElementById("sal_yr_comp_graph_range").getContext("2d");
				var lineChart = new Chart(ctx, {
					type: "line",
					data: chartData,
					options: {
						scales: {
							x: {
								type: 'category', // Ensure x-axis is treated as categories (station names)
								display: true,
								title: {
									display: true,
									text: 'Station Name', // x-axis label
								},
								ticks: {
									autoSkip: false, // Ensure all labels are shown
								}
							},
							y: {
								display: true,
								title: {
									display: true,
									text: 'EC HIGHTIDE (micromho/cm)', // y-axis label
								},
							},
						},
						plugins: {
							title: {
								display: true,
								text: ["Salinity Yearly Comparison Graph for River: " + river + ", " + year_for_title],
								font: {
									size: 14, // Adjust font size as needed
									lineHeight: 1.5
								},
								padding: {
									top: 5,
									bottom: 10
								},
							},
							tooltip: {
								callbacks: {
									label: function(context) {
										const dataPoint = context.dataset.data[context.dataIndex];
										return `${dataPoint.date}: ${dataPoint.rawValue}`;
									}
								}
							}
						},
						// Additional chart options can go here
					},
				});
			}//end of graph
		}
	});
	
	
	
	// Function to generate a random color for the chart line
	function getRandomColorupdate() {
		var letters = '0123456789ABCDEF';
		var color = '#';

		// Generate a color
		for (var i = 0; i < 6; i++) {
			color += letters[Math.floor(Math.random() * 16)];
		}

		// Check if the color is whitish (lightness value greater than a threshold)
		if (isWhitishupdate(color, 0.8)) {
			// If whitish, generate a different color
			var newColor = getRandomColorupdate();

			// Return the different color
			return newColor;
		}

		// If not whitish, return the generated color
		return color;
	}

	// Function to check if a color is whitish based on its lightness value
	function isWhitishupdate(hexColor, threshold) {
		// Convert hex to RGB
		var r = parseInt(hexColor.substring(1, 3), 16);
		var g = parseInt(hexColor.substring(3, 5), 16);
		var b = parseInt(hexColor.substring(5, 7), 16);

		// Calculate lightness value
		var lightness = (Math.max(r, g, b) + Math.min(r, g, b)) / 510;

		// Check if lightness is greater than the threshold
		return lightness > threshold;
	}
	
}

function download_sal_yearly_comp_graph_range(){
	//alert('download_rainfall_chart');
	var chartContainer = document.getElementById('sal_yr_comp_graph_range');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Salinity Yearly Comparison Graph';
			link.click();
		});
	});
}

///year range single line data///
function load_sal_yearly_comp_graph_sl(){
	var station_id = $("#sal_grph_sel_station_id").val();
	var station_name = $("#sal_grph_sel_station_name").val();
	var river = $("#sal_grph_sel_river").val();
	var district_name = $("#sal_grph_sel_district").val();
	var upzl_name = $("#sal_grph_sel_upz").val();
    var from_year = $("#sal_grph_sel_from_year").val();
    var to_year = $("#sal_grph_sel_to_year").val();
	
	var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year;
	// alert(datastr);
	
	$("#cover-spin").show();
	$.ajax({
		type: "post",
		url: "module/surface_water/salinity_graph_year_wise_single.php",
		data: datastr,
		success: function (str) {
			// alert(str);
			// console.log(str)
			if ($.trim(str)) {
				console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				
								
				var labeldata = [];

				var chrtdata = [];
				
				
				for(var i =0; i < data.length; i++){
					  labeldata.push(data[i][0]);
					  chrtdata.push(data[i][1]);
				}
				var ctx = document.getElementById("sal_yr_comp_graph").getContext("2d");
				var myChart = new Chart(ctx, {
				  type: 'line',
				  data: {
					labels: labeldata,
					datasets: [{
						label: 'EC HIGHTIDE (micromho/cm)',
						data: chrtdata,
						backgroundColor: "rgba(51, 204, 255,0.6)",
						borderColor:"rgba(51, 204, 255,0.6)",
					}]
				  },
				  options: {
					   scales: {
					  x: {
						display: true,
						title: {
						  display: true,
						  text: 'Date-Time' // x-axis label
						}
					  },
					  y: {
						display: true,
						title: {
						  display: true,
						  text: 'EC HIGHTIDE (micromho/cm)' // y-axis label
						}
					  }
					},
					 plugins: {
						title: {
                display: true,
                text: [
                  "Salinity Yearly Comparison Graph for Station: " +
                  station_id +
                  "(" +
                  station_name +
                  "), " +
                  from_year+'-'+to_year,
                  " River: " +
                  river +
                  ", District: " +
                  district_name +
                  ", Upazila: " +
                  upzl_name,
                ],
                font: {
                  size: 14, // Adjust the font size as needed
                  lineHeight: 1.5,
                },
                padding: {
                  top: 5,
                  bottom: 10,
                },
              },
            },  
				  }
				});
			}
		}
	});
}
///year range single line data///