<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
?>
<script src="module/surface_water/js/obs_sediment_yearly_comp_graph.js" type="text/javascript"></script>


<div id="cover-spin"></div>

<div class="table-header"><i class="fas fa-th-list"></i> Observed Sediment Discharge Yearly Comparison Graph </div>
<div class="row-fluid" style="margin-top: -4px;">
	<div class="widget-header widget-header-large">
		<div class="widget-toolbar no-border">
			<ul class="nav nav-tabs" id="myTab">
				<li class="active">
					<a data-toggle="tab" href="#os_year_range" onclick="flush_data()">Search by Year Range</a>
				</li>
				<li>
					<a data-toggle="tab" href="#os_year_list" onclick="flush_data()">Search by Selected Years</a>
				</li>
				<li>
					<a data-toggle="tab" href="#os_year_range_sl" onclick="flush_data()">Search by Year Range (Single-Line Graph)</a>
				</li>
			</ul>  
		</div>
	</div>
</div>

<div class="row-fluid" style="padding-top: 5px; padding-bottom: 10px; margin-top: -4px; background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black;">
	<div class="widget-body" style="border: none;  background-color: #f5f5f5;">
		<div class="widget-main padding-5">
			<div class="tab-content" style="overflow: visible; position: sticky; z-index: 999;">
				<div id="os_year_range" class="tab-pane in active">
					<div class="span3" style="padding-left: 5px;">
						<div class="control-group">
							<label class="control-label" for="river"><b>River <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%">
							  <select id="oscg_river" name="oscg_river" style="height: 12px !important;" class="chosen-select" onchange="load_stat_for_oscg(this.value,'year_range')"> 
								<option value="0" selected="selected"></option>
									<?php
									$table_name = 'HYDROLOGY.RIVER_INFO@HYDRO10';
									$columns = 'RIVER_CODE,RIVER_NAME';
									$where_cond = '1=1 ORDER BY RIVER_NAME ASC';

									foreach($obj->View_colmn_By_Cond($table_name,$columns,$where_cond) as $river_list){
									  echo '<option value="'.$river_list['RIVER_CODE'].'">'.$river_list['RIVER_NAME'].'</option>';
									}
									?>
							  </select>
							</div>
						</div>
					</div>
					<div class="span3">
						<div class="control-group">
							<label class="control-label" for="station"><b>Station <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%" id="oscg_stat_list_holder">
							  <select id="oscg_stat_dummy" style="height: 12px !important;" name="oscg_stat_dummy" class="chosen-select">
								<option value=""></option>
							  </select>

							</div>
						</div>
					</div>

					<!--From Year Field Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="year"><b>From Year<font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%;">
								<input type="text" style="width: 97%; height: 15px !important;" id="oscg_from_year" name="oscg_from_year" value="" maxlength="4"/>
							</div>
						</div>
					</div>
					<!--From Year Field Ends-->
					<!--To Year Field Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="year"><b>To Year<font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%;">
								<input type="text" style="width: 97%; height: 15px !important;" id="oscg_to_year" name="oscg_to_year" value="" maxlength="4"/>
							</div>
						</div>
					</div>
					<!--To Year Field Ends-->
					<div class="span2" style="margin-top: 22px;">
						<div class="control-group">
							<div class="controls">
								<button type ="button" onclick="load_os_yearly_comp_graph_holder('year_range')" id="os_find_btn" class="btn btn-minier btn-info" style="padding: 4px !important;">
									<i class="icon-search"></i> <b style="font-size: 12px;">Show Graph</b>
								</button>
							</div>
						</div>
					</div>
				</div>
				<div id="os_year_list" class="tab-pane">
					<div class="span3" style="padding-left: 5px;">
						<div class="control-group">
							<label class="control-label" for="river"><b>River <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%">
							    <select id="oscg_yl_river" name="oscg_yl_river" style="height: 12px !important;" class="chosen-select" onchange="load_stat_for_oscg(this.value,'year_list')"> 
								<option value="0" selected="selected"></option>
									<?php
									$table_name = 'HYDROLOGY.RIVER_INFO@HYDRO10';
									$columns = 'RIVER_CODE,RIVER_NAME';
									$where_cond = '1=1 ORDER BY RIVER_NAME ASC';

									foreach($obj->View_colmn_By_Cond($table_name,$columns,$where_cond) as $river_list){
									  echo '<option value="'.$river_list['RIVER_CODE'].'">'.$river_list['RIVER_NAME'].'</option>';
									}
									?>
							  </select>
							</div>
						</div>
					</div>
					<div class="span3">
						<div class="control-group">
							<label class="control-label" for="station"><b>Station <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%" id="oscg_stat_list_yl_holder">
							  <select id="oscg_stat_dummy" style="height: 12px !important;" name="oscg_stat_dummy" class="chosen-select">
								<option value=""></option>
							  </select>
							</div>
						</div>
					</div>

					<!--From Year Field Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="year"><b>Year List <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%;" id="oscg_year_list_holder">
								<select id="oscg_yl_dummy" style="height: 12px !important;" name="oscg_yl_dummy" class="chosen-select">
									<option value=""></option>
								</select>
							</div>
						</div>
					</div>
					<!--From Year Field Ends-->
					<div class="span2" style="margin-top: 22px;">
						<div class="control-group">
							<div class="controls">
								<button type ="button" onclick="load_os_yearly_comp_graph_holder('year_list')" id="od_find_btn" class="btn btn-minier btn-info" style="padding: 4px !important;">
									<i class="icon-search"></i> <b style="font-size: 12px;">Show Graph</b>
								</button>
							</div>
						</div>
					</div>
				</div>
				<div id="os_year_range_sl" class="tab-pane">
					<div class="span3" style="padding-left: 5px;">
						<div class="control-group">
							<label class="control-label" for="river"><b>River <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%">
							  <select id="oscg_river_yl" name="oscg_river_yl" style="height: 12px !important;" class="chosen-select" onchange="load_stat_for_oscg(this.value,'year_range_sl')"> 
								<option value="0" selected="selected"></option>
									<?php
									$table_name = 'HYDROLOGY.RIVER_INFO@HYDRO10';
									$columns = 'RIVER_CODE,RIVER_NAME';
									$where_cond = '1=1 ORDER BY RIVER_NAME ASC';

									foreach($obj->View_colmn_By_Cond($table_name,$columns,$where_cond) as $river_list){
									  echo '<option value="'.$river_list['RIVER_CODE'].'">'.$river_list['RIVER_NAME'].'</option>';
									}
									?>
							  </select>
							</div>
						</div>
					</div>
					<div class="span3">
						<div class="control-group">
							<label class="control-label" for="station"><b>Station <font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%" id="oscg_stat_list_holder_sl">
							  <select id="oscg_stat_dummy" style="height: 12px !important;" name="oscg_stat_dummy" class="chosen-select">
								<option value=""></option>
							  </select>

							</div>
						</div>
					</div>

					<!--From Year Field Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="year"><b>From Year<font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%;">
								<input type="text" style="width: 97%; height: 15px !important;" id="oscg_from_year_sl" name="oscg_from_year_sl" value="" maxlength="4"/>
							</div>
						</div>
					</div>
					<!--From Year Field Ends-->
					<!--To Year Field Starts-->
					<div class="span2">
						<div class="control-group">
							<label class="control-label" for="year"><b>To Year<font color="#FF0000">*</font></b></label>
							<div class="controls" style="width: 100%;">
								<input type="text" style="width: 97%; height: 15px !important;" id="oscg_to_year_sl" name="oscg_to_year_sl" value="" maxlength="4"/>
							</div>
						</div>
					</div>
					<!--To Year Field Ends-->
					<div class="span2" style="margin-top: 22px;">
						<div class="control-group">
							<div class="controls">
								<button type ="button" onclick="load_os_yearly_comp_graph_holder('year_range_sl')" id="os_find_btn" class="btn btn-minier btn-info" style="padding: 4px !important;">
									<i class="icon-search"></i> <b style="font-size: 12px;">Show Graph</b>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row-fluid" id="oscyg_graph_holder"></div>

<script>
    $('.chosen-select').chosen({
		allow_single_deselect:true,
		search_contains: true
	}); 
	//resize the chosen on window resize
	$(window)
	.off('resize.chosen')
	.on('resize.chosen', function() {
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width': '100%'});
		})
	}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if(event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function() {
			 var $this = $(this);
			 $this.next().css({'width':'100%'});
		})
	});
</script>