function load_coastal_device_info(){
	//alert('load_coastal_device_info');
	$("#coast_station_list").load("module/surface_water_auto/coastal_station_list.php");
}

function set_coast_stat_info(sel_stat_id,sel_stat_name){
	var sel_stat_info = sel_stat_id+" ("+sel_stat_name+")";
//	alert(sel_stat_info);
	$("#station_id_holder").val(sel_stat_info);
	$("#station_id").val(sel_stat_id);
	$('#modal_coast_station').modal('hide');
	$('#coast_graph_data').html("");
	$('#view_coast_data_table').html("");
}

function load_coastal_data(){
	var active_tab = $('.tab-content .tab-pane.active').attr('id');
	if(active_tab=='view_coast_data_table'){
		$('#coast_graph_data').html("");
		show_coast_data();
	}
	else{
		$('#view_coast_data_table').html("");
		load_coast_graph_holder();

	}
}

function show_coast_data(){
	//alert('show_coast_data');
	$('#coast_graph_data').html("");
	var station_info = $("#station_id_holder").val();
	var station_id = $("#station_id").val();
	var c_data_type = $('#c_data_type').val();
	var from_date = $("#from_date").val();
	var to_date = $("#to_date").val();
	
	if(station_info==""){
		alert('Please select Station');
		$("#station_id_holder").focus();
	}
	else if(c_data_type==""){
		alert('Please select Data Type');
		$("#c_data_type").focus();
	}else if(from_date==""){
		alert('Please mention From Date');
		$("#from_date").focus();
	}else if(to_date==""){
		alert('Please select To_date');
		$("#to_date").focus();
	}
	else{
		var datastr = "station_id="+station_id+"&c_data_type="+c_data_type+"&from_date="+from_date+"&to_date="+to_date;
		//alert(datastr);
		$('#cover-spin').show(0);
		$.ajax({
			url: 'module/surface_water_auto/coastal_data_report.php', 
			type: 'post',
			data: datastr,
			cache: false,
			success: function(data) {
			   $("#view_coast_data_table").html(data);
			   $('#cover-spin').hide();
			}
		}); 
	}	
}

function load_coast_graph_holder(){
	//alert('load_coast_graph_holder');
	$('#view_coast_data_table').html("");
	var station_info = $("#station_id_holder").val();
	var station_id = $("#station_id").val();
	var c_data_type = $('#c_data_type').val();
	var from_date = $("#from_date").val();
	var to_date = $("#to_date").val();
	
	if(station_info==""){
		alert('Please select Station');
		$("#station_id_holder").focus();
	}
	else if(c_data_type==""){
		alert('Please select Data Type');
		$("#c_data_type").focus();
	}else if(from_date==""){
		alert('Please mention From Date');
		$("#from_date").focus();
	}else if(to_date==""){
		alert('Please select To_date');
		$("#to_date").focus();
	}
	else{
		var datastr = "station_id="+station_id+"&c_data_type="+c_data_type+"&from_date="+from_date+"&to_date="+to_date;
		$('#coast_graph_data').load('module/surface_water_auto/coast_data_graph_holder.php',datastr);
	}
}

function show_coast_data_graph(){
	var station_id = $("#grph_sel_station_id").val();
	var station_name = $("#grph_sel_station_name").val();
	var station_dist = $("#grph_sel_station_dist").val();
	var station_upz = $("#grph_sel_station_upz").val();
	var from_date = $("#grph_sel_from_date").val();
	var to_date = $("#grph_sel_to_date").val();
	var data_type_id = $("#grph_sel_data_type_id").val();
	var data_type = $("#grph_sel_data_type").val();
	var mu_name = $("#grph_sel_mu_name").val();
	
	var graph_str = "station_id="+station_id+"&data_type_id="+data_type_id+"&from_date="+from_date+"&to_date="+to_date;
	var coast_grph_title_line1 = data_type+' Information for Station: '+station_id+' ('+station_name+'), Time Period: '+from_date+' to '+to_date;
	var coast_grph_title_line2 = 'District: '+station_dist+', Upazila: '+station_upz;
	var graph_label_name = data_type+' ('+mu_name+')';
	//alert(graph_str);
	//alert(coast_grph_title_line1);
	$('#cover-spin').show(0);
	$.ajax({
		type:"post",
		url:"module/surface_water_auto/coast_data_graph.php",
		data:graph_str,
		success:function(str){
			//alert(str);
			if($.trim(str)){
				$('#cover-spin').hide();
				var data_list = $.parseJSON(str);
				var date_input= data_list['date'];
				//alert(date_input);
				var data_input = data_list['data'];
				//alert(data_input);
				var timeSeries =  date_input;
				var datasets = [
					{
						label: graph_label_name,
						data: data_input,
						//borderColor: 'rgba(255, 99, 132, 1)',
						backgroundColor: 'rgba(0, 153, 255, 1)',
						borderColor: 'rgba(0, 153, 255, 1)',
						fill: false,
					},
				];
				var data = {
					labels: timeSeries,
					datasets: datasets,
				};
				var ctx = document.getElementById('coast_data_line_chart').getContext('2d');
				var lineChart = new Chart(ctx, {
					type: 'line',
					data: data,
					options: {
						scales: {
							x: {
								title: {
									    display: true,
									    text: 'Date'
									},
								},
							y: {
								display: true,
								title: {
										display: true,
										text: ''+graph_label_name+''
									},
								},
						},
						plugins: {
							title: {
								display: true,
								text: [coast_grph_title_line1,coast_grph_title_line2],
							//	text: coast_grph_title_line1,
								font: {
									size: 16
								},
							},
						},
			 		},
				});
			}
		}
	});
}

function download_coast_data_graph_chart() {
//	alert('dl_sal_graph');
	var chartContainer = document.getElementById('coast_data_line_chart');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		//alert('line 698');
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Coastal Station Information Graph';
			link.click();
		});
	});
}