function load_sw_form(){
	$("#sw_water_form_data").load("module/surface_water_auto/sw_form.php");
}

function load_hsub_div_by_hdiv(sel_hdiv_id){
	var datastr = "sel_hdiv_id="+sel_hdiv_id;
	//alert(sel_hdiv_id);
	$("#sws_sub_divs_holder").load("module/surface_water_auto/hydro_sub_div_list_by_hdiv.php",datastr);
}
function load_summary_hsub_div_by_hdiv(sel_hdiv_id){
	var datastr = "sel_hdiv_id="+sel_hdiv_id;
	$("#sws_sub_divs_holder_summary").load("module/surface_water_auto/hydro_sub_div_list_by_hdiv_sum.php",datastr);
}
function enable_days_input(sel_status_num){
	if(sel_status_num==5){
		$("#inactive_days_holder").show();
	}
	else{
		$("#inactive_days_holder").hide();
		$("#inactive_days").val("3");
	}
}
function enable_days_input_summary(sel_status_num){
	if(sel_status_num==5){
		$("#inactive_days_holder_summary").show();
	}
	else{
		$("#inactive_days_holder_summary").hide();
		$("#inactive_days_summary").val("3");
	}
}

function load_sw_summerry_form(){
	$('#sw_datatable').html("");
	// $('#sw_summery_data').load('module/surface_water_auto/sw_summery_form.php');
}
function load_sw_details_form(){
	$('#sw_datatable_summery').html("");
}

function load_station_status_details(){
	var station_type = $("#sw_status_stat_type").val();
	var hydro_div = $("#sw_status_div").val();
	var hydro_sub_div = $("#sw_status_sub_div").val();
	var district = $("#sw_status_dist").val();
	var sw_status = $("#sw_status").val();
	
	if(!station_type){
		alert("Please select a station type.");
		$("#sw_status_stat_type").next().find("input").focus();
		return false;
	}
	else{
		var datastr = "station_type="+station_type+"&hydro_div="+hydro_div+"&hydro_sub_div="+hydro_sub_div+
		"&district="+district+"&sw_status="+sw_status;
		if(sw_status==5){
			var inactive_days = $("#inactive_days").val();
			datastr = datastr+"&inactive_days="+inactive_days;
		}
	//	alert(datastr);
		$('#cover-spin').show();
		$.ajax({
			 url: 'module/surface_water_auto/sw_datatable.php',
			type: 'post',
			data: datastr,
			cache: false,
			success: function (result) {
				//alert(result);
				$('#cover-spin').hide();
				$("#sw_datatable").html(result);
			}
		});
	}
}

function print_station_status_details(){
	
	var station_type = $("#sw_status_stat_type").val();
	var hydro_div = $("#sw_status_div").val();
	var hydro_sub_div = $("#sw_status_sub_div").val();
	var district = $("#sw_status_dist").val();
	var sw_status = $("#sw_status").val();
	if(!station_type){
		alert("Please select a station type.");
		$("#sw_status_stat_type").next().find("input").focus();
		return false;
	}
	else{
		var datastr = "station_type="+station_type+"&hydro_div="+hydro_div+"&hydro_sub_div="+hydro_sub_div+
		"&district="+district+"&sw_status="+sw_status;
		if(sw_status==5){
			var inactive_days = $("#inactive_days").val();
			datastr = datastr+"&inactive_days="+inactive_days;
		}
		window.open("module/surface_water_auto/sw_station_status_details_print.php?"+ datastr);

	}
}

function download_station_status_details(){
	var station_type = $("#sw_status_stat_type").val();
	var hydro_div = $("#sw_status_div").val();
	var hydro_sub_div = $("#sw_status_sub_div").val();
	var district = $("#sw_status_dist").val();
	var sw_status = $("#sw_status").val();
	if(!station_type){
		alert("Please select a station type.");
		$("#sw_status_stat_type").next().find("input").focus();
		return false;
	}
	else{
		var datastr = "station_type="+station_type+"&hydro_div="+hydro_div+"&hydro_sub_div="+hydro_sub_div+
		"&district="+district+"&sw_status="+sw_status;
		if(sw_status==5){
			var inactive_days = $("#inactive_days").val();
			datastr = datastr+"&inactive_days="+inactive_days;
		}
		window.open("module/surface_water_auto/sw_station_status_details_excel.php?"+ datastr);

	}
}

function load_station_status_summary(){
	var station_type = $("#sw_status_stat_type_summary").val();
	var hydro_div = $("#sw_status_div_summary").val();
	var hydro_sub_div = $("#sw_status_sub_div_summary").val();
	// var district = $("#sw_status_dist").val();
	var sw_status = $("#sw_status_summary").val();

	if(!station_type){
		alert("Please select a station type.");
		$("#sw_status_stat_type_summary").next().find("input").focus();
		return false;
	}
	else{
		var datastr = "station_type="+station_type+"&hydro_div="+hydro_div+"&hydro_sub_div="+hydro_sub_div+"&sw_status="+sw_status;
		if(sw_status==5){
			var inactive_days = $("#inactive_days_summary").val();
			datastr = datastr+"&inactive_days="+inactive_days;
		}
	//	alert(datastr);
		$('#cover-spin').show();
		$.ajax({
			url: 'module/surface_water_auto/sw_datatable_summary.php',
			type: 'post',
			data: datastr,
			cache: false,
			success: function (result) {
			//	alert(result);
				$('#cover-spin').hide();
				$("#sw_datatable_summery").html(result);
			}
		});
	}
}

function print_station_status_summary(){
	// alert('summary print');
	var station_type = $("#sw_status_stat_type_summary").val();
	var hydro_div = $("#sw_status_div_summary").val();
	var hydro_sub_div = $("#sw_status_sub_div_summary").val();
	// var district = $("#sw_status_dist").val();
	var sw_status = $("#sw_status_summary").val();

	if(!station_type){
		alert("Please select a station type.");
		$("#sw_status_stat_type_summary").next().find("input").focus();
		return false;
	}
	else{
		var datastr = "station_type="+station_type+"&hydro_div="+hydro_div+"&hydro_sub_div="+hydro_sub_div+"&sw_status="+sw_status;
		if(sw_status==5){
			var inactive_days = $("#inactive_days_summary").val();
			datastr = datastr+"&inactive_days="+inactive_days;
		}
		window.open("module/surface_water_auto/sw_station_status_summary_print.php?"+ datastr);
		
	}
}

function show_graph(station_id,to_date){
	$("#graph").show();
	$("#graphLabel").show();
	$("#sw_graph_datatable").show();
	$("#sw_datatable").hide();
	$("#sw_water_form_data").hide();
	$("#graphLabel").html(
    "Surface Water Level Hydro Graph for Station " + 
    station_id + 
    "<button onclick='back_button()' class='btn btn-small btn-warning' style='float: right; margin-left: 10px; padding: 3px 10px;' >" + 
    "<i class='fas fa-arrow-left'></i> Back</button>"
);

	// $("#graphLabel").html("Station");

	var dataA = "station_id="+station_id+"&to_date="+to_date;
	//alert (dataA);
	$('#cover-spin').show(0);

	$.ajax({
		type:"post",
		url:"module/surface_water_auto/surface_water_availability_hourly_graph.php",
		data: dataA,
		success:function(str){
			$('#cover-spin').hide();
			
			var data_list_asw = $.parseJSON(str);
		
			var date_input_asw = data_list_asw['date'];
			
			var data_input_asw = data_list_asw['data'];
			
			var timeSeries =  date_input_asw;
			
			// Define individual datasets for each station
			var datasets = [
				{
					label: 'Water Level (m)',
			 		data: data_input_asw,
			 		//borderColor: 'rgba(255, 99, 132, 1)',
			 		backgroundColor: 'rgba(0, 153, 255, 1)',
			 		borderColor: 'rgba(0, 153, 255, 1)',
			 		fill: false,
			 	},
			];

			var data = {
			 	labels: timeSeries,
			 	datasets: datasets,
			};

			var ctx = document.getElementById('lineChart').getContext('2d');
			var lineChart = new Chart(ctx, {
			type: 'line',
			data: data,
			options: {
			 		scales: {
			 				x: [{
			 					type: 'time',
			 					time: {
			 						unit: 'hour',
			 						displayFormats: {
			 							hour: 'MMM D, HH:mm',
			 						},
			 					},
			 					scaleLabel: {
			 						display: true,
			 						labelString: 'Date',
			 					},
			 					title: {
			 					  display: true,
			 					  text: 'Date-Time'
			 					},
			 				},],
			 				y: {
			 					scaleLabel: {
			 						display: true,
			 						labelString: 'Value',
			 					},
			 				},
			 			},
			 		},
			 		plugins: {
			 			title: {
			 				display: true,
			 				text: 'Multi-Line Chart with Common Time Series',
			 			},
			 		},
	
			});
		}
	});
	$("#sw_graph_datatable").load("module/surface_water_auto/sw_graph_data_table.php",dataA);
}

function show_rf_graph(station_id,to_date){
	$("#graph").show();
	$("#graphLabel").show();
	$("#sw_graph_datatable").show();
	$("#sw_datatable").hide();
	$("#sw_water_form_data").hide();
	$("#graphLabel").html("Rainfall Hydro Graph for Station "+station_id+"<button onclick='back_button()' class='btn btn-small btn-warning' style='float: right; margin-left: 10px; padding: 3px 10px;' >" + 
	"<i class='fas fa-arrow-left'></i> Back</button>");
	//alert(1);
	var dataA = "station_id="+station_id+"&to_date="+to_date;
	$('#cover-spin').show(0);
	$.ajax({
		type: "post",
		url: "module/surface_water_auto/rainfall_availability_daily_graph.php",
		data: dataA,
		success: function(str){
			$('#cover-spin').hide(0);
			
			var data_list_asw = $.parseJSON(str);
		
			var date_input_asw = data_list_asw['date'];
			
			var data_input_asw = data_list_asw['data'];
			
			var timeSeries =  date_input_asw;
			
			// Define individual datasets for each station
			var datasets = [
				{
					label: 'Rainfall (mm)',
			 		data: data_input_asw,
			 		//borderColor: 'rgba(255, 99, 132, 1)',
			 		backgroundColor: 'rgba(0, 153, 255, 1)',
			 		borderColor: 'rgba(0, 153, 255, 1)',
			 		fill: false,
			 	},
			];

			var data = {
			 	labels: timeSeries,
			 	datasets: datasets,
			};

			var ctx = document.getElementById('lineChart').getContext('2d');
			var lineChart = new Chart(ctx, {
			type: 'bar',
			data: data,
			options: {
			 		scales: {
			 				x: [{
			 					type: 'time',
			 					time: {
			 						unit: 'hour',
			 						displayFormats: {
			 							hour: 'MMM D, HH:mm',
			 						},
			 					},
			 					scaleLabel: {
			 						display: true,
			 						labelString: 'Date',
			 					},
			 					title: {
			 					  display: true,
			 					  text: 'Date-Time'
			 					},
			 				},],
			 				y: {
			 					scaleLabel: {
			 						display: true,
			 						labelString: 'Value',
			 					},
			 				},
			 			},
			 		},
			 		plugins: {
			 			title: {
			 				display: true,
			 				text: 'Multi-Line Chart with Common Time Series',
			 			},
			 		},
	
			});
		}
	});
	$("#sw_graph_datatable").load("module/surface_water_auto/rf_graph_data_table.php",dataA);
}
//print graph strat
// Function to download the chart as a JPEG image with a white background
function download_swa_availability_graph_chart() {
	//alert('download_swa_availability_graph_chart');
		 var chartContainer = document.getElementById('lineChart');
		 var canvas = document.createElement('canvas');
		 canvas.width = chartContainer.offsetWidth;
		 canvas.height = chartContainer.offsetHeight;
		 //alert(chartContainer.offsetWidth);
		 var ctx = canvas.getContext('2d');
		 ctx.fillStyle = 'white';
		 ctx.fillRect(0, 0, canvas.width, canvas.height);
		 html2canvas(chartContainer).then(function(chartCanvas) {
			 ctx.drawImage(chartCanvas, 0, 0);
			 canvas.toBlob(function(blob) {
				 var link = document.createElement('a');
				 link.href = URL.createObjectURL(blob);
				 link.download = 'Surface Water Availability Graph';
				 link.click();
			 });
		 });
}

function go_back(){
	load_sw_form();
	load_station_status_details();
	
	$("#sw_datatable").show();
	$("#sw_water_form_data").show();

	$("#graph").hide();
	$("#sw_graph_datatable").hide();
	$("#go_back_button").css("display","none");
}
function back_button(){
	// load_sw_form();
	// load_sw_list();
	
	$("#sw_datatable").show();
	$("#sw_water_form_data").show();

	$("#graph").hide();
	$("#sw_graph_datatable").hide();
	$("#graphLabel").hide();
	$("#go_back_button").css("display","none");
}