<?php
ini_set('display_startup_errors', TRUE);
session_start();
include("../../asset/theme/css/myfunc.php");
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_GET);
//echo "Station: $sel_station_id, Time Period: $sel_time_period";
$sel_year_arr = explode('-',$sel_time_period);
$sel_year = $sel_year_arr[1];

$date_for_mon = "01-$sel_time_period";	
$month_name = date('F', strtotime($date_for_mon));

$rf_well_info = $obj->Details_By_Cond("SW_STATION_AUTO_MANUAL","STATION_ID='$sel_station_id'");

$station_id = $rf_well_info['STATION_ID'];
$station_name = $rf_well_info['STATION_NAME'];
$latitude = number_format((float)$rf_well_info['LATITUDE'], 5, '.', '');
$longitude = number_format((float)$rf_well_info['LONGITUDE'], 5, '.', '');

if (file_exists('../../asset/custom/upload/rainfall_auto_manu_'.$sel_station_id.'_'.$sel_time_period.'.xlsx')) {
        unlink('../../asset/custom/upload/rainfall_auto_manu_'.$sel_station_id.'_'.$sel_time_period.'.xlsx');
}

require_once('../../asset/custom/PHPExcel_class/PHPExcel.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/Calculation.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/Cell.php');

$filename = '../../asset/custom/upload/rainfall_auto_manu_'.$sel_station_id.'_'.$sel_time_period.'.xlsx';

try {
    $objPHPExcel = new PHPExcel();
	$objPHPExcel->getProperties()->setCreator("MokNathal")
                ->setLastModifiedBy("MokNathal")
                ->setTitle("STAFF REPORT")
                ->setSubject("STAFF REPORT")
                ->setDescription("STAFF REPORT")
                ->setKeywords("STAFF REPORT")
                ->setCategory("STAFF REPORT");
	$styleArray = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => 'FF0000')
		),
		'fill' => array(
			'type' => PHPExcel_Style_Fill::FILL_SOLID,
			'color' => array('rgb' => 'FFFF00')
		)
	);
	
	//heading start
    $objPHPExcel->getActiveSheet()->mergeCells('A1:I6');
	$objPHPExcel->getActiveSheet()->getStyle('A1:I6')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A1')->setValue( "Bangladesh Water Development Board \n Processing and Flood Forecasting Circle\n 72-Green Road, Dhaka-1215, Bangladesh\nPhone: +88-02-58151530\nEmail   : se.pffc@bwdb.gov.bd\nWeb      :  www.hydrology.bwdb.gov.bd");
	$objPHPExcel->getActiveSheet()->getStyle('A1:I6')->getAlignment()->setWrapText(true);

	$objPHPExcel->getActiveSheet()->mergeCells('A7:I7');
	$objPHPExcel->getActiveSheet()->getStyle('A7:I7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A7')->setValue( "Rainfall Automated and Manual Data Comparison Report");
	$objPHPExcel->getActiveSheet()->getStyle('A7:I7')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A7')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A8:I8');
	$objPHPExcel->getActiveSheet()->getStyle('A8:I8')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	//$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('A8:I8')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A9')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
	$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	//$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue("Time Period: ".$month_name.', '.$sel_year);
	$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('G9')->getFont()->setBold(true);

	$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Subdivision: ".$rf_well_info['SUBDIVISION_NAME']);
	$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A10')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue("District: ".$rf_well_info['DISTRICT_NAME']);
	$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('D10')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue("Upazila: ".$rf_well_info['UPZL_NAME']);
	$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('G10')->getFont()->setBold(true);
	//headiing end	
	
	$objPHPExcel->getActiveSheet()->mergeCells('A11:I11');
	$objPHPExcel->getActiveSheet()->getStyle('A11:I11')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	//$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('A11:I11')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A12:A13');
	$objPHPExcel->getActiveSheet()->getStyle('A12:A13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A12')->setValue("Sl");
	$objPHPExcel->getActiveSheet()->getStyle('A12:A13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('B12:B13');
	$objPHPExcel->getActiveSheet()->getStyle('B12:B13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('B12')->setValue("Station ID");
	$objPHPExcel->getActiveSheet()->getStyle('B12:B13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('B12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('C12:C13');
	$objPHPExcel->getActiveSheet()->getStyle('C12:C13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('C12')->setValue("Station Name");
	$objPHPExcel->getActiveSheet()->getStyle('C12:C13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('C12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D12:D13');
	$objPHPExcel->getActiveSheet()->getStyle('D12:D13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('D12')->setValue("Latitude");
	$objPHPExcel->getActiveSheet()->getStyle('D12:D13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('D12')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('D12')->getNumberFormat()->setFormatCode('#,##0.00000');
	
	$objPHPExcel->getActiveSheet()->mergeCells('E12:E13');
	$objPHPExcel->getActiveSheet()->getStyle('E12:E13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('E12')->setValue("Longtitude");
	$objPHPExcel->getActiveSheet()->getStyle('E12:E13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('E12')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('E12')->getNumberFormat()->setFormatCode('#,##0.00000');
	
	$objPHPExcel->getActiveSheet()->mergeCells('F12:F13');
	$objPHPExcel->getActiveSheet()->getStyle('F12:F13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('F12')->setValue("Date");
	$objPHPExcel->getActiveSheet()->getStyle('F12:F13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('F12')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('F12')->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_XLSX15);
	
	$objPHPExcel->getActiveSheet()->mergeCells('G12:I12');
	$objPHPExcel->getActiveSheet()->getStyle('G12:I12')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G12')->setValue("Rainfall (mm)");
	$objPHPExcel->getActiveSheet()->getStyle('G12:I12')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('G12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->getStyle('G13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G13')->setValue("Automated");
	$objPHPExcel->getActiveSheet()->getStyle('G13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('G13')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('G13')->getNumberFormat()->setFormatCode('#,##0.000');
	
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('H13')->setValue("Manual");
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getNumberFormat()->setFormatCode('#,##0.000');
	
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('I13')->setValue("Difference(Auto-Manu)");
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getNumberFormat()->setFormatCode('#,##0.000');
	
	$sl=0;
	$row_num = 14;
	foreach($obj->sw_rf_auto_manual_data_list($sel_station_id,$sel_time_period) as $rf_am_data_list){
		$sl++;
		
		$changed_date = date("d-m-Y", strtotime($rf_am_data_list['DT']));
		$date_arr = explode("-", $changed_date);
		$day = $date_arr[0];
		$mon = $date_arr[1];
		$year = $date_arr[2];
		$show_date   = PHPExcel_Shared_Date::FormattedPHPToExcel($year, $mon, $day);
		

		$show_auto_data = "";
		$show_manu_data = "";
		$show_data_diff = "";
		
		if($rf_am_data_list['SARF']!=""){
			$show_auto_data = number_format((float)$rf_am_data_list['SARF'], 3, '.', '');
		}
		else{
			$show_auto_data = "-";
		}
		if($rf_am_data_list['SMRF']!=""){
			$show_manu_data = number_format((float)$rf_am_data_list['SMRF'], 3, '.', '');
		}
		else{
			$show_manu_data = "-";
		}
		
		if($rf_am_data_list['SARF']!="" && $rf_am_data_list['SMRF']!=""){
			$show_data_diff = number_format((float)$rf_am_data_list['SARF'], 3, '.', '') - number_format((float)$rf_am_data_list['SMRF'], 3, '.', '');
			$show_data_diff = number_format((float)$show_data_diff, 3, '.', '');
		}
		else{
			$show_data_diff = "-";
		}
		
		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('A'.$row_num, $sl)
			->setCellValue('B'.$row_num, $station_id)
			->setCellValue('C'.$row_num, $station_name)
			->setCellValue('D'.$row_num, $latitude)
			->setCellValue('E'.$row_num, $longitude)
			->setCellValue('F'.$row_num, $show_date)
			->setCellValue('G'.$row_num, $show_auto_data)
			->setCellValue('H'.$row_num, $show_manu_data)
			->setCellValue('I'.$row_num, $show_data_diff);
		
		$objPHPExcel->getActiveSheet()->getStyle('F'.$row_num)->getNumberFormat()->
			setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_XLSX15);
		$objPHPExcel->getActiveSheet()->getStyle('D'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00000');
		$objPHPExcel->getActiveSheet()->getStyle('E'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00000');
		$objPHPExcel->getActiveSheet()->getStyle('G'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00');
		$objPHPExcel->getActiveSheet()->getStyle('H'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00');
		$objPHPExcel->getActiveSheet()->getStyle('I'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00');

		$row_num++;
	}
	
	 
	foreach (range('A1', 'I1') as $columnID) {
			$objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	}
	$objPHPExcel->getActiveSheet()->setTitle('rf_auto_manu_data');
	$objPHPExcel->setActiveSheetIndex(0);
	ob_clean();

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('../../asset/custom/upload/rainfall_auto_manu_'.$sel_station_id.'_'.$sel_time_period.'.xlsx');
        header('Location: ../../asset/custom/upload/rainfall_auto_manu_'.$sel_station_id.'_'.$sel_time_period.'.xlsx');
} catch (Exception $e) {
        echo 'Caught exception: ', $e->getMessage(), "\n";
}
?>