<?php
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	error_reporting(E_ALL); // Report all types of errors
	ini_set('display_errors', 1); // Display errors on the screen

	require_once('../../asset/vendor/autoload.php');

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
	use PhpOffice\PhpSpreadsheet\Style\Color;
	use PhpOffice\PhpSpreadsheet\Style\Fill;
	use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
	use PhpOffice\PhpSpreadsheet\Shared\Date;
	use PhpOffice\PhpSpreadsheet\Cell\DataType; 

	extract($_REQUEST);
	$stat_type_info = $obj->Details_By_Cond("SW_AUTO_STATION_TYPE", "ID='$station_type'");
	$desc_val = $stat_type_info['STATION_TYPE'];
	$raw_param_id = 0;
	$station_type_name = "";
	$file_name = "";
	if ($station_type == 1) {
		$raw_param_id = 22;
		$station_type_name = "Water Level";
		$file_name = "water_level_real_time_station_status";
	} else if ($station_type == 2) {
		$raw_param_id = 62;
		$station_type_name = "Rainfall";
		$file_name = "rainfall_real_time_station_status";
	} else if ($station_type == 3) {
		$raw_param_id = 62;
		$station_type_name = "Weather";
		$file_name = "weather_real_time_station_status";
	} else {
		$raw_param_id = 451;
		$station_type_name = "Water Level (Costal)";
		$file_name = "coastal_water_level_real_time_station_status";
	}

	/*station type and parameter setting*/
	$where = "STAT.DATA_READ_TYPE IN ('AUTO','BOTH') AND STAT.DESCRIPTION='$desc_val' 
	AND STATUS_TBL.STATION_TYPE='AUTO' AND STATUS_TBL.RAW_PARAMETER_ID='$raw_param_id'";
	$label = "$station_type_name Real Time Stations Status Information";

	/*Label and Condition setting based on location filter*/
	$hydro_div_label = "";
	$hydro_sub_div_label = "";
	$district_label = "";
	if ($hydro_div == "all") {
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' 
	AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='$raw_param_id'";
		$hydro_div_label = "All";
	} else {
		if ($hydro_div != "" && $hydro_sub_div == "all" && $district == "") {
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
			$hydro_div_label = $hydro_div_info['DIVISION_NAME'];
			
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' 
	AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div'";
		} else if ($hydro_div != "" && $hydro_sub_div == "all" && $district != "") {
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
			$hydro_div_label = $hydro_div_info['DIVISION_NAME'];
			
			$dist_info = $obj->Details_By_Cond("HYDROLOGY.DISTRICT_TBL@HYDRO10", "DISTRICT_NO='$district'");
			$district_label = $dist_info['DISTRICT_NAME'];
			
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' 
				AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div' AND DISTRICT_NO='$district'";
		} else if ($hydro_div != "" && $hydro_sub_div != "" && $district == "") {
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
			$hydro_div_label = $hydro_div_info['DIVISION_NAME'];
			
			$hydro_sub_div_info = $obj->Details_By_Cond("HYDROLOGY.SUBDIVCODE_TBL@HYDRO10", "HYDSUBDIVCODE='$hydro_sub_div'");
			$hydro_sub_div_label = $hydro_sub_div_info['SUBDIVISION_NAME'];
			
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' 
				AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div' AND HYDSUBDIVCODE='$hydro_sub_div'";
		} else if ($hydro_div != "" && $hydro_sub_div != "" && $district != "") {
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10", "HYDDIVCODE='$hydro_div'");
			$hydro_div_label = $hydro_div_info['DIVISION_NAME'];
			
			$hydro_sub_div_info = $obj->Details_By_Cond("HYDROLOGY.SUBDIVCODE_TBL@HYDRO10", "HYDSUBDIVCODE='$hydro_sub_div'");
			$hydro_sub_div_label = $hydro_sub_div_info['SUBDIVISION_NAME'];
			
			$dist_info = $obj->Details_By_Cond("HYDROLOGY.DISTRICT_TBL@HYDRO10", "DISTRICT_NO='$district'");
			$district_label = $dist_info['DISTRICT_NAME'];
			
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' 
				AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div' AND HYDSUBDIVCODE='$hydro_sub_div' 
				AND DISTRICT_NO='$district'";
		} else {
			$hydro_div_label = "";
			$hydro_sub_div_label = "";
			$district_label = "";
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='$raw_param_id'";
		}
	}
	/*Label and Condition setting based on location filter*/

	/*Condition Setting based on status filter*/
	$status_label = "";
	if ($sw_status == 1) {
		$where = $where . "";
		$status_label = "Active & Inactive";
	} else if ($sw_status == 2) {
		$where = $where . " AND STATION_STATUS='ACTIVE'";
		$status_label = "Active";
	} else if ($sw_status == 3) {
		$where = $where . " AND STATION_STATUS='INACTIVE' AND DIFF_HOURS<='72' AND DIFF_HOURS>='24'";
		$status_label = "Inactive for 24-72 Hours";
	} else if ($sw_status == 4) {
		$where = $where . " AND STATION_STATUS='INACTIVE' AND DIFF_HOURS>'72'";
		$status_label = "Inactive for more than 72 Hours";
	} else if ($sw_status == 5) {
		$diff_hours_input = $inactive_days * 24;
		$where = $where . " AND STATION_STATUS='INACTIVE' AND DIFF_HOURS>'$diff_hours_input'";
		$status_label = "Inactive for more than $inactive_days days";
	}
	else if($sw_status==6){
		$where = $where." AND STATION_STATUS='INACTIVE'";
		$status_label = "Inactive";
	}
	else {
		$where = $where . "";
		$status_label .= "Active & Inactive";
	}
	
	$spreadsheet = new Spreadsheet();
	$sheet = $spreadsheet->getActiveSheet();
	$sheet->mergeCells('A1:J1'); // Example of merging cells
	$sheet->setCellValue('A1',$label);
	$sheet->getStyle('A1:J1')->getAlignment()->setHorizontal('center');
	$sheet->getStyle('A1:J1')->getAlignment()->setWrapText(true);
	$sheet->getStyle('A1:J1')->getFont()->setBold(true);
	
	$sheet->mergeCells('A2:D2'); // Example of merging cells
	$sheet->setCellValue('A2',"Hydro-Division: ".$hydro_div_label);
	$sheet->getStyle('A2:D2')->getAlignment()->setWrapText(true);
	$sheet->getStyle('A2:D2')->getFont()->setBold(true);
	
	$sheet->mergeCells('G2:J2'); // Example of merging cells
	$sheet->setCellValue('G2',"Hydro-Subdivision: ".$hydro_sub_div_label);
	$sheet->getStyle('G2:J2')->getAlignment()->setWrapText(true);
	$sheet->getStyle('G2:J2')->getFont()->setBold(true);
	
	$sheet->mergeCells('A3:D3'); // Example of merging cells
	$sheet->setCellValue('A3',"District: ".$district_label);
	$sheet->getStyle('A3:D3')->getAlignment()->setWrapText(true);
	$sheet->getStyle('A3:D3')->getFont()->setBold(true);
	
	$sheet->mergeCells('G3:J3'); // Example of merging cells
	$sheet->setCellValue('G3',"Station Status: ".$status_label);
	$sheet->getStyle('G3:J3')->getAlignment()->setWrapText(true);
	$sheet->getStyle('G3:J3')->getFont()->setBold(true);
	
	$sheet->setCellValue('A4', 'Sl.');
	$sheet->setCellValue('B4', 'Station ID');
	$sheet->setCellValue('C4', 'Station Name');
	$sheet->setCellValue('D4', 'District');
	$sheet->setCellValue('E4', 'Upazila');
	$sheet->setCellValue('F4', 'River Name');
	$sheet->setCellValue('G4', 'Latitude');
	$sheet->setCellValue('H4', 'Longitude');
	$sheet->setCellValue('I4', 'First Received Date');
	$sheet->setCellValue('J4', 'Last Received Date');
	
	$sheet->getStyle('A4:J4')->getAlignment()->setHorizontal('center');;
	$sheet->getStyle('A4:J4')->getFont()->setBold(true);
	
	$row_num = 4;
	$sl = 0;
	foreach($obj->surface_water_auto_station_status_details($where) as $value) {
		$sl++;
		$row_num++;
		$stat_id = $value['STATION_ID'];
		$stat_name = $value['STATION_NAME'];
		$dist_name = $value['DISTRICT_NAME'];
		$upzl_name = $value['UPZL_NAME'];
		$riv_name = $value['RIVER_NAME'];
		$latitude = $value['AUTO_LAT'];
		$longitude = $value['AUTO_LON'];
		$first_date_value =  $value['FIRSTRECEIVE_DATE'];
		$last_date_value =  $value['LASTRECEIVE_DATE'];
		
		$first_date_obj = DateTime::createFromFormat('d-M-y',$first_date_value);
		$last_date_obj = DateTime::createFromFormat('d-M-y',$last_date_value);
		
		$current_date_obj = new DateTime();
		$current_date_obj->setTime(0, 0, 0);

		
		$sheet->setCellValue('A'.$row_num, $sl);
		$sheet->setCellValue('B'.$row_num, $stat_id);
		$sheet->setCellValue('C'.$row_num, $stat_name);
		$sheet->setCellValue('D'.$row_num, $dist_name);
		$sheet->setCellValue('E'.$row_num, $upzl_name);
		$sheet->setCellValue('F'.$row_num, $riv_name);
		$sheet->setCellValue('G'.$row_num, $latitude);
		$sheet->setCellValue('H'.$row_num, $longitude);
		if ($first_date_obj !== false) {
			$first_date_obj->setTime(0, 0, 0); // Strip the time to 00:00:00

			$excelFirstDate = Date::PHPToExcel($first_date_obj);

			// Set value and format in the sheet
			$sheet->setCellValue('I'.$row_num, $excelFirstDate);
			$sheet->getStyle('I'.$row_num)->getNumberFormat()
				  ->setFormatCode(NumberFormat::FORMAT_DATE_DDMMYYYY); // 'dd/mm/yyyy'
		} else {
			// Fallback if format doesn't match
			// It's good to log or handle this case more robustly in a real application
			$sheet->setCellValueExplicit('I'.$row_num, $first_date_value, DataType::TYPE_STRING);
		}
		if ($last_date_obj !== false) {
			$last_date_obj->setTime(0, 0, 0); // Strip the time to 00:00:00
				
			$excelLastDate = Date::PHPToExcel($last_date_obj);
	
			// Set value and format in the sheet
			$sheet->setCellValue('J'.$row_num, $excelLastDate);
			$sheet->getStyle('J'.$row_num)->getNumberFormat()
				  ->setFormatCode(NumberFormat::FORMAT_DATE_DDMMYYYY); // 'dd-mmm-yy'
			if ($last_date_obj > $current_date_obj) {
				$sheet->getStyle('J'.$row_num)->getFont()->setBold(true)->getColor()->setRGB(Color::COLOR_RED); 
			}
		} else {
			// Fallback if format doesn't match
			$sheet->setCellValueExplicit('J'.$row_num, $last_date_value, DataType::TYPE_STRING);
		}
	}
	// Redirect output to a client’s web browser (Excel)
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$file_name.'.xlsx"');
	header('Cache-Control: max-age=0');

	// If you're using IE9 or earlier
	header('Cache-Control: max-age=1');

	// Disable caching
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Cache-Control: cache, must-revalidate');
	header('Pragma: public');

	// Output file to browser
	$writer = new Xlsx($spreadsheet);
	$writer->save('php://output');
exit;
?>