<?php
function image_file_upload($image_field_name = 'image', $target_dir = 'uploads/')
{
    $message = '';
    $uploadOk = true;

    if ( empty( $_FILES[$image_field_name]["tmp_name"] ) ) {
        $uploadOk = false;
        $message = "Please select a file to be uploaded.";
        return ['message' => $message, 'success' => false];
    }

    $target_file = $target_dir . basename($_FILES[$image_field_name]["name"]);
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

    // Check if image file is a actual image or fake image
    $check = getimagesize($_FILES[$image_field_name]["tmp_name"]);
    if ($check !== false) {
        $message = "File is an image - " . $check["mime"] . ".";
        $uploadOk = true;
    } else {
        $message = "File is not an image.";
        $uploadOk = false;
    }

    // Check if file already exists
    if (file_exists($target_file)) {
        $message = "Sorry, file already exists.";
        $uploadOk = false;
    }

    // Check file size
    if ($_FILES[$image_field_name]["size"] > 500000) {
        $message = "Sorry, your file is too large.";
        $uploadOk = false;
    }

    // Allow certain file formats
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg"
        && $imageFileType != "gif") {
        $message = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
        $uploadOk = false;
    }

    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == false) {
        $message = "Sorry, your file was not uploaded.";
        // if everything is ok, try to upload file
    } else {
        if (move_uploaded_file($_FILES[$image_field_name]["tmp_name"], $target_file)) {
            $message = "The file " . basename($_FILES[$image_field_name]["name"]) . " has been uploaded.";
            // file has been uploaded successfully
            return ['message' => $message, 'success' => true, 'target_file' => $target_file];
        } else {
            $message = "Sorry, there was an error uploading your file.";
            return ['message' => $message, 'success' => false];
        }
    }
}