/*
 * jsCalendar v1.4.4-beta
 * 
 * 
 * MIT License
 * 
 * Copyright (c) 2018 Grammatopoulos Athanasios-Vasileios
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */

var jsCalendar=function(){function c(){0!==arguments.length&&this._construct(arguments)}c.version="v1.4.4-beta";c.prototype._construct=function(a){a=this._parseArguments(a);this._init(a.options);this._setTarget(a.target);this._initTarget();this._setDate(a.date);this._create();this._update()};c.prototype.languages={en:{months:"January February March April May June July August September October November December".split(" "),days:"Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),_dateStringParser:function(a,
b){return c._defaultDateStringParser(a,b,this)},_dayStringParser:function(a,b){return c._defaultDayStringParser(a,b,this)}}};c.prototype._init=function(a){this._elements={};this._events={};this._events.date=[];this._events.month=[];this._date=this._now=null;this._selected=[];this.language={};this._parseOptions(a)};c.prototype._parseArguments=function(a){var b={target:null,date:new Date,options:{}};if(0===a.length)throw Error("jsCalendar: No parameters were given.");if(1===a.length)if(("object"===
typeof HTMLElement?a[0]instanceof HTMLElement:a[0])&&"object"===typeof a[0]&&null!==a[0]&&1===a[0].nodeType&&"string"===typeof a[0].nodeName||"string"===typeof a[0])b.target=a[0];else{b.options=a[0];if("undefined"!==typeof a[0].target)b.target=a[0].target;else throw Error("jsCalendar: Not target was given.");"undefined"!==typeof a[0].date&&(b.date=a[0].date)}else b.target=a[0],2<=a.length&&(b.date=a[1]),3<=a.length&&(b.options=a[2]);return b};c.prototype._parseOptions=function(a){this._options={language:"en",
zeroFill:!1,monthFormat:"month",dayFormat:"D",firstDayOfTheWeek:1,navigator:!0,navigatorPosition:"both",min:!1,max:!1};"undefined"!==typeof a.zeroFill&&(this._options.zeroFill="false"!==a.zeroFill&&a.zeroFill?!0:!1);"undefined"!==typeof a.monthFormat&&(this._options.monthFormat=a.monthFormat);"undefined"!==typeof a.dayFormat&&(this._options.dayFormat=a.dayFormat);"undefined"!==typeof a.navigator&&(this._options.navigator="false"!==a.navigator&&a.navigator?!0:!1);"undefined"!==typeof a.navigatorPosition&&
(this._options.navigatorPosition=a.navigatorPosition);"string"===typeof a.language&&"undefined"!==typeof this.languages[a.language]&&(this._options.language=a.language);this.setLanguage(this._options.language);"undefined"!==typeof a.fdotw&&(a.firstDayOfTheWeek=a.fdotw);if("undefined"!==typeof a.firstDayOfTheWeek&&("number"===typeof a.firstDayOfTheWeek&&1<=a.firstDayOfTheWeek&&7>=a.firstDayOfTheWeek&&(this._options.firstDayOfTheWeek=a.firstDayOfTheWeek),"string"===typeof a.firstDayOfTheWeek))if(a.firstDayOfTheWeek.match(/^[1-7]$/))this._options.firstDayOfTheWeek=
parseInt(a.firstDayOfTheWeek,10);else if(this._options.firstDayOfTheWeek=this.language.days.indexOf(a.firstDayOfTheWeek)+1,1>this._options.firstDayOfTheWeek||7<this._options.firstDayOfTheWeek)this._options.firstDayOfTheWeek=1;"undefined"!==typeof a.min&&"false"!==a.min&&!1!==a.min&&(this._options.min=this._parseDate(a.min));"undefined"!==typeof a.max&&"false"!==a.max&&!1!==a.max&&(this._options.max=this._parseDate(a.max))};c.prototype._setTarget=function(a){if(a=this._getElement(a))this._target=a,
(this._target_id=this._target.id)&&0<this._target_id.length&&(f["#"+this._target_id]=this);else throw Error("jsCalendar: Target was not found.");};c.prototype._getElement=function(a){if(!a)return null;if("string"===typeof a){if("#"===a[0])return document.getElementById(a.substring(1));if("."===a[0])return document.getElementsByClassName(a.substring(1))[0]}else if(a.tagName&&a.nodeName&&a.ownerDocument&&a.removeAttribute)return a;return null};c.prototype._initTarget=function(){0<this._target.className.length&&
(this._target.className+=" ");this._target.className+="jsCalendar";this._elements.table=document.createElement("table");this._elements.head=document.createElement("thead");this._elements.table.appendChild(this._elements.head);this._elements.body=document.createElement("tbody");this._elements.table.appendChild(this._elements.body);this._target.appendChild(this._elements.table)};c.prototype._isDateInRange=function(a){if(!1===this._options.min&&!1===this._options.max)return!0;a=this._parseDate(a);return!1!==
this._options.min&&this._options.min.getTime()>a.getTime()||!1!==this._options.max&&this._options.max.getTime()<a.getTime()?!1:!0};c.prototype._setDate=function(a){this._isDateInRange(a)&&(this._now=this._parseDate(a),this._date=new Date(this._now.getFullYear(),this._now.getMonth(),1))};c.prototype._parseDate=function(a){if("undefined"===typeof a||null===a||"now"===a)a=new Date;else if("string"===typeof a)if(a=a.replace(/-/g,"/").match(/^(\d{1,2})\/(\d{1,2})\/(\d{4,4})$/i),null!==a){var b=parseInt(a[2],
10)-1;a=new Date(a[3],b,a[1]);if(!a||a.getMonth()!==b)throw Error("jsCalendar: Date does not exist.");}else throw Error("jsCalendar: Failed to parse date.");else if("number"===typeof a)a=new Date(a);else if(!(a instanceof Date))throw Error("jsCalendar: Invalid date.");return new Date(a.getTime())};c.prototype._parseToDateString=function(a,b){var d=this.language;return b.replace(/(MONTH|month|MMM|mmm|mm|m|MM|M|DAY|day|DDD|ddd|dd|d|DD|D|YYYY|yyyy)/g,function(b){return d.dateStringParser(b,a)})};c.prototype._getVisibleMonth=
function(a){a="undefined"===typeof a?this._date:this._parseDate(a);var b=new Date(a.getTime());b.setDate(1);var d=b.getDay()-(this._options.firstDayOfTheWeek-1);0>d&&(d+=7);var c=this.language,h=this._options.monthFormat.replace(/(MONTH|month|MMM|mmm|##|#|YYYY|yyyy)/g,function(a){return c.dateStringParser(a,b)});a=this._getVisibleDates(a);var f=(new Date(b.getYear()+1900,b.getMonth()+1,0)).getDate(),g=-1;b.getYear()===this._now.getYear()&&b.getMonth()===this._now.getMonth()&&(g=d+this._now.getDate()-
1);return{name:h,days:a,start:d+1,current:g,end:d+f}};c.prototype._getVisibleDates=function(a){a="undefined"===typeof a?this._date:this._parseDate(a);var b=[],d=new Date(a.getTime());d.setDate(1);d.setHours(0,0,0,0);var c=d.getDay()-(this._options.firstDayOfTheWeek-1);0>c&&(c+=7);for(a=new Date(d.getTime());0<c;)a.setDate(a.getDate()-1),b.unshift(new Date(a.getTime())),c--;a=new Date(d.getTime());do b.push(new Date(a.getTime())),a.setDate(a.getDate()+1);while(1!==a.getDate());for(d=42-b.length;0<
d;)b.push(new Date(a.getTime())),a.setDate(a.getDate()+1),d--;return b};c.prototype._create=function(){var a,b,d=this;this._elements.created=!0;this._elements.headRows=[];for(a=0;2>a;a++)this._elements.headRows.push(document.createElement("tr")),this._elements.head.appendChild(this._elements.headRows[a]);a=document.createElement("th");a.setAttribute("colspan",7);this._elements.headRows[0].className="jsCalendar-title-row";this._elements.headRows[0].appendChild(a);this._elements.headLeft=document.createElement("div");
this._elements.headLeft.className="jsCalendar-title-left";a.appendChild(this._elements.headLeft);this._elements.month=document.createElement("div");this._elements.month.className="jsCalendar-title-name";a.appendChild(this._elements.month);this._elements.headRight=document.createElement("div");this._elements.headRight.className="jsCalendar-title-right";a.appendChild(this._elements.headRight);this._options.navigator&&(this._elements.navLeft=document.createElement("div"),this._elements.navLeft.className=
"jsCalendar-nav-left",this._elements.navRight=document.createElement("div"),this._elements.navRight.className="jsCalendar-nav-right","left"===this._options.navigatorPosition?(this._elements.headLeft.appendChild(this._elements.navLeft),this._elements.headLeft.appendChild(this._elements.navRight)):("right"===this._options.navigatorPosition?this._elements.headRight.appendChild(this._elements.navLeft):this._elements.headLeft.appendChild(this._elements.navLeft),this._elements.headRight.appendChild(this._elements.navRight)),
this._elements.navLeft.addEventListener("click",function(a){d.previous();d._eventFire_monthChange(a,d._date)},!1),this._elements.navRight.addEventListener("click",function(a){d.next();d._eventFire_monthChange(a,d._date)},!1));this._elements.headRows[1].className="jsCalendar-week-days";a.className="jsCalendar-title";this._elements.days=[];for(a=0;7>a;a++)this._elements.days.push(document.createElement("th")),this._elements.headRows[1].appendChild(this._elements.days[this._elements.days.length-1]);
this._elements.bodyRows=[];this._elements.bodyCols=[];for(a=0;6>a;a++)for(this._elements.bodyRows.push(document.createElement("tr")),this._elements.body.appendChild(this._elements.bodyRows[a]),b=0;7>b;b++)this._elements.bodyCols.push(document.createElement("td")),this._elements.bodyRows[a].appendChild(this._elements.bodyCols[7*a+b]),this._elements.bodyCols[7*a+b].addEventListener("click",function(a){return function(b){d._eventFire_dateClick(b,d._active[a])}}(7*a+b),!1)};c.prototype._selectDates=function(a){a=
a.slice();for(var b=0;b<a.length;b++)a[b]=this._parseDate(a[b]),a[b].setHours(0,0,0,0),a[b]=a[b].getTime();for(b=a.length-1;0<=b;b--)0>this._selected.indexOf(a[b])&&this._selected.push(a[b])};c.prototype._unselectDates=function(a){a=a.slice();for(var b=0;b<a.length;b++)a[b]=this._parseDate(a[b]),a[b].setHours(0,0,0,0),a[b]=a[b].getTime();for(b=a.length-1;0<=b;b--){var d=this._selected.indexOf(a[b]);0<=d&&this._selected.splice(d,1)}};c.prototype._unselectAllDates=function(){for(;this._selected.length;)this._selected.pop()};
c.prototype._update=function(){var a=this._getVisibleMonth(this._date);this._active=a.days.slice();this._elements.month.textContent=a.name;for(var b=this._options.zeroFill?"0":"",d,c=a.days.length-1;0<=c;c--)d=a.days[c].getDate(),this._elements.bodyCols[c].textContent=10>d?b+d:d,0<=this._selected.indexOf(a.days[c].getTime())?this._elements.bodyCols[c].className="jsCalendar-selected":this._elements.bodyCols[c].removeAttribute("class");for(c=0;c<a.start-1;c++)this._elements.bodyCols[c].className="jsCalendar-previous";
0<=a.current&&(this._elements.bodyCols[a.current].className=0<this._elements.bodyCols[a.current].className.length?this._elements.bodyCols[a.current].className+" jsCalendar-current":"jsCalendar-current");for(c=a.end;c<a.days.length;c++)this._elements.bodyCols[c].className="jsCalendar-next";for(c=0;7>c;c++){var f=this;this._elements.days[c].textContent=this._options.dayFormat.replace(/(DAY|day|DDD|ddd|DD|dd|D)/g,function(a){return f.language.dayStringParser(a,(c+f._options.firstDayOfTheWeek-1)%7)})}};
c.prototype._eventFire_dateClick=function(a,b){for(var c=0;c<this._events.date.length;c++)(function(c){setTimeout(function(){c(a,new Date(b.getTime()))},0)})(this._events.date[c])};c.prototype._eventFire_monthChange=function(a,b){var c=new Date(b.getTime());c.setDate(1);for(var e=0;e<this._events.month.length;e++)(function(b){setTimeout(function(){b(a,new Date(c.getTime()))},0)})(this._events.month[e])};c.prototype.onDateClick=function(a){if("function"===typeof a)this._events.date.push(a);else throw Error("jsCalendar: Invalid callback function.");
return this};c.prototype.onMonthChange=function(a){if("function"===typeof a)this._events.month.push(a);else throw Error("jsCalendar: Invalid callback function.");return this};c.prototype.set=function(a){this._setDate(a);this.refresh();return this};c.prototype.min=function(a){this._options.min=a?this._parseDate(a):!1;this.refresh();return this};c.prototype.max=function(a){this._options.max=a?this._parseDate(a):!1;this.refresh();return this};c.prototype.refresh=function(a){"undefined"!==typeof a&&this._isDateInRange(a)&&
(this._date=this._parseDate(a));!0===this._elements.created&&this._update();return this};c.prototype.next=function(a){"number"!==typeof a&&(a=1);a=new Date(this._date.getFullYear(),this._date.getMonth()+a,1);if(!this._isDateInRange(a))return this;this._date=a;this.refresh();return this};c.prototype.previous=function(a){"number"!==typeof a&&(a=1);a=new Date(this._date.getFullYear(),this._date.getMonth()-a,1);if(!this._isDateInRange(a))return this;this._date=a;this.refresh();return this};c.prototype["goto"]=
function(a){this.refresh(a);return this};c.prototype.reset=function(){this.refresh(this._now);return this};c.prototype.select=function(a){if("undefined"===typeof a)return this;a instanceof Array||(a=[a]);this._selectDates(a);this.refresh();return this};c.prototype.unselect=function(a){if("undefined"===typeof a)return this;a instanceof Array||(a=[a]);this._unselectDates(a);this.refresh();return this};c.prototype.clearselect=function(){this._unselectAllDates();this.refresh();return this};c.prototype.clearSelected=
c.prototype.clearselect;c.prototype.getSelected=function(a){"object"!==typeof a&&(a={});var b=this._selected.slice();a.sort&&(!0===a.sort?b.sort():"string"===typeof a.sort&&("asc"===a.sort.toLowerCase()?b.sort():"desc"===a.sort.toLowerCase()&&(b.sort(),b.reverse())));if(a.type&&"string"===typeof a.type){var c;if("date"===a.type.toLowerCase())for(c=b.length-1;0<=c;c--)b[c]=new Date(b[c]);else if("timestamp"!==a.type.toLowerCase())for(c=b.length-1;0<=c;c--)b[c]=this._parseToDateString(new Date(b[c]),
a.type)}return b};c.prototype.isSelected=function(a){if("undefined"===typeof a||null===a)return!1;a=this._parseDate(a);a.setHours(0,0,0,0);a=a.getTime();return 0<=this._selected.indexOf(a)?!0:!1};c.prototype.isVisible=function(a){if("undefined"===typeof a||null===a)return!1;a=this._parseDate(a);a.setHours(0,0,0,0);a=a.getTime();var b=this._getVisibleDates();return b[0].getTime()<=a&&b[b.length-1].getTime()>=a?!0:!1};c.prototype.isInMonth=function(a){if("undefined"===typeof a||null===a)return!1;a=
this._parseDate(a);a.setHours(0,0,0,0);a.setDate(1);var b=this._parseDate(this._date);b.setHours(0,0,0,0);b.setDate(1);return a.getTime()===b.getTime()?!0:!1};c.prototype.setLanguage=function(a){if("string"!==typeof a)throw Error("jsCalendar: Invalid language code.");if("undefined"===typeof this.languages[a])throw Error("jsCalendar: Language not found.");this._options.language=a;a=this.languages[a];this.language.months=a.months;this.language.days=a.days;this.language.dateStringParser=a._dateStringParser;
this.language.dayStringParser=a._dayStringParser;this.refresh();return this};c.autoFind=function(){for(var a=document.getElementsByClassName("auto-jsCalendar"),b,c=0;c<a.length;c++)if("true"!==a[c].getAttribute("jsCalendar-loaded")){a[c].setAttribute("jsCalendar-loaded","true");b={};for(var e in a[c].dataset)b[e]=a[c].dataset[e];b.target=a[c];new jsCalendar(b)}};c.tools={};c.tools.parseDate=function(){return c.prototype._parseDate.apply({},arguments)};c.tools.stringToDate=c.tools.parseDate;c.tools.dateToString=
function(a,b,d){var e=c.prototype.languages;d&&e.hasOwnProperty(d)||(d="en");return c.prototype._parseToDateString.apply({language:{months:e[d].months,days:e[d].days,dateStringParser:e[d]._dateStringParser,dayStringParser:e[d]._dayStringParser}},[a,b])};c["new"]=function(){var a=new c;a._construct(arguments);return a};var f={};c.set=function(a,b){if(b instanceof jsCalendar)return f[a]=b,!0;throw Error("jsCalendar: The second parameter is not a jsCalendar.");};c.get=function(a){return f.hasOwnProperty(a)?
f[a]:null};c.del=function(a){return f.hasOwnProperty(a)?(delete f[a],!0):!1};c.addLanguage=function(a){if("undefined"===typeof a)throw Error("jsCalendar: No language object was given.");if("string"!==typeof a.code)throw Error("jsCalendar: Invalid language code.");if(!(a.months instanceof Array))throw Error("jsCalendar: Invalid language months.");if(12!==a.months.length)throw Error("jsCalendar: Invalid language months length.");if(!(a.days instanceof Array))throw Error("jsCalendar: Invalid language days.");
if(7!==a.days.length)throw Error("jsCalendar: Invalid language days length.");c.prototype.languages[a.code]=a;a._dateStringParser=a.hasOwnProperty("dateStringParser")?function(b,d){return a.dateStringParser(b,d)||c._defaultDateStringParser(b,d,a)}:function(b,d){return c._defaultDateStringParser(b,d,a)};a._dayStringParser=a.hasOwnProperty("dayStringParser")?function(b,d){return a.dayStringParser(b,d)||c._defaultDayStringParser(b,d,a)}:function(b,d){return c._defaultDayStringParser(b,d,a)}};c._defaultDateStringParser=
function(a,b,c){switch(a){case "MONTH":case "month":return c.months[b.getMonth()];case "MMM":case "mmm":return c.months[b.getMonth()].substring(0,3);case "mm":return c.months[b.getMonth()].substring(0,2);case "m":return c.months[b.getMonth()].substring(0,1);case "MM":return(9>b.getMonth()?"0":"")+(b.getMonth()+1);case "M":return b.getMonth()+1;case "##":return(9>b.getMonth()?"0":"")+(b.getMonth()+1);case "#":return b.getMonth()+1;case "DAY":case "day":return c.days[b.getDay()];case "DDD":case "ddd":return c.days[b.getDay()].substring(0,
3);case "dd":return c.days[b.getDay()].substring(0,2);case "d":return c.days[b.getDay()].substring(0,1);case "DD":return(9>=b.getDate()?"0":"")+b.getDate();case "D":return b.getDate();case "YYYY":case "yyyy":return b.getYear()+1900}};c._defaultDayStringParser=function(a,b,c){switch(a){case "DAY":case "day":return c.days[b];case "DDD":case "ddd":return c.days[b].substring(0,3);case "DD":case "dd":return c.days[b].substring(0,2);case "D":return c.days[b].substring(0,1)}};(function(){if("undefined"!==
typeof window.jsCalendar_language2load){for(;window.jsCalendar_language2load.length;)setTimeout(function(a){return function(){c.addLanguage(a)}}(window.jsCalendar_language2load.pop()),0);delete window.jsCalendar_language2load}})();return c}();(function(){window.addEventListener("load",function(){jsCalendar.autoFind()},!1)})();
