<?php

namespace App\Http\Controllers\V1;

use Illuminate\Http\Request;
use App\Models\Hidm\HydroDistrict;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DistrictController extends Controller
{
    public function districtList()
    {
        $user = Auth::user();
        if (!$user) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        if (str_contains($user->user_login_id, '@')) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }
        $Data = HydroDistrict::where('district_no', '!=', '00')->get()->map(function($value){
            return $value;
        });
        return response()->json([
            'status' => 'success',
            'district_info' => $Data,
        ],200);
       
    }
}
