<?php

namespace App\Http\Controllers\V1\QueryTraits;

use Closure;
use RuntimeException;
use Illuminate\Support\Arr;
use App\Models\Hims\RawData;
use App\Models\ClientCollection;
use App\Models\ClientCollectionStation;
use Illuminate\Queue\CallQueuedClosure;
use App\Http\Resources\SwStationResource;

trait SwApiQuery
{
    public function getSwAllDataQuery($data,$clientCollectionId, $paginate = false)
    {

       $Datas = RawData::query()
                        ->with('DataOrigin', 'DataOrigin.Station')
                        ->whereHas('DataOrigin', function ($query) use ($data,$clientCollectionId) {
                            $query->whereHas('Station', function ($query) use ($data,$clientCollectionId) {
                                $query->where('oracle_user.station.station_type_id', 21);// 21 is for surface water
                                if(ClientCollection::whereNull('is_all_station')->find($clientCollectionId)) {
                                    $query->whereHas('ClientCollectionStation', function ($query) use ($clientCollectionId) {
                                        $query->where('api_client_collection_stations.client_collection_id', $clientCollectionId);// 21 is for surface water
                                    });
                                }

                                if(isset($data['identifier'])) {
                                    $query->where('oracle_user.station.identifier', $data['identifier']);
                                }
                            });
                        })
                        ->where('oracle_user.raw_data.parameter_code', 'STAGE_RT')
                        ->orderBy('oracle_user.raw_data.time', 'DESC');


        if(isset($data['date']) && $data['date']) {
            $Datas->whereDate('oracle_user.raw_data.time', $data['date']);
        } else {
            if(isset($data['from_date']) && $data['from_date']) {
                $Datas->whereDate('oracle_user.raw_data.time', '>=', $data['from_date']);
            }

            if(isset($data['to_date']) && $data['to_date']) {
                $Datas->whereDate('oracle_user.raw_data.time', '<=', $data['to_date']);
            }
        }

        if(isset($data['per_page']) && !$paginate) {
            $Datas->limit($data['per_page']);
        }

        if(!isset($data['per_page'])) {
            $data['per_page'] = 10;
        }

        if($paginate) {
            return $Datas->paginate($data['per_page']);
        }

        return $Datas->get();
    }
}
