<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Models\Vms\RegisterCard;
use App\Models\Vms\VisitorCard;
use App\Models\Vms\VisitorLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class VisitorApiController extends Controller
{
    public function storeVisitorLog(Request $request)
    {
        $Setting = Setting::first();

        if(!in_array($request->ip(), explode(',', $Setting->device_access_ips))) {
            return response()->json([
                'status' => 'error',
                'message' => 'You are not allowed to access this device!'
            ], 403);
        }

        $validator = Validator::make($request->all(), [
                'device_id' => 'nullable',
                'rfid' => 'required',
                'time_log' => 'required|date',
            ]);

        if ($validator->fails()) {
            return response()->json([
                        'status' => 'error',
                        'message' => $validator->messages()
                    ], 403);

        }

        $VisitorCard = VisitorCard::whereHas('RegisterCard', function ($query) use ($request) {
            $query->where('bp_register_cards.rfid', $request->rfid);
        })->whereNull('bp_visitor_cards.is_unassign')->whereNotNull('bp_visitor_cards.is_assigned')->first();

        if(!$VisitorCard) {
            return response()->json([
                'status' => 'error',
                'message' => 'Card not assigned!'
            ], 403);
        }

        VisitorLog::create([
            'register_card_id' => $VisitorCard->register_card_id,
            'visitor_id' => $VisitorCard->visitor_id,
            'contact_id' => $VisitorCard->contact_id,
            'time_log' => now()->parse($request->time_log)->format('Y-m-d H:i:s'),
        ]);

        return response()->json([
            'status' => 'success',
            'message' => 'Visitor log stored successfully!'
        ], 200);
    }
}
