<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\ClientToken;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class BearerTokenCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->bearerToken();

        if(!$request->has('api_key')) {
            return response()->json([
                                'message' => 'You are not authorized to access this API',
                                'status' => 'Unauthorized'
                            ], 200);
        }

        $allowToken = [
            '121212'
        ];

        if(!in_array($request->api_key, $allowToken)) {
            return response()->json([
                                'message' => 'Your token is not valid',
                                'status' => 'Unauthorized'
                            ], 200);
        }


        // if(!ClientToken::where('token', $token)->exists()) {
        //     return response()->json([
        //                         'message' => 'Your token is not valid',
        //                         'status' => 'Unauthorized'
        //                     ], 200);
        // }

        return $next($request);
    }
}
