<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\Hidm\HydroDataLog;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;


class HydroStationResource extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @return array<int|string, mixed>
     */
    public function toArray(Request $request): array
    {
        $date = now()->parse($request->date);
        $data = HydroDataLog::where('well_id', $request->keyword)->whereDate('log_date', $date)->first();
        if (!$data) {
            $data = new HydroDataLog();
        }
        $user = Auth::user();
        $data->well_id = $request->keyword;
        $data->log_Date = $date;
        $data->water_lvl = $request->value;
        $data->status = 'P';
        $data->flag = 1;
        $data->update_by = $user->user_id;
        $data->update_date = now();
        $flag = $data->save();

        if (!$flag) {
            return response( [
                'status' => 'Error',
                'message' => 'Something Went wrong',
            ],422);
        } else {
            return[
                'status' => 'success',
                'message' => 'Data Successfully Saved!',
            ];
        }
    }
}
