<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SwStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
                'station_id' => $this->DataOrigin->Station->identifier,
                'river_name' => '',
                'station_name' => $this->DataOrigin->Station->name,
                'datetime' => $this->time->format('Y-m-d H:i:s'),
                'danger_level' => '',
                'longitude' => $this->DataOrigin->Station->longitude,
                'latitude' => $this->DataOrigin->Station->latitude,
                'value' => $this->value,
            ];
    }
}
