<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Support\Facades\DB;
use App\Models\Hidm\DataTypeHydro10;
use App\Models\Hidm\HydroDataMaster10;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Models\Hidm\RequestDataDetailsHydro10;

class DataRequestApprovalOnlineMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    public $req_mas_id;

    public function __construct($req_mas_id)
    {
        $this->req_mas_id = $req_mas_id;
    }

    public function build()
    {
        $HydroDataMaster = HydroDataMaster10::with('siteUserAcl')->where('id', $this->req_mas_id)->first();

        // $RequestDataDetailsHydros = RequestDataDetailsHydro10::with('DataTypeHydro10')->where('request_data_details.invoice_id', $HydroDataMaster->invoice_no)->get();
        $RequestDataDetailsHydros = RequestDataDetailsHydro10::where('request_data_details.invoice_id', $HydroDataMaster->invoice_no)->get();


        dd($RequestDataDetailsHydros);

        return $this->subject('User Registration Status')->view('emails.data-request-approval-online-mail', [
            'HydroDataMaster' => $HydroDataMaster,
            'RequestDataDetailsHydros' => $RequestDataDetailsHydros,
        ]);
    }
}
