<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class UserRejectionMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    public $name;
    public $rejectionReason;

    /**
     * Create a new message instance.
     */

    public function __construct($name, $rejectionReason)
    {
        $this->name = $name;
        $this->rejectionReason = $rejectionReason;
    }

    public function build()
    {
        return $this->subject('User Registration Status')->view('emails.user-rejection-mail');
    }
}
