<?php

namespace App\Models;

use App\Models\Collection;
use App\Models\Hims\Station;
use App\Models\CollectionParameter;
use App\Models\ClientCollectionStation;
use Illuminate\Database\Eloquent\Model;
use App\Models\ClientCollectionParameter;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class ClientCollection extends Model
{
    use HasFactory;

    protected $table = 'api_client_collections';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public function scopeActive($query)
    {
        return $query->where('api_client_collections.status', 1);
    }

    public function Collection()
    {
        return $this->belongsTo(Collection::class, 'collection_id');
    }

    public function Client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }

    public function ClientToken()
    {
        return $this->belongsTo(ClientToken::class, 'client_id', 'client_id');
    }

    public function CollectionParameter()
    {
        return $this->hasMany(CollectionParameter::class, 'collection_id', 'collection_id');
    }

    public function ClientCollectionStation()
    {
        return $this->hasMany(ClientCollectionStation::class, 'client_collection_id');
    }

    public function Station(): BelongsToMany
    {
        return $this->belongsToMany(Station::class, ClientCollectionStation::class, 'client_collection_id', 'station_id');
    }
}
