<?php

namespace App\Models\Hidm;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Rishadblack\OracleTableLinker\Traits\HasDbLink;

class HydroSwlData extends Model
{
    use HasDbLink;
    use HasFactory;
    public $incrementing = false;
    protected $primaryKey = null;
    public $timestamps = false;
    protected $guarded = [];
    protected $table = 'HYDROLOGY.SWL_DATA@HYDRO10';
    protected $casts = [
        'swl_date' => 'datetime',
        'insert_dtm' => 'datetime',
        'updt_dtm' => 'datetime',
    ];

    const CREATED_AT = 'insert_dtm';
    const UPDATED_AT = 'updt_dtm';

    public function siteUserAcl()
    {
        return $this->belongsTo(SiteUserAcl::class, 'user_id', 'user_id');
    }
}
