<?php

namespace App\Pages\Himsapi;

use Livewire\Component;
use App\Models\ClientToken;
use App\Traits\WithSweetAlert;
use App\Models\Client as HimsapiClient;

class Client extends Component
{
    use WithSweetAlert;
    public $id;
    public $uuid;
    public $name;
    public $office_name;
    public $address;
    public $phone;
    public $email;
    public $status;
    public $token;
    public $client_token = 0;
    public $start_at;
    public $expire_at;

    protected $listeners = [
        'addClientModal',
        'clientDelete',
    ];

    public function addClientModal($data = [])
    {
        $this->reset();
        $this->dispatch('typeahead_reset');
        if (isset($data['id'])) {
            $this->clientEdit($data['id']);
        }
        
        // dd("lamim");
        // $this->emit('refreshDatatable');
        $this->dispatch('modalOpen', 'addClientModal');
    }
    public function clientInfoStore()
    {

        // $this->dispatch('modalClose', 'addClientModal');

        // return true;
        $validation = [
            'uuid' => ['nullable', 'string','max:36'],
            'name' => ['required', 'string'],
            'office_name' => ['required', 'string'],
            'address' => ['nullable', 'string'],
            'phone' => ['required', 'numeric', 'digits:11'],
            'email' => ['required', 'email'],
        ];
        $this->validate($validation);
        $Client = HimsapiClient::findOrNew($this->id);
        $Client->uuid = $this->uuid;
        $Client->name = $this->name;
        $Client->office_name = $this->office_name;
        $Client->address = $this->address;
        $Client->phone = $this->phone;
        $Client->email = $this->email;
        $Client->save();
        // $this->emit('refreshDatatable');
        // $this->dispatch('modalClose', 'addClientModal');
        $this->alert('success', 'client successfully '.($this->id ? 'updated':'created'));
        $ApiToken = ClientToken::where('client_id', $Client->id)->firstOrNew(['client_id' => $Client->id]);
        $ApiToken->client_id = $Client->id;
        $ApiToken->token = bin2hex(random_bytes(16));
        $ApiToken->start_at = $ApiToken->start_at ?? now();
        $ApiToken->save();

    }

    public function clientEdit($id)
    {
        $Client = HimsapiClient::find($id);

        if (!$Client) {
            $this->alert('error', "Client Not Find");
            return;
        }
        $this->id = $id;
        $this->uuid = $Client->uuid;
        $this->name = $Client->name;
        $this->office_name = $Client->office_name;
        $this->email = $Client->email;
        $this->address = $Client->address;
        $this->phone = $Client->phone;
        $this->email = $Client->email;

        if($Client->clientToken) {
            $this->token = $Client->clientToken->token;
            $this->expire_at = $Client->clientToken->expire_at ? $Client->clientToken->expire_at->format('d-m-Y'): '';
        }
    }

    public function clientDelete($data = [])
    {
        $data = $this->alertConfirm($data);

        if (isset($data['id'])) {
            HimsapiClient::find($data['id'])->delete();

            $this->emit('refreshDatatable');
            $this->alert('success', 'client successfully deleted');
        }
    }

    public function clientView($data = [])
    {
        $Client = HimsapiClient::find($data['id']);
        if (!$Client) {
            $this->alert('error', "Client Not Find");
            return;
        }
        if (isset($data['id'])) {
            $this->clientEdit($data['id']);
        }

        $this->dispatch('modalOpen', 'clientViewModal');
    }

    public function updatedExpireAt($value)
    {
        $ApiToken = ClientToken::where('client_id', $this->id)->first();
        
        $ApiToken->expire_at = $value;
        $ApiToken->save();

        $this->alert('success', 'Client api token expire date updated successfully');
    }

    public function generateToken()
    {
        $ApiToken = ClientToken::where('client_id', $this->id)->firstOrNew(['client_id' => $this->id]);
        $ApiToken->client_id = $this->id;
        $ApiToken->token = bin2hex(random_bytes(16));
        $ApiToken->start_at = $ApiToken->start_at ?? now();
        $ApiToken->save();

        $this->token = $ApiToken->token;
        $this->alert('success', 'Client api token generated successfully');

    }

    public function render()
    {
        return view('pages.himsapi.client');
    }
}
