<?php

namespace App\Pages\Himsapi;

use Livewire\Component;
use App\Models\Collection;
use Livewire\Attributes\On;
use App\Traits\WithSweetAlert;

class CollectionList extends Component
{
    use WithSweetAlert;
    public $collection_id;

    public $title;
    public $des;
    public $request_url;
    public $response_type;
    public $request_type;
    public $request_limit;
    public $is_ftp;
    public $status;

    #[On('addApiModal')]
    public function addApiModal($data = [])
    {
        $this->reset();
        $this->dispatch('typeahead_reset');

        if (isset($data['id'])) {
            $this->apiEdit($data['id']);
        }
        $this->dispatch('modalOpen', 'addApiModal');
        $this->dispatch('typeahead_update');
    }

    #[On('apiDelete')]
    public function apiDelete($data = [])
    {
        // $data = $this->alertConfirm($data);

        if (isset($data['id'])) {
            $Collection = Collection::find($data['id']);

            if (!$Collection) {
                $this->alert('error', "Api Not Find");
                return;
            }
            $Collection->delete();
            $this->alert('success', 'Api successfully deleted');
            $this->dispatch('refreshDatatable');
        }
    }

    public function ApiStore()
    {
        $validation = [
            'title' => ['required', 'string'],
            'des' => ['required', 'string'],
            'request_url' => ['required', 'string'],
            'response_type' => ['required', 'integer'],
            'request_type' => ['required', 'integer'],
            'request_limit' => ['required', 'integer'],
            'is_ftp' => ['nullable'],
            'status' => ['required', 'integer'],
        ];

        $this->validate($validation);

        $Collection = Collection::findOrNew($this->collection_id);
        $Collection->title = $this->title;
        $Collection->des = $this->des;
        $Collection->request_url = $this->request_url;
        $Collection->response_type = $this->response_type;
        $Collection->request_type = $this->request_type;
        $Collection->request_limit = $this->request_limit;
        $Collection->is_ftp = $this->is_ftp ? true : null;
        $Collection->status = $this->status;
        $Collection->save();

        $this->alert('success', 'Api successfully '.($this->collection_id ? 'updated':'created'));
        $this->dispatch('refreshDatatable');
        $this->dispatch('modalClose', 'addApiModal');

    }

    public function apiEdit($id)
    {
        $Collection = Collection::find($id);

        if (!$Collection) {
            $this->alert('error', "Api Not Find");
            return;
        }

        $this->collection_id = $id;
        $this->title = $Collection->title;
        $this->des = $Collection->des;
        $this->request_url = $Collection->request_url;
        $this->response_type = $Collection->response_type;
        $this->request_type = $Collection->request_type;
        $this->request_limit = $Collection->request_limit;
        $this->is_ftp = $Collection->is_ftp ? true : null;
        $this->status = $Collection->status;

    }

    public function render()
    {
        return view('pages.himsapi.collection-list');
    }
}
